/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.biome.cave;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_7243;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.bclib.util.WeightedList;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.cave.EndCaveBiome;

public class JadeCaveBiome
extends EndCaveBiome.Config {
    public static final Codec<Biome> CODEC = EndCaveBiome.simpleCaveBiomeCodec(Biome::new);
    public static final class_7243<Biome> KEY_CODEC = class_7243.method_42115(CODEC);

    public JadeCaveBiome() {
        super("jade_cave");
    }

    @Override
    protected void addCustomBuildData(BCLBiomeBuilder builder) {
        super.addCustomBuildData(builder);
        builder.fogColor(118, 150, 112).fogDensity(2.0f).waterAndFogColor(95, 223, 255);
    }

    @Override
    public BCLBiomeBuilder.BiomeSupplier<EndBiome> getSupplier() {
        return Biome::new;
    }

    public static class Biome
    extends EndCaveBiome {
        private static final OpenSimplexNoise WALL_NOISE = new OpenSimplexNoise("jade_cave".hashCode());
        private static final OpenSimplexNoise DEPTH_NOISE = new OpenSimplexNoise("depth_noise".hashCode());
        private static final class_2680[] JADE = new class_2680[3];

        public Biome(class_5321<class_1959> biomeID, BCLBiomeSettings settings) {
            super(biomeID, settings);
        }

        @Override
        public class_7243<? extends BCLBiome> codec() {
            return KEY_CODEC;
        }

        protected Biome(float terrainHeight, float fogDensity, float genChance, int edgeSize, boolean vertical, Optional<class_2960> edge, class_2960 biomeID, Optional<List<class_6544.class_4762>> parameterPoints, Optional<class_2960> biomeParent, Optional<String> intendedType, boolean hasCaves, SurfaceMaterialProvider surface, WeightedList<class_6880<class_2975<?, ?>>> floorFeatures, WeightedList<class_6880<class_2975<?, ?>>> ceilFeatures) {
            super(terrainHeight, fogDensity, genChance, edgeSize, vertical, edge, biomeID, parameterPoints, biomeParent, intendedType, hasCaves, surface, floorFeatures, ceilFeatures);
        }

        @Override
        public class_2680 getWall(class_2338 pos) {
            double depth = DEPTH_NOISE.eval((double)pos.method_10263() * 0.02, (double)pos.method_10260() * 0.02) * 0.2 + 0.5;
            int index = class_3532.method_15357((double)(((double)pos.method_10264() + WALL_NOISE.eval((double)pos.method_10263() * 0.2, (double)pos.method_10260() * 0.2) * 1.5) * depth + 0.5));
            index = class_3532.method_15382((int)index) % 3;
            return JADE[index];
        }

        static {
            Biome.JADE[0] = EndBlocks.VIRID_JADESTONE.stone.method_9564();
            Biome.JADE[1] = EndBlocks.AZURE_JADESTONE.stone.method_9564();
            Biome.JADE[2] = EndBlocks.SANDY_JADESTONE.stone.method_9564();
        }
    }
}

