/*
 * Decompiled with CFR 0.152.
 */
package io.github.blanketmc.blanket.utils;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class EnumArgumentType<T extends Enum<T>>
implements ArgumentType<T> {
    protected final Class<T> clazz;
    protected final List<String> values;

    protected EnumArgumentType(Class<T> enumClass, Predicate<String> include) {
        this.clazz = enumClass;
        this.values = new ArrayList<String>();
        ArrayList<String> values = this.values;
        for (Field field : enumClass.getDeclaredFields()) {
            String value = field.getName();
            if (!include.test(value)) continue;
            values.add(value);
        }
    }

    protected EnumArgumentType(Class<T> enumClass) {
        this.clazz = enumClass;
        this.values = new ArrayList<String>();
        ArrayList<String> values = this.values;
        for (Field field : enumClass.getDeclaredFields()) {
            values.add(field.getName());
        }
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        return Enum.valueOf(this.clazz, reader.readString().toUpperCase());
    }

    public static <T extends Enum<T>> EnumArgumentType<T> enumeration(Class<T> enumClass) {
        return new EnumArgumentType<T>(enumClass);
    }

    public List<String> getValues() {
        return this.values;
    }
}

