/*
 * Decompiled with CFR 0.152.
 */
package io.github.blanketmc.blanket.fixes;

import io.github.blanketmc.blanket.Config;
import javax.annotation.Nullable;
import net.minecraft.class_1695;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class RotatePlayerWithMinecart {
    public static boolean smoothMode = true;
    private static float yaw = 0.0f;
    private static boolean doCorrection;
    @Nullable
    private static class_243 gotVelocity;
    @Nullable
    private static class_243 posVelocity;
    @Nullable
    private static class_243 lastCoord;
    private static float lastYaw;
    private static class_243 lastVelocity;
    private static float rawLastYaw;
    private static float rawYaw;
    private static int tickAfterLastFollow;
    private static int tickAfterPistonRail;
    private static int pistorRailTick;
    private static float difference;
    private static int lastSlowdown;

    public static void update(class_1695 minecart) {
        lastYaw = yaw;
        boolean update = RotatePlayerWithMinecart.calculateNewDirection(minecart);
        if (tickAfterLastFollow++ > Config.rotatePlayerWithMinecart_threshold) {
            lastYaw = yaw;
        } else if (doCorrection) {
            lastYaw = RotatePlayerWithMinecart.normalize(Float.valueOf(lastYaw + 180.0f));
        }
        doCorrection = false;
        if (update) {
            tickAfterLastFollow = 0;
        }
        difference = RotatePlayerWithMinecart.normalize(Float.valueOf(yaw - lastYaw));
    }

    public static boolean calculateNewDirection(class_1695 minecart) {
        boolean update = false;
        float yawF = rawYaw;
        boolean correction = false;
        boolean successUpdate = RotatePlayerWithMinecart.updateSmartCorrection(minecart);
        if (minecart.method_18798().method_1027() > (double)2.0E-6f) {
            if (tickAfterPistonRail != Config.rotatePlayerWithMinecart_threshold) {
                ++tickAfterPistonRail;
            }
            if (pistorRailTick != 0) {
                --pistorRailTick;
            }
            yawF = RotatePlayerWithMinecart.sphericalFromVec3d(minecart.method_18798());
            update = true;
            correction = true;
        } else if (minecart.method_18798().method_1027() == 0.0 && successUpdate && posVelocity.method_1027() > (double)0.02f) {
            if (pistorRailTick != Config.rotatePlayerWithMinecart_threshold) {
                ++pistorRailTick;
            } else {
                tickAfterPistonRail = 0;
            }
            yawF = RotatePlayerWithMinecart.getEighthDirection(Float.valueOf(RotatePlayerWithMinecart.sphericalFromVec3d(posVelocity)));
            update = true;
        } else if (pistorRailTick != 0) {
            --pistorRailTick;
        }
        rawLastYaw = rawYaw;
        rawYaw = yawF;
        if (correction) {
            RotatePlayerWithMinecart.checkSmartCorrection(successUpdate);
        }
        RotatePlayerWithMinecart.calculateNewDirection(yawF);
        return update;
    }

    private static float sphericalFromVec3d(class_243 vec3d) {
        return (float)(class_3532.method_15349((double)(-vec3d.field_1352), (double)vec3d.field_1350) * 57.2957763671875);
    }

    public static void onStartRiding() {
        lastCoord = null;
        tickAfterLastFollow = 100;
        lastVelocity = class_243.field_1353;
        lastSlowdown = 100;
        tickAfterPistonRail = Config.rotatePlayerWithMinecart_threshold;
        pistorRailTick = 0;
    }

    private static void calculateNewDirection(float yawF) {
        if (smoothMode) {
            float tmp;
            if (!Config.rotatePlayerWithMinecart_alwaysLookForward && tickAfterLastFollow > Config.rotatePlayerWithMinecart_threshold) {
                yaw = yawF;
            } else if (doCorrection) {
                yaw = RotatePlayerWithMinecart.normalize(Float.valueOf(yaw + 180.0f));
            }
            yaw = Math.abs(yawF - yaw) < 180.0f ? yaw / 2.0f + yawF / 2.0f : ((tmp = yaw / 2.0f + yawF / 2.0f) >= 0.0f ? tmp - 180.0f : tmp + 180.0f);
        } else {
            yaw = yawF;
        }
    }

    private static void checkSmartCorrection(boolean successUpdate) {
        boolean correction = false;
        if (Config.rotatePlayerWithMinecart_smartMode) {
            float ang = 60.0f;
            if (tickAfterPistonRail == Config.rotatePlayerWithMinecart_threshold && RotatePlayerWithMinecart.floatCircleDistance(rawLastYaw, rawYaw, 360.0f) > 180.0f - ang && RotatePlayerWithMinecart.floatCircleDistance(rawLastYaw, rawYaw, 360.0f) < 180.0f + ang) {
                correction = true;
                if (successUpdate) {
                    boolean bl2;
                    boolean bl1 = posVelocity.method_1027() > (double)4.0E-5f && Math.abs(posVelocity.method_1029().method_1026(gotVelocity.method_1029())) < (double)0.8f;
                    boolean bl = bl2 = !bl1 || lastSlowdown < Config.rotatePlayerWithMinecart_threshold && Math.abs(posVelocity.method_1029().method_1026(gotVelocity.method_1029())) < (double)0.866f && gotVelocity.method_1027() < 0.32;
                    if (bl1 && !bl2) {
                        correction = false;
                    }
                }
            }
        }
        doCorrection = correction;
    }

    private static boolean updateSmartCorrection(class_1695 minecart) {
        boolean success = lastCoord != null;
        class_243 pos = minecart.method_19538();
        if (success) {
            posVelocity = new class_243(pos.field_1352 - RotatePlayerWithMinecart.lastCoord.field_1352, 0.0, pos.field_1350 - RotatePlayerWithMinecart.lastCoord.field_1350);
            lastVelocity = gotVelocity == null ? new class_243(0.0, 0.0, 0.0) : gotVelocity;
            gotVelocity = new class_243(minecart.method_18798().method_10216(), 0.0, minecart.method_18798().method_10215());
            if (gotVelocity.method_1033() != 0.0 && lastVelocity.method_1033() / gotVelocity.method_1033() > 2.4) {
                lastSlowdown = 0;
            }
            ++lastSlowdown;
        }
        lastCoord = pos;
        return success;
    }

    public static float calcYaw(float entityYaw) {
        return Config.rotatePlayerWithMinecart_alwaysLookForward ? entityYaw + RotatePlayerWithMinecart.normalize(Float.valueOf(yaw - entityYaw)) : entityYaw + difference;
    }

    private static float normalize(Float f) {
        return Math.abs(f.floatValue()) > 180.0f ? (f.floatValue() < 0.0f ? f.floatValue() + 360.0f : f.floatValue() - 360.0f) : f.floatValue();
    }

    private static float getEighthDirection(Float f) {
        if (RotatePlayerWithMinecart.floatCircleDistance(f.floatValue() % 90.0f, 0.0f, 90.0f) < 20.0f) {
            return (float)Math.round(f.floatValue() / 90.0f) * 90.0f;
        }
        return f.floatValue();
    }

    private static float floatCircleDistance(float i1, float i2, float size) {
        float dist1 = Math.abs(i1 - i2);
        return Math.min(dist1, Math.abs(dist1 - size));
    }

    static {
        gotVelocity = null;
        posVelocity = null;
        lastCoord = null;
        lastYaw = 0.0f;
        tickAfterLastFollow = 0;
        pistorRailTick = 0;
        lastSlowdown = 0;
    }
}

