/*
 * Decompiled with CFR 0.152.
 */
package io.github.blanketmc.blanket.config.screen.util;

import io.github.blanketmc.blanket.ClientFixes;
import io.github.blanketmc.blanket.config.ConfigHelper;
import io.github.blanketmc.blanket.config.EntryListener;
import java.lang.reflect.Field;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.DoubleFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.EnumSelectorBuilder;
import me.shedaniel.clothconfig2.impl.builders.FloatFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.LongFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.TextFieldBuilder;
import net.minecraft.class_2561;
import org.apache.logging.log4j.Level;

public abstract class AbstractConfigElementBuilder {
    protected final Field configField;

    public AbstractConfigElementBuilder(Field field) {
        this.configField = field;
    }

    protected abstract class_2561 getTooltip();

    protected abstract class_2561 getText();

    protected Class<? extends EntryListener>[] getListeners() {
        return new Class[0];
    }

    public AbstractConfigListEntry<?> createConfigEntry() throws IllegalAccessException {
        ConfigEntryBuilder entryBuilder = ConfigEntryBuilder.create();
        Class<?> type = this.configField.getType();
        if (type.equals(Boolean.TYPE)) {
            BooleanToggleBuilder entry = entryBuilder.startBooleanToggle(this.getText(), this.configField.getBoolean(null));
            entry.setSaveConsumer(aBoolean -> {
                try {
                    if (this.getListeners().length > 0) {
                        Boolean currentValue = this.configField.getBoolean(null);
                        for (Class<? extends EntryListener> listener : this.getListeners()) {
                            aBoolean = ConfigHelper.callClassConstructor(listener).onEntryChange(currentValue, aBoolean);
                        }
                    }
                    this.configField.set(null, aBoolean);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            });
            entry.setDefaultValue(((Boolean)ConfigHelper.getDefaultValue(this.configField)).booleanValue());
            entry.setTooltip(new class_2561[]{this.getTooltip()});
            return entry.build();
        }
        if (type.equals(Float.TYPE)) {
            FloatFieldBuilder entry = entryBuilder.startFloatField(this.getText(), this.configField.getFloat(null));
            entry.setSaveConsumer(aFloat -> {
                try {
                    if (this.getListeners().length > 0) {
                        Float currentValue = Float.valueOf(this.configField.getFloat(null));
                        for (Class<? extends EntryListener> listener : this.getListeners()) {
                            aFloat = ConfigHelper.callClassConstructor(listener).onEntryChange(currentValue, aFloat);
                        }
                    }
                    this.configField.set(null, aFloat);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            });
            entry.setDefaultValue(((Float)ConfigHelper.getDefaultValue(this.configField)).floatValue());
            entry.setTooltip(new class_2561[]{this.getTooltip()});
            return entry.build();
        }
        if (type.equals(Double.TYPE)) {
            DoubleFieldBuilder entry = entryBuilder.startDoubleField(this.getText(), this.configField.getDouble(null));
            entry.setSaveConsumer(aDouble -> {
                try {
                    if (this.getListeners().length > 0) {
                        Double currentValue = this.configField.getDouble(null);
                        for (Class<? extends EntryListener> listener : this.getListeners()) {
                            aDouble = ConfigHelper.callClassConstructor(listener).onEntryChange(currentValue, aDouble);
                        }
                    }
                    this.configField.set(null, aDouble);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            });
            entry.setDefaultValue(((Double)ConfigHelper.getDefaultValue(this.configField)).doubleValue());
            entry.setTooltip(new class_2561[]{this.getTooltip()});
            return entry.build();
        }
        if (type.equals(Integer.TYPE)) {
            IntFieldBuilder entry = entryBuilder.startIntField(this.getText(), this.configField.getInt(null));
            entry.setSaveConsumer(aInt -> {
                try {
                    if (this.getListeners().length > 0) {
                        Integer currentValue = this.configField.getInt(null);
                        for (Class<? extends EntryListener> listener : this.getListeners()) {
                            aInt = ConfigHelper.callClassConstructor(listener).onEntryChange(currentValue, aInt);
                        }
                    }
                    this.configField.set(null, aInt);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            });
            entry.setDefaultValue(((Integer)ConfigHelper.getDefaultValue(this.configField)).intValue());
            entry.setTooltip(new class_2561[]{this.getTooltip()});
            return entry.build();
        }
        if (type.equals(Long.TYPE)) {
            LongFieldBuilder entry = entryBuilder.startLongField(this.getText(), this.configField.getLong(null));
            entry.setSaveConsumer(aLong -> {
                try {
                    if (this.getListeners().length > 0) {
                        Long currentValue = this.configField.getLong(null);
                        for (Class<? extends EntryListener> listener : this.getListeners()) {
                            aLong = ConfigHelper.callClassConstructor(listener).onEntryChange(currentValue, aLong);
                        }
                    }
                    this.configField.set(null, aLong);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            });
            entry.setDefaultValue(((Long)ConfigHelper.getDefaultValue(this.configField)).longValue());
            entry.setTooltip(new class_2561[]{this.getTooltip()});
            return entry.build();
        }
        if (type.equals(String.class)) {
            TextFieldBuilder entry = entryBuilder.startTextField(this.getText(), (String)this.configField.get(null));
            entry.setSaveConsumer(aString -> {
                try {
                    if (this.getListeners().length > 0) {
                        String currentValue = (String)this.configField.get(null);
                        for (Class<? extends EntryListener> listener : this.getListeners()) {
                            aString = ConfigHelper.callClassConstructor(listener).onEntryChange(currentValue, aString);
                        }
                    }
                    this.configField.set(null, aString);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            });
            entry.setDefaultValue((String)ConfigHelper.getDefaultValue(this.configField));
            entry.setTooltip(new class_2561[]{this.getTooltip()});
            return entry.build();
        }
        if (type.isEnum()) {
            Class<?> clazz = type;
            Object obj = this.configField.get(null);
            EnumSelectorBuilder entry = entryBuilder.startEnumSelector(this.getText(), clazz, (Enum)clazz.cast(obj));
            entry.setSaveConsumer(anEnum -> {
                try {
                    if (this.getListeners().length > 0) {
                        Enum currentValue = (Enum)clazz.cast(this.configField.get(null));
                        for (Class<? extends EntryListener> listener : this.getListeners()) {
                            anEnum = ConfigHelper.callClassConstructor(listener).onEntryChange(currentValue, anEnum);
                        }
                    }
                    this.configField.set(null, anEnum);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            });
            Object defVal = ConfigHelper.getDefaultValue(this.configField);
            entry.setDefaultValue((Enum)clazz.cast(defVal));
            entry.setTooltip(new class_2561[]{this.getTooltip()});
            return entry.build();
        }
        ClientFixes.log(Level.ERROR, "Config: " + this.configField.getName() + " can not be displayed: Unknown type", true);
        throw new UnsupportedOperationException();
    }
}

