/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.network.cache;

import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.GraphEntityContext;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.LinkEntity;
import com.kneelawk.graphlib.api.graph.user.NodeEntity;
import com.kneelawk.graphlib.api.util.LinkPos;
import io.github.mattidragon.extendeddrawers.block.entity.StorageDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.network.cache.NetworkStorageCache;
import io.github.mattidragon.extendeddrawers.storage.DrawerStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleNetworkStorageCache
implements NetworkStorageCache {
    private GraphEntityContext context;
    @Nullable
    private CombinedStorage<ItemVariant, DrawerStorage> cachedStorage = null;
    private boolean updating = false;

    @Override
    public CombinedStorage<ItemVariant, DrawerStorage> get() {
        if (this.cachedStorage == null) {
            this.update();
        }
        return this.cachedStorage;
    }

    private void clear() {
        if (this.updating) {
            return;
        }
        this.cachedStorage = null;
    }

    @Override
    public void update() {
        try {
            this.updating = true;
            this.cachedStorage = new CombinedStorage(new ArrayList());
            this.context.getGraph().getNodes().forEach(node -> {
                class_2586 patt2296$temp = node.getBlockEntity();
                if (patt2296$temp instanceof StorageDrawerBlockEntity) {
                    StorageDrawerBlockEntity drawer = (StorageDrawerBlockEntity)patt2296$temp;
                    drawer.streamStorages().forEach(storage -> this.cachedStorage.parts.add(storage));
                }
            });
            this.cachedStorage.parts.sort(null);
        }
        finally {
            this.updating = false;
        }
    }

    @Override
    public void forceUpdate() {
        this.update();
    }

    @Override
    public void onSortingChanged() {
        if (this.cachedStorage != null) {
            this.cachedStorage.parts.sort(null);
        }
    }

    @Override
    public void onNodeCreated(@NotNull NodeHolder<BlockNode> node, @Nullable NodeEntity nodeEntity) {
        this.clear();
    }

    @Override
    public void onNodeDestroyed(@NotNull NodeHolder<BlockNode> node, @Nullable NodeEntity nodeEntity, Map<LinkPos, LinkEntity> linkEntities) {
        this.clear();
    }

    @Override
    public void onNodeUnloaded(class_2338 pos) {
        this.clear();
    }

    @Override
    public void onNodeReloaded(class_2338 pos) {
        this.clear();
    }

    @Override
    @NotNull
    public NetworkStorageCache split(@NotNull BlockGraph originalGraph, @NotNull BlockGraph newGraph) {
        this.clear();
        return new SimpleNetworkStorageCache();
    }

    @Override
    public List<class_2561> getDebugInfo() {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        list.add((class_2561)class_2561.method_43470((String)"Simple Storage Cache Debug Info").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054}));
        list.add((class_2561)class_2561.method_43470((String)"  Cached: %s".formatted(this.cachedStorage != null)));
        return list;
    }

    @Override
    public class_2561 getDebugInfo(class_2338 pos) {
        return class_2561.method_43470((String)"-");
    }

    public void onInit(@NotNull GraphEntityContext ctx) {
        this.context = ctx;
    }

    @NotNull
    public GraphEntityContext getContext() {
        return this.context;
    }

    public void merge(@NotNull NetworkStorageCache other) {
        this.clear();
    }
}

