/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.network;

import com.kneelawk.graphlib.api.graph.GraphEntityContext;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.GraphEntity;
import com.kneelawk.graphlib.api.graph.user.GraphEntityType;
import io.github.mattidragon.extendeddrawers.network.NetworkRegistry;
import io.github.mattidragon.extendeddrawers.network.cache.NetworkStorageCache;
import io.github.mattidragon.extendeddrawers.network.node.DrawerNetworkBlockNode;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateHandler
implements GraphEntity<UpdateHandler> {
    private GraphEntityContext context;
    @Nullable
    private ChangeType queuedUpdate;

    public static void scheduleUpdate(class_3218 world, class_2338 pos, ChangeType type) {
        NetworkRegistry.UNIVERSE.getServerGraphWorld(world).getLoadedGraphsAt(pos).map(graph -> (UpdateHandler)graph.getGraphEntity(NetworkRegistry.UPDATE_HANDLER_TYPE)).forEach(updateHandler -> updateHandler.scheduleUpdate(type));
    }

    public void scheduleUpdate(ChangeType type) {
        this.queuedUpdate = (ChangeType)((Object)ObjectUtils.max((Comparable[])new ChangeType[]{this.queuedUpdate, type}));
    }

    public void onTick() {
        if (this.queuedUpdate == null) {
            return;
        }
        class_1937 class_19372 = this.context.getBlockWorld();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        NetworkStorageCache networkStorageCache = (NetworkStorageCache)this.context.getGraph().getGraphEntity(NetworkRegistry.STORAGE_CACHE_TYPE);
        if (this.queuedUpdate == ChangeType.CONTENT) {
            networkStorageCache.onSortingChanged();
        }
        this.context.getGraph().getNodes().forEach(node -> {
            BlockNode patt1898$temp = node.getNode();
            if (patt1898$temp instanceof DrawerNetworkBlockNode) {
                DrawerNetworkBlockNode drawerNode = (DrawerNetworkBlockNode)patt1898$temp;
                drawerNode.update(world, (NodeHolder<BlockNode>)node);
            }
        });
        this.queuedUpdate = null;
    }

    public void onInit(@NotNull GraphEntityContext context) {
        this.context = context;
    }

    @NotNull
    public GraphEntityContext getContext() {
        return this.context;
    }

    @NotNull
    public GraphEntityType<?> getType() {
        return NetworkRegistry.UPDATE_HANDLER_TYPE;
    }

    @Nullable
    public class_2520 toTag() {
        return null;
    }

    public void onUpdate() {
        this.scheduleUpdate(ChangeType.STRUCTURE);
    }

    public void merge(@NotNull UpdateHandler other) {
    }

    public static enum ChangeType {
        COUNT,
        CONTENT,
        STRUCTURE;

    }
}

