/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.results;

import com.almostreliable.lootjs.LootJSPlatform;
import com.almostreliable.lootjs.LootModificationsAPI;
import com.almostreliable.lootjs.core.ILootContextData;
import com.almostreliable.lootjs.core.LootJSParamSets;
import com.almostreliable.lootjs.loot.results.Info;
import com.almostreliable.lootjs.loot.results.LootInfoCollector;
import com.almostreliable.lootjs.util.LootContextUtils;
import com.almostreliable.lootjs.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_47;

public class LootContextInfo {
    LootInfoCollector collector = new LootInfoCollector();

    private LootContextInfo() {
    }

    @Nullable
    public static LootContextInfo create(class_47 context) {
        if (!LootModificationsAPI.LOOT_MODIFICATION_LOGGING) {
            return null;
        }
        LootContextInfo lci = new LootContextInfo();
        lci.add("LootTable", Utils.quote(LootJSPlatform.INSTANCE.getQueriedLootTableId(context)));
        ILootContextData data = (ILootContextData)context.method_296(LootJSParamSets.DATA);
        if (data != null) {
            lci.add("LootType", data.getLootContextType().name());
            lci.updateLoot(data.getGeneratedLoot());
        }
        class_243 origin = (class_243)context.method_296(class_181.field_24424);
        lci.addOptional("Position", origin, Utils::formatPosition);
        lci.addOptional("Block", (class_2680)context.method_296(class_181.field_1224));
        lci.addOptional("Explosion", (Float)context.method_296(class_181.field_1225));
        lci.addOptional("Entity", (class_1297)context.method_296(class_181.field_1226), Utils::formatEntity);
        lci.addOptional("Killer Entity", (class_1297)context.method_296(class_181.field_1230), Utils::formatEntity);
        lci.addOptional("Direct Killer", (class_1297)context.method_296(class_181.field_1227), Utils::formatEntity);
        class_3222 player = LootContextUtils.getPlayerOrNull(context);
        if (player != null) {
            lci.addOptional("Player", player, Utils::formatEntity);
            lci.addOptional("Player Pos", player.method_19538(), Utils::formatPosition);
            if (origin != null) {
                lci.addOptional("Distance", String.format("%.2f", player.method_19538().method_1022(origin)));
            }
            lci.addItem("MainHand", player.method_6118(class_1304.field_6173));
            lci.addItem("OffHand", player.method_6118(class_1304.field_6171));
            lci.addItem("Head", player.method_6118(class_1304.field_6169));
            lci.addItem("Chest", player.method_6118(class_1304.field_6174));
            lci.addItem("Legs", player.method_6118(class_1304.field_6172));
            lci.addItem("Feet", player.method_6118(class_1304.field_6166));
        }
        return lci;
    }

    private void add(String left, String right) {
        this.collector.addOrPush(new Info.RowInfo(left, right));
    }

    private <T> void addOptional(String left, @Nullable T t, Function<T, String> formatter) {
        if (t == null) {
            return;
        }
        this.add(left, formatter.apply(t));
    }

    private <T> void addOptional(String left, @Nullable T t) {
        if (t == null) {
            return;
        }
        this.add(left, t.toString());
    }

    private void addItem(String left, class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return;
        }
        this.add(left, Utils.formatItemStack(itemStack));
    }

    public void updateLoot(Collection<class_1799> loot) {
        LootComposite lootComposite = this.collector.getFirstLayer().stream().filter(LootComposite.class::isInstance).findFirst().orElse(null);
        if (lootComposite == null) {
            LootComposite lc = new LootComposite();
            this.collector.add(lc);
            this.updateLoot(loot, lc.getBefore());
        } else {
            this.updateLoot(loot, lootComposite.getAfter());
        }
    }

    private void updateLoot(Collection<class_1799> loot, Info.Composite composite) {
        for (class_1799 itemStack : loot) {
            composite.addChildren(new Info.TitledInfo(Utils.formatItemStack(itemStack)));
        }
    }

    public LootInfoCollector getCollector() {
        return this.collector;
    }

    public static class LootComposite
    extends Info.Composite {
        private final Info.Composite before = new Info.Composite("Before");
        private final Info.Composite after = new Info.Composite("After");

        public LootComposite() {
            super("Loot");
            this.children.add(this.before);
            this.children.add(this.after);
        }

        @Override
        public void addChildren(Info info) {
            throw new UnsupportedOperationException("LootComposite cannot add custom children");
        }

        @Override
        public Collection<Info> getChildren() {
            ArrayList<Info> c = new ArrayList<Info>();
            c.add(this.before.getChildren().isEmpty() ? new Info.TitledInfo("before {}") : this.before);
            c.add(this.after.getChildren().isEmpty() ? new Info.TitledInfo("after {}") : this.after);
            return c;
        }

        public Info.Composite getBefore() {
            return this.before;
        }

        public Info.Composite getAfter() {
            return this.after;
        }
    }
}

