/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco;

import com.github.talrey.createdeco.CreateDecoMod;
import com.github.talrey.createdeco.api.CDTags;
import com.github.talrey.createdeco.api.Coins;
import com.github.talrey.createdeco.items.CoinStackItem;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_6862;
import net.minecraft.class_7800;

public class ItemRegistry {
    public static ItemEntry<class_1792> ANDESITE_SHEET;
    public static ItemEntry<class_1792> ZINC_SHEET;
    public static ItemEntry<class_1792> NETHERITE_SHEET;
    public static ItemEntry<class_1792> NETHERITE_NUGGET;
    public static ItemEntry<class_1792> INDUSTRIAL_IRON_NUGGET;
    public static ItemEntry<class_1792> INDUSTRIAL_IRON_INGOT;
    public static ItemEntry<class_1792> INDUSTRIAL_IRON_SHEET;
    public static HashMap<String, Function<String, class_1792>> METAL_TYPES;
    public static HashMap<String, Function<String, class_1792>> COIN_METALS;
    public static HashMap<String, ItemEntry<class_1792>> COINS;
    public static HashMap<String, ItemEntry<CoinStackItem>> COINSTACKS;

    public static void init() {
        CreateDecoMod.LOGGER.info("Registering items for Create Deco");
        CreateDecoMod.REGISTRATE.defaultCreativeTab("props_tab");
        ItemRegistry.registerSheets();
        ItemRegistry.registerNuggets();
        ItemRegistry.registerIngots();
        METAL_TYPES.put("Andesite", str -> (class_1792)AllItems.ANDESITE_ALLOY.get());
        METAL_TYPES.put("Zinc", str -> (class_1792)AllItems.ZINC_INGOT.get());
        METAL_TYPES.put("Copper", str -> class_1802.field_27022);
        METAL_TYPES.put("Brass", str -> (class_1792)AllItems.BRASS_INGOT.get());
        METAL_TYPES.put("Iron", str -> class_1802.field_8620);
        METAL_TYPES.put("Industrial Iron", str -> (class_1792)INDUSTRIAL_IRON_INGOT.get());
        COIN_METALS.put("Zinc", str -> (class_1792)AllItems.ZINC_INGOT.get());
        COIN_METALS.put("Copper", str -> class_1802.field_27022);
        COIN_METALS.put("Brass", str -> (class_1792)AllItems.BRASS_INGOT.get());
        COIN_METALS.put("Iron", str -> class_1802.field_8620);
        COIN_METALS.put("Industrial Iron", str -> (class_1792)INDUSTRIAL_IRON_INGOT.get());
        COIN_METALS.put("Gold", str -> class_1802.field_8695);
        COIN_METALS.put("Netherite", str -> class_1802.field_22020);
        COIN_METALS.forEach(ItemRegistry::registerCoins);
    }

    private static void registerSheets() {
        ANDESITE_SHEET = CreateDecoMod.REGISTRATE.item("andesite_sheet", class_1792::new).tag(new class_6862[]{CDTags.of((String)"andesite", (String)"plates").tag}).lang("Andesite Alloy Sheet").register();
        ZINC_SHEET = CreateDecoMod.REGISTRATE.item("zinc_sheet", class_1792::new).tag(new class_6862[]{CDTags.of((String)"zinc", (String)"plates").tag}).lang("Zinc Sheet").register();
        NETHERITE_SHEET = CreateDecoMod.REGISTRATE.item("netherite_sheet", class_1792::new).properties(class_1792.class_1793::method_24359).tag(new class_6862[]{CDTags.of((String)"netherite", (String)"plates").tag}).lang("Netherite Sheet").register();
        INDUSTRIAL_IRON_SHEET = CreateDecoMod.REGISTRATE.item("industrial_iron_sheet", class_1792::new).tag(new class_6862[]{CDTags.of((String)"industrial_iron", (String)"plates").tag}).lang("Industrial Iron Sheet").register();
    }

    private static void registerNuggets() {
        NETHERITE_NUGGET = CreateDecoMod.REGISTRATE.item("netherite_nugget", class_1792::new).properties(class_1792.class_1793::method_24359).tag(new class_6862[]{CDTags.of((String)"netherite", (String)"nuggets").tag}).lang("Netherite Nugget").recipe((ctx, prov) -> prov.storage((NonNullSupplier)ctx, class_7800.field_40642, () -> class_1802.field_22020)).register();
        INDUSTRIAL_IRON_NUGGET = CreateDecoMod.REGISTRATE.item("industrial_iron_nugget", class_1792::new).tag(new class_6862[]{CDTags.of((String)"industrial_iron", (String)"nuggets").tag}).lang("Industrial Iron Nugget").recipe((ctx, prov) -> prov.storage((NonNullSupplier)ctx, class_7800.field_40642, INDUSTRIAL_IRON_INGOT)).register();
    }

    private static void registerIngots() {
        INDUSTRIAL_IRON_INGOT = CreateDecoMod.REGISTRATE.item("industrial_iron_ingot", class_1792::new).tag(new class_6862[]{CDTags.of((String)"industrial_iron", (String)"ingots").tag}).lang("Industrial Iron Ingot").recipe((ctx, prov) -> prov.storage((NonNullSupplier)ctx, class_7800.field_40642, (NonNullSupplier)AllBlocks.INDUSTRIAL_IRON_BLOCK)).register();
    }

    private static void registerCoins(String metal, Function<String, class_1792> getter) {
        if (metal.equals("Andesite")) {
            return;
        }
        COINS.put(metal, (ItemEntry<class_1792>)Coins.buildCoinItem(CreateDecoMod.REGISTRATE, (NonNullSupplier<class_1792>)((NonNullSupplier)() -> (class_1792)COINSTACKS.get(metal).get()), metal).register());
        COINSTACKS.put(metal, (ItemEntry<CoinStackItem>)Coins.buildCoinStackItem(CreateDecoMod.REGISTRATE, (NonNullSupplier<class_1792>)((NonNullSupplier)() -> (class_1792)COINS.get(metal).get()), metal).register());
    }

    static {
        METAL_TYPES = new HashMap();
        COIN_METALS = new HashMap();
        COINS = new HashMap();
        COINSTACKS = new HashMap();
    }
}

