/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.internal;

import io.ktor.utils.io.internal.ReadWriteBufferState;
import io.ktor.utils.io.internal.UtilsKt;
import io.ktor.utils.io.pool.DefaultPool;
import io.ktor.utils.io.pool.DirectByteBufferPool;
import io.ktor.utils.io.pool.NoPoolImpl;
import io.ktor.utils.io.pool.ObjectPool;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u0014\u0010\u0001\u001a\u00020\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0001\u0010\u0002\"\u0014\u0010\u0003\u001a\u00020\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0002\"\u001a\u0010\u0004\u001a\u00020\u00008\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0002\u001a\u0004\b\u0005\u0010\u0006\" \u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\" \u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\u000e\u0010\f\" \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00078\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010\n\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u0012"}, d2={"", "BUFFER_OBJECT_POOL_SIZE", "I", "BUFFER_POOL_SIZE", "BUFFER_SIZE", "getBUFFER_SIZE", "()I", "Lio/ktor/utils/io/pool/ObjectPool;", "Lio/ktor/utils/io/internal/ReadWriteBufferState$Initial;", "BufferObjectNoPool", "Lio/ktor/utils/io/pool/ObjectPool;", "getBufferObjectNoPool", "()Lio/ktor/utils/io/pool/ObjectPool;", "BufferObjectPool", "getBufferObjectPool", "Ljava/nio/ByteBuffer;", "BufferPool", "getBufferPool", "ktor-io"})
public final class ObjectPoolKt {
    private static final int BUFFER_SIZE = UtilsKt.getIOIntProperty("BufferSize", 4096);
    private static final int BUFFER_POOL_SIZE = UtilsKt.getIOIntProperty("BufferPoolSize", 2048);
    private static final int BUFFER_OBJECT_POOL_SIZE = UtilsKt.getIOIntProperty("BufferObjectPoolSize", 1024);
    @NotNull
    private static final ObjectPool<ByteBuffer> BufferPool = new DirectByteBufferPool(BUFFER_POOL_SIZE, BUFFER_SIZE);
    @NotNull
    private static final ObjectPool<ReadWriteBufferState.Initial> BufferObjectPool;
    @NotNull
    private static final ObjectPool<ReadWriteBufferState.Initial> BufferObjectNoPool;

    public static final int getBUFFER_SIZE() {
        return BUFFER_SIZE;
    }

    @NotNull
    public static final ObjectPool<ByteBuffer> getBufferPool() {
        return BufferPool;
    }

    @NotNull
    public static final ObjectPool<ReadWriteBufferState.Initial> getBufferObjectPool() {
        return BufferObjectPool;
    }

    @NotNull
    public static final ObjectPool<ReadWriteBufferState.Initial> getBufferObjectNoPool() {
        return BufferObjectNoPool;
    }

    static {
        int n = BUFFER_OBJECT_POOL_SIZE;
        BufferObjectPool = new DefaultPool<ReadWriteBufferState.Initial>(n){

            @NotNull
            protected ReadWriteBufferState.Initial produceInstance() {
                return new ReadWriteBufferState.Initial(ObjectPoolKt.getBufferPool().borrow(), 0, 2, null);
            }

            protected void disposeInstance(@NotNull ReadWriteBufferState.Initial instance) {
                Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
                ObjectPoolKt.getBufferPool().recycle(instance.backingBuffer);
            }
        };
        BufferObjectNoPool = new NoPoolImpl<ReadWriteBufferState.Initial>(){

            @NotNull
            public ReadWriteBufferState.Initial borrow() {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(ObjectPoolKt.getBUFFER_SIZE());
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocateDirect(BUFFER_SIZE)");
                return new ReadWriteBufferState.Initial(byteBuffer, 0, 2, null);
            }
        };
    }
}

