/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.converters;

import io.ktor.util.KtorDsl;
import io.ktor.util.converters.ConversionService;
import io.ktor.util.converters.DefaultConversionService;
import io.ktor.util.converters.DelegatingConversionService;
import io.ktor.util.reflect.TypeInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\b\u001a\u0004\u0018\u00010\u00072\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u00010\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lio/ktor/util/converters/DataConversion;", "Lio/ktor/util/converters/ConversionService;", "", "", "values", "Lio/ktor/util/reflect/TypeInfo;", "type", "", "fromValues", "(Ljava/util/List;Lio/ktor/util/reflect/TypeInfo;)Ljava/lang/Object;", "value", "toValues", "(Ljava/lang/Object;)Ljava/util/List;", "", "Lkotlin/reflect/KClass;", "converters", "Ljava/util/Map;", "Lio/ktor/util/converters/DataConversion$Configuration;", "configuration", "<init>", "(Lio/ktor/util/converters/DataConversion$Configuration;)V", "Configuration", "ktor-utils"})
public final class DataConversion
implements ConversionService {
    @NotNull
    private final Map<KClass<?>, ConversionService> converters;

    public DataConversion(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.converters = MapsKt.toMap(configuration.getConverters$ktor_utils());
    }

    @Override
    @Nullable
    public Object fromValues(@NotNull List<String> values, @NotNull TypeInfo type) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (values.isEmpty()) {
            return null;
        }
        ConversionService conversionService = this.converters.get(type.getType());
        if (conversionService == null) {
            conversionService = DefaultConversionService.INSTANCE;
        }
        ConversionService converter = conversionService;
        return converter.fromValues(values, type);
    }

    @Override
    @NotNull
    public List<String> toValues(@Nullable Object value) {
        Object object = value;
        if (object == null) {
            return CollectionsKt.emptyList();
        }
        Object it = object;
        boolean bl = false;
        KClass type = Reflection.getOrCreateKotlinClass(it.getClass());
        ConversionService conversionService = this.converters.get(type);
        if (conversionService == null) {
            conversionService = DefaultConversionService.INSTANCE;
        }
        ConversionService converter = conversionService;
        return converter.toValues(value);
    }

    @KtorDsl
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J@\u0010\b\u001a\u00020\u0005\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u00012\u001f\b\b\u0010\u0007\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\b\u001a\u00020\u00052\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\b\u0010\u000eJ>\u0010\b\u001a\u00020\u0005\"\b\b\u0000\u0010\u0002*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u000f2\u001d\u0010\u0007\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\b\u0010\u0010R*\u0010\u0012\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\f0\u00118\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0018"}, d2={"Lio/ktor/util/converters/DataConversion$Configuration;", "", "T", "Lkotlin/Function1;", "Lio/ktor/util/converters/DelegatingConversionService$Configuration;", "", "Lkotlin/ExtensionFunctionType;", "configure", "convert", "(Lkotlin/jvm/functions/Function1;)V", "Lkotlin/reflect/KClass;", "type", "Lio/ktor/util/converters/ConversionService;", "convertor", "(Lkotlin/reflect/KClass;Lio/ktor/util/converters/ConversionService;)V", "Lkotlin/reflect/KType;", "(Lkotlin/reflect/KType;Lkotlin/jvm/functions/Function1;)V", "", "converters", "Ljava/util/Map;", "getConverters$ktor_utils", "()Ljava/util/Map;", "<init>", "()V", "ktor-utils"})
    public static final class Configuration {
        @NotNull
        private final Map<KClass<?>, ConversionService> converters = new LinkedHashMap();

        @NotNull
        public final Map<KClass<?>, ConversionService> getConverters$ktor_utils() {
            return this.converters;
        }

        public final void convert(@NotNull KClass<?> type, @NotNull ConversionService convertor) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)convertor, (String)"convertor");
            this.converters.put(type, convertor);
        }

        public final <T> void convert(@NotNull KType type, @NotNull Function1<? super DelegatingConversionService.Configuration<T>, Unit> configure) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(configure, (String)"configure");
            KClassifier kClassifier = type.getClassifier();
            if (kClassifier == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.reflect.KClass<T of io.ktor.util.converters.DataConversion.Configuration.convert>");
            }
            KClass klass = (KClass)kClassifier;
            DelegatingConversionService.Configuration configuration = new DelegatingConversionService.Configuration(klass);
            configure.invoke(configuration);
            DelegatingConversionService.Configuration configuration2 = configuration;
            DelegatingConversionService service = new DelegatingConversionService(klass, configuration2.getDecoder$ktor_utils(), (Function1<Object, ? extends List<String>>)((Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(configuration2.getEncoder$ktor_utils(), (int)1)));
            this.convert(klass, service);
        }

        public final /* synthetic */ <T> void convert(Function1<? super DelegatingConversionService.Configuration<T>, Unit> configure) {
            Intrinsics.checkNotNullParameter(configure, (String)"configure");
            boolean $i$f$convert = false;
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            this.convert(null, configure);
        }
    }
}

