/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0019\u0010\u0003\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0019\u0010\u0003\u001a\u00020\u0000*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0005\u001a\u0013\u0010\u0006\u001a\u00020\u0001*\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0011\u0010\b\u001a\u00020\u0001*\u00020\u0001\u00a2\u0006\u0004\b\b\u0010\u0007\"\u0015\u0010\f\u001a\u00020\t*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Ljava/io/File;", "Ljava/nio/file/Path;", "relativePath", "combineSafe", "(Ljava/io/File;Ljava/nio/file/Path;)Ljava/io/File;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)Ljava/io/File;", "dropLeadingTopDirs", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;", "normalizeAndRelativize", "", "getExtension", "(Ljava/nio/file/Path;)Ljava/lang/String;", "extension", "ktor-utils"})
public final class NioPathKt {
    @NotNull
    public static final String getExtension(@NotNull Path $this$extension) {
        Intrinsics.checkNotNullParameter((Object)$this$extension, (String)"<this>");
        return StringsKt.substringAfterLast$default((String)((Object)$this$extension.getFileName()).toString(), (String)".", null, (int)2, null);
    }

    @NotNull
    public static final File combineSafe(@NotNull Path $this$combineSafe, @NotNull Path relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$combineSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Path normalized = NioPathKt.normalizeAndRelativize(relativePath);
        if (normalized.startsWith("..")) {
            throw new InvalidPathException(((Object)relativePath).toString(), "Relative path " + relativePath + " beginning with .. is invalid");
        }
        if (!(!normalized.isAbsolute())) {
            boolean bl = false;
            String string = "Bad relative path " + relativePath;
            throw new IllegalStateException(string.toString());
        }
        File file = $this$combineSafe.resolve(normalized).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resolve(normalized).toFile()");
        return file;
    }

    @NotNull
    public static final Path normalizeAndRelativize(@NotNull Path $this$normalizeAndRelativize) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizeAndRelativize, (String)"<this>");
        Path path = $this$normalizeAndRelativize.getRoot();
        if (path == null || (path = path.relativize($this$normalizeAndRelativize)) == null || (path = path.normalize()) == null || (path = NioPathKt.dropLeadingTopDirs(path)) == null) {
            Path path2 = $this$normalizeAndRelativize.normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"normalize()");
            path = NioPathKt.dropLeadingTopDirs(path2);
        }
        return path;
    }

    private static final Path dropLeadingTopDirs(Path $this$dropLeadingTopDirs) {
        int startIndex;
        block4: {
            int n;
            Iterable $this$indexOfFirst$iv = $this$dropLeadingTopDirs;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Path it = (Path)item$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((Object)it).toString(), (Object)"..")) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = startIndex = -1;
        }
        if (startIndex == 0) {
            return $this$dropLeadingTopDirs;
        }
        Path path = $this$dropLeadingTopDirs.subpath(startIndex, $this$dropLeadingTopDirs.getNameCount());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"subpath(startIndex, nameCount)");
        return path;
    }

    @NotNull
    public static final File combineSafe(@NotNull File $this$combineSafe, @NotNull Path relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$combineSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Path normalized = NioPathKt.normalizeAndRelativize(relativePath);
        if (normalized.startsWith("..")) {
            throw new InvalidPathException(((Object)relativePath).toString(), "Relative path " + relativePath + " beginning with .. is invalid");
        }
        if (!(!normalized.isAbsolute())) {
            boolean bl = false;
            String string = "Bad relative path " + relativePath;
            throw new IllegalStateException(string.toString());
        }
        return new File($this$combineSafe, ((Object)normalized).toString());
    }
}

