/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.ponder;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.utility.Pointing;
import me.duquee.createutilities.blocks.CUBlocks;
import me.duquee.createutilities.blocks.lgearbox.LShapedGearboxBlock;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class GearboxScenes {
    public static void gearCube(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("gearcube", "Relaying Rotational Force using 6-Axis Gearboxes");
        scene.configureBasePlate(0, 0, 5);
        scene.setSceneOffsetY(-1.0f);
        Selection belt = util.select.fromTo(2, 0, 5, 2, 3, 5).add(util.select.fromTo(2, 3, 4, 3, 2, 3));
        scene.showBasePlate();
        scene.world.showSection(belt, class_2350.field_11036);
        scene.idle(10);
        Selection gearboxes = util.select.fromTo(2, 3, 2, 2, 4, 2);
        scene.world.showSection(gearboxes, class_2350.field_11035);
        scene.idle(10);
        scene.world.showSection(util.select.position(2, 2, 2), class_2350.field_11036);
        scene.world.showSection(util.select.position(2, 3, 1), class_2350.field_11035);
        scene.world.showSection(util.select.position(1, 4, 2), class_2350.field_11034);
        scene.world.showSection(util.select.position(3, 4, 2), class_2350.field_11039);
        scene.world.showSection(util.select.position(2, 5, 2), class_2350.field_11033);
        scene.idle(20);
        class_2338 bottomGBPos = util.grid.at(2, 3, 2);
        class_243 bottomGBVec = util.vector.centerOf(bottomGBPos);
        scene.overlay.showText(50).pointAt(bottomGBVec).placeNearTarget().text("Relaying rotation in all directions can get bulky quickly");
        scene.idle(60);
        scene.world.hideSection(util.select.position(2, 2, 2), class_2350.field_11033);
        scene.world.hideSection(util.select.position(2, 3, 1), class_2350.field_11043);
        scene.world.hideSection(util.select.position(1, 4, 2), class_2350.field_11039);
        scene.world.hideSection(util.select.position(3, 4, 2), class_2350.field_11034);
        scene.world.hideSection(util.select.position(2, 5, 2), class_2350.field_11036);
        scene.idle(10);
        scene.world.hideSection(gearboxes, class_2350.field_11043);
        scene.idle(20);
        class_2338 gearcubePos = util.grid.at(2, 3, 2);
        Selection gearcube = util.select.position(gearcubePos);
        scene.world.setBlock(gearcubePos, CUBlocks.GEARCUBE.getDefaultState(), false);
        scene.world.showSection(gearcube, class_2350.field_11035);
        scene.world.setKineticSpeed(gearcube, 16.0f);
        scene.idle(10);
        class_2338 shaft1Pos = util.grid.at(1, 3, 2);
        class_2338 shaft2Pos = util.grid.at(3, 3, 2);
        class_2338 shaft3Pos = util.grid.at(2, 4, 2);
        class_2680 shaftState = (class_2680)AllBlocks.SHAFT.getDefaultState().method_11657((class_2769)ShaftBlock.AXIS, (Comparable)class_2350.class_2351.field_11048);
        scene.world.setBlock(shaft1Pos, shaftState, false);
        scene.world.setBlock(shaft2Pos, shaftState, false);
        scene.world.setBlock(shaft3Pos, (class_2680)shaftState.method_11657((class_2769)ShaftBlock.AXIS, (Comparable)class_2350.class_2351.field_11052), false);
        Selection shaft1 = util.select.position(shaft1Pos);
        Selection shaft2 = util.select.position(shaft2Pos);
        Selection shaft3 = util.select.position(shaft3Pos);
        scene.world.setKineticSpeed(shaft1, 16.0f);
        scene.world.setKineticSpeed(shaft2, -16.0f);
        scene.world.setKineticSpeed(shaft3, 16.0f);
        scene.world.showSection(util.select.position(2, 2, 2), class_2350.field_11036);
        scene.world.showSection(util.select.position(2, 3, 1), class_2350.field_11035);
        scene.world.showSection(util.select.position(shaft1Pos), class_2350.field_11034);
        scene.world.showSection(util.select.position(shaft2Pos), class_2350.field_11039);
        scene.world.showSection(util.select.position(shaft3Pos), class_2350.field_11033);
        scene.idle(20);
        scene.overlay.showText(60).colored(PonderPalette.GREEN).pointAt(util.vector.topOf(3, 2, 3)).placeNearTarget().attachKeyFrame().text("A 6-Axis Gearcube is the more compact equivalent of this setup");
        scene.idle(70);
    }

    public static void lShapedGearbox(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("lshaped_gearbox", "Relaying Rotational Force using L-Shaped Gearboxes");
        scene.configureBasePlate(0, 0, 5);
        Selection belt = util.select.fromTo(2, 0, 5, 2, 2, 5).add(util.select.position(2, 2, 4));
        scene.showBasePlate();
        scene.world.showSection(belt, class_2350.field_11036);
        scene.idle(10);
        class_2338 cog1Pos = util.grid.at(2, 2, 3);
        class_2338 cog2Pos = util.grid.at(1, 2, 2);
        Selection cog1 = util.select.position(cog1Pos);
        Selection cog2 = util.select.position(cog2Pos);
        class_2338 shaftPos = util.grid.at(0, 2, 2);
        Selection shaft = util.select.position(shaftPos);
        scene.world.showSection(cog1, class_2350.field_11035);
        scene.idle(5);
        scene.world.showSection(cog2.add(shaft), class_2350.field_11034);
        scene.idle(10);
        scene.overlay.showText(50).pointAt(util.vector.blockSurface(shaftPos, class_2350.field_11039)).placeNearTarget().text("Changing directions can get bulky quickly");
        scene.idle(50);
        scene.world.hideSection(cog1.add(cog2), class_2350.field_11036);
        scene.idle(20);
        class_2338 gearboxPos = util.grid.at(2, 2, 2);
        Selection gearbox = util.select.position(gearboxPos);
        scene.world.setKineticSpeed(gearbox, 16.0f);
        class_2680 shaftState = AllBlocks.SHAFT.getDefaultState();
        scene.world.setBlock(cog1Pos, (class_2680)shaftState.method_11657((class_2769)ShaftBlock.AXIS, (Comparable)class_2350.class_2351.field_11051), false);
        scene.world.setBlock(cog2Pos, (class_2680)shaftState.method_11657((class_2769)ShaftBlock.AXIS, (Comparable)class_2350.class_2351.field_11048), false);
        scene.world.showSection(util.select.fromTo(cog1Pos, cog2Pos), class_2350.field_11033);
        scene.idle(10);
        scene.overlay.showText(80).colored(PonderPalette.GREEN).pointAt(util.vector.blockSurface(gearboxPos, class_2350.field_11043)).placeNearTarget().text("A more compact alternative to this setup is using a Gearbox, but two shafts go unused");
        scene.idle(80);
        scene.world.hideSection(gearbox, class_2350.field_11036);
        scene.idle(20);
        class_2680 gearboxState = (class_2680)((class_2680)CUBlocks.LSHAPED_GEARBOX.getDefaultState().method_11657((class_2769)LShapedGearboxBlock.FACING_1, (Comparable)class_2350.field_11039)).method_11657((class_2769)LShapedGearboxBlock.FACING_2, (Comparable)class_2350.field_11039);
        scene.world.setBlock(gearboxPos, gearboxState, false);
        scene.world.setKineticSpeed(gearbox, -16.0f);
        ElementLink lGearbox = scene.world.showIndependentSection(gearbox, class_2350.field_11033);
        scene.idle(10);
        scene.overlay.showText(80).colored(PonderPalette.GREEN).pointAt(util.vector.blockSurface(gearboxPos, class_2350.field_11043)).placeNearTarget().text("With an L-Shaped Gearbox you can make this in a cleaner and cheaper way");
        scene.idle(80);
        scene.addKeyframe();
        belt = util.select.fromTo(2, 0, 5, 2, 2, 5).add(util.select.position(2, 2, 4));
        scene.world.hideSection(belt.add(cog1), class_2350.field_11035);
        scene.world.hideSection(cog2.add(shaft), class_2350.field_11039);
        scene.idle(20);
        scene.world.setKineticSpeed(gearbox, 0.0f);
        scene.rotateCameraY(-90.0f);
        scene.world.moveSection(lGearbox, new class_243(0.0, -1.0, 0.0), 15);
        scene.idle(30);
        class_2338 lGearboxPos = util.grid.at(2, 1, 2);
        class_243 lGearboxVec = util.vector.blockSurface(lGearboxPos, class_2350.field_11033);
        scene.overlay.showControls(new InputWindowElement(lGearboxVec, Pointing.UP).rightClick().withWrench(), 40);
        for (int i = 0; i < 8; ++i) {
            scene.idle(10);
            scene.world.modifyBlock(gearboxPos, s -> (class_2680)s.method_28493((class_2769)LShapedGearboxBlock.FACING_2), false);
            if (i != 1) continue;
            scene.overlay.showText(50).text("By Right-clicking it with a Wrench, you can change the orientation of the secondary axis").pointAt(lGearboxVec);
        }
        scene.idle(20);
    }
}

