/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.blocks.voidtypes.motor;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.create.Create;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.WorldHelper;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import me.duquee.createutilities.CreateUtilities;
import me.duquee.createutilities.blocks.voidtypes.motor.VoidMotorLinkBehaviour;
import me.duquee.createutilities.blocks.voidtypes.motor.VoidMotorTileEntity;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2540;

public class VoidMotorNetworkHandler {
    static final Map<class_1936, Map<NetworkKey, Set<class_2338>>> connections = new IdentityHashMap<class_1936, Map<NetworkKey, Set<class_2338>>>();

    public Set<class_2338> getNetworkOf(class_1936 world, VoidMotorLinkBehaviour actor) {
        NetworkKey key;
        Map<NetworkKey, Set<class_2338>> networksInWorld = this.networksIn(world);
        if (!networksInWorld.containsKey(key = actor.getNetworkKey())) {
            networksInWorld.put(key, new LinkedHashSet());
        }
        return networksInWorld.get(key);
    }

    public Map<NetworkKey, Set<class_2338>> networksIn(class_1936 world) {
        if (!connections.containsKey(world)) {
            Create.LOGGER.warn("Tried to Access unprepared network space of " + WorldHelper.getDimensionID((class_1936)world));
            return new HashMap<NetworkKey, Set<class_2338>>();
        }
        return connections.get(world);
    }

    public void onLoadWorld(class_1936 world) {
        connections.put(world, new HashMap());
        Create.LOGGER.debug("Prepared Void Motor Network Space for " + WorldHelper.getDimensionID((class_1936)world));
    }

    public void onUnloadWorld(class_1936 world) {
        connections.remove(world);
        Create.LOGGER.debug("Removed Void Motor Network Space for " + WorldHelper.getDimensionID((class_1936)world));
    }

    public void addToNetwork(class_1936 world, VoidMotorLinkBehaviour actor) {
        this.getNetworkOf(world, actor).add(actor.getPos());
        SmartBlockEntity smartBlockEntity = actor.blockEntity;
        if (smartBlockEntity instanceof VoidMotorTileEntity) {
            VoidMotorTileEntity voidMotor = (VoidMotorTileEntity)smartBlockEntity;
            voidMotor.onConnectToVoidNetwork();
        }
    }

    public void removeFromNetwork(class_1936 world, VoidMotorLinkBehaviour actor) {
        SmartBlockEntity smartBlockEntity = actor.blockEntity;
        if (smartBlockEntity instanceof VoidMotorTileEntity) {
            VoidMotorTileEntity voidMotor = (VoidMotorTileEntity)smartBlockEntity;
            voidMotor.onDisconnectFromVoidNetwork();
        }
        Set<class_2338> network = this.getNetworkOf(world, actor);
        network.remove(actor.getPos());
        if (network.isEmpty()) {
            this.networksIn(world).remove(actor.getNetworkKey());
        }
    }

    public static class NetworkKey {
        @Nullable
        public final GameProfile owner;
        public final Couple<RedstoneLinkNetworkHandler.Frequency> frequencies;

        public NetworkKey(@Nullable GameProfile owner, RedstoneLinkNetworkHandler.Frequency frequencyFirst, RedstoneLinkNetworkHandler.Frequency frequencySecond) {
            this.owner = owner;
            this.frequencies = Couple.create((Object)frequencyFirst, (Object)frequencySecond);
        }

        public void writeToBuffer(class_2540 buffer) {
            buffer.method_10793(((RedstoneLinkNetworkHandler.Frequency)this.frequencies.get(true)).getStack());
            buffer.method_10793(((RedstoneLinkNetworkHandler.Frequency)this.frequencies.get(false)).getStack());
            buffer.writeBoolean(this.owner != null);
            if (this.owner != null) {
                buffer.method_43616(this.owner);
            }
        }

        public static NetworkKey fromBuffer(class_2540 buffer) {
            class_1799 frequencyFirst = buffer.method_10819();
            class_1799 frequencyLast = buffer.method_10819();
            GameProfile owner = null;
            if (buffer.readBoolean()) {
                owner = buffer.method_43623();
            }
            return new NetworkKey(owner, RedstoneLinkNetworkHandler.Frequency.of((class_1799)frequencyFirst), RedstoneLinkNetworkHandler.Frequency.of((class_1799)frequencyLast));
        }

        public int hashCode() {
            return Objects.hash(this.owner, this.frequencies);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NetworkKey other = (NetworkKey)obj;
            return Objects.equals(this.owner, other.owner) && this.frequencies.equals(other.frequencies);
        }

        public class_2487 serialize() {
            class_2487 tag = new class_2487();
            if (this.owner != null) {
                class_2487 tag_ = new class_2487();
                class_2512.method_10684((class_2487)tag_, (GameProfile)this.owner);
                tag.method_10566("Owner", (class_2520)tag_);
            }
            tag.method_10566("FrequencyFirst", (class_2520)((RedstoneLinkNetworkHandler.Frequency)this.frequencies.get(true)).getStack().method_7953(new class_2487()));
            tag.method_10566("FrequencyLast", (class_2520)((RedstoneLinkNetworkHandler.Frequency)this.frequencies.get(false)).getStack().method_7953(new class_2487()));
            return tag;
        }

        public static NetworkKey deserialize(class_2487 tag) {
            RedstoneLinkNetworkHandler.Frequency frequencyFirst = RedstoneLinkNetworkHandler.Frequency.of((class_1799)class_1799.method_7915((class_2487)tag.method_10562("FrequencyFirst")));
            RedstoneLinkNetworkHandler.Frequency frequencyLast = RedstoneLinkNetworkHandler.Frequency.of((class_1799)class_1799.method_7915((class_2487)tag.method_10562("FrequencyLast")));
            GameProfile owner = tag.method_10573("Owner", 10) ? class_2512.method_10683((class_2487)tag.method_10562("Owner")) : null;
            return new NetworkKey(owner, frequencyFirst, frequencyLast);
        }

        public String toString() {
            return this.serialize().toString();
        }

        public static NetworkKey fromString(String json) {
            class_2487 tag;
            try {
                tag = class_2522.method_10718((String)json);
            }
            catch (CommandSyntaxException e) {
                CreateUtilities.LOGGER.error("Tried to load invalid NetworkKey '" + json + "'");
                return null;
            }
            return NetworkKey.deserialize(tag);
        }
    }
}

