/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons.mixin;

import com.google.common.collect.Lists;
import io.github.lucaargolo.seasons.FabricSeasonsClient;
import io.github.lucaargolo.seasons.utils.Season;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1087;
import net.minecraft.class_1095;
import net.minecraft.class_2680;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1095.class_1096.class})
public class MultipartBakedModelBuilderMixin {
    @Unique
    private final HashMap<Season, List<Pair<Predicate<class_2680>, class_1087>>> seasonalComponentsMap = new HashMap();
    @Unique
    private final HashSet<Season> validSeasonalComponents = new HashSet();

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    public void createSeasonalComponentsMap(CallbackInfo ci) {
        for (Season season : Season.values()) {
            this.seasonalComponentsMap.put(season, Lists.newArrayList());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"addComponent"})
    public void addSeasonalComponent(Predicate<class_2680> predicate, class_1087 model, CallbackInfo ci) {
        Map<Season, class_1087> seasonModelMap = FabricSeasonsClient.originalToSeasonModelMap.get(model);
        if (seasonModelMap != null) {
            seasonModelMap.forEach((season, seasonalModel) -> {
                this.validSeasonalComponents.add((Season)((Object)season));
                this.seasonalComponentsMap.get(season).add((Pair<Predicate<class_2680>, class_1087>)Pair.of((Object)predicate, (Object)seasonalModel));
            });
        } else {
            this.seasonalComponentsMap.forEach((season, list) -> list.add(Pair.of((Object)predicate, (Object)model)));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"build"})
    public void addSeasonalMultipart(CallbackInfoReturnable<class_1087> cir) {
        class_1087 bakedModel = (class_1087)cir.getReturnValue();
        HashMap seasonModelMap = new HashMap();
        this.seasonalComponentsMap.forEach((season, seasonalComponents) -> {
            if (this.validSeasonalComponents.contains(season)) {
                seasonModelMap.put(season, new class_1095(seasonalComponents));
            }
        });
        if (!seasonModelMap.isEmpty()) {
            FabricSeasonsClient.originalToSeasonModelMap.put(bakedModel, seasonModelMap);
        }
    }
}

