/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.level;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.ExplosionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.latvian.mods.kubejs.bindings.event.LevelEvents;
import dev.latvian.mods.kubejs.level.ExplosionEventJS;
import dev.latvian.mods.kubejs.level.SimpleLevelEventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_3218;

public class KubeJSWorldEventHandler {
    public static void init() {
        LifecycleEvent.SERVER_LEVEL_LOAD.register(KubeJSWorldEventHandler::levelLoad);
        LifecycleEvent.SERVER_LEVEL_UNLOAD.register(KubeJSWorldEventHandler::levelUnload);
        TickEvent.SERVER_LEVEL_POST.register(KubeJSWorldEventHandler::levelPostTick);
        ExplosionEvent.PRE.register(KubeJSWorldEventHandler::preExplosion);
        ExplosionEvent.DETONATE.register(KubeJSWorldEventHandler::detonateExplosion);
    }

    private static void levelLoad(class_3218 level) {
        if (LevelEvents.LOADED.hasListeners()) {
            LevelEvents.LOADED.post(new SimpleLevelEventJS((class_1937)level), level.method_27983().method_29177());
        }
    }

    private static void levelUnload(class_3218 level) {
        if (LevelEvents.UNLOADED.hasListeners()) {
            LevelEvents.UNLOADED.post(new SimpleLevelEventJS((class_1937)level), level.method_27983().method_29177());
        }
    }

    private static void levelPostTick(class_3218 level) {
        if (LevelEvents.TICK.hasListeners()) {
            LevelEvents.TICK.post((ScriptTypeHolder)ScriptType.SERVER, (Object)level.method_27983().method_29177(), new SimpleLevelEventJS((class_1937)level));
        }
    }

    private static EventResult preExplosion(class_1937 level, class_1927 explosion) {
        return LevelEvents.BEFORE_EXPLOSION.hasListeners() ? LevelEvents.BEFORE_EXPLOSION.post((ScriptTypeHolder)level, new ExplosionEventJS.Before(level, explosion)).arch() : EventResult.pass();
    }

    private static void detonateExplosion(class_1937 level, class_1927 explosion, List<class_1297> affectedEntities) {
        if (LevelEvents.AFTER_EXPLOSION.hasListeners()) {
            LevelEvents.AFTER_EXPLOSION.post((ScriptTypeHolder)level, new ExplosionEventJS.After(level, explosion, affectedEntities));
        }
    }
}

