/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.callbacks;

import dev.latvian.mods.kubejs.block.callbacks.BlockStateModifyCallbackJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.typings.Info;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.Nullable;

public class BlockStateModifyPlacementCallbackJS
extends BlockStateModifyCallbackJS {
    public final class_1750 context;
    public final class_2248 minecraftBlock;
    public BlockContainerJS block;

    public BlockStateModifyPlacementCallbackJS(class_1750 context, class_2248 block) {
        super(BlockStateModifyPlacementCallbackJS.getBlockStateToModify(context, block));
        this.context = context;
        this.minecraftBlock = block;
        this.block = new BlockContainerJS(context.method_8045(), context.method_8037());
    }

    private static class_2680 getBlockStateToModify(class_1750 context, class_2248 block) {
        class_2680 previous = context.method_8045().method_8320(context.method_8037());
        if (previous.method_26204() == block) {
            return previous;
        }
        return block.method_9564();
    }

    @Info(value="Gets the clicked position in world")
    public class_2338 getClickedPos() {
        return this.context.method_8037();
    }

    @Info(value="Gets the clicked block")
    public BlockContainerJS getClickedBlock() {
        return new BlockContainerJS(this.getLevel(), this.getClickedPos());
    }

    @Info(value="Returns if the block being placed thinks it can be placed here. This is used for replacement checks, like placing blocks in water or tall grass")
    public boolean canPlace() {
        return this.context.method_7716();
    }

    @Info(value="Returns if the block being placed is replacing the block clicked")
    public boolean replacingClickedOnBlock() {
        return this.context.method_7717();
    }

    @Info(value="Gets the direction closes to where the player is currently looking")
    public class_2350 getNearestLookingDirection() {
        return this.context.method_7715();
    }

    @Info(value="Gets the vertical direction (UP/DOWN) closest to where the player is currently looking")
    public class_2350 getNearestLookingVerticalDirection() {
        return this.context.method_32760();
    }

    @Info(value="Gets an array of all directions, ordered by which the player is looking closest to")
    public class_2350[] getNearestLookingDirections() {
        return this.context.method_7718();
    }

    @Info(value="Gets the facing direction of the clicked block face")
    public class_2350 getClickedFace() {
        return this.context.method_8038();
    }

    @Info(value="Gets the position in the block-space of where it was clicked")
    public class_243 getClickLocation() {
        return this.context.method_17698();
    }

    @Info(value="Returns if the hit posiiton in the block-space is inside the 1x1x1 cube of the block")
    public boolean isInside() {
        return this.context.method_17699();
    }

    @Info(value="Gets the item being placed")
    public class_1799 getItem() {
        return this.context.method_8041();
    }

    @Info(value="Gets the player placing the block, if available")
    @Nullable
    public class_1657 getPlayer() {
        return this.context.method_8036();
    }

    @Info(value="Gets the hand that is placing the block")
    public class_1268 getHand() {
        return this.context.method_20287();
    }

    @Info(value="Gets the level")
    public class_1937 getLevel() {
        return this.context.method_8045();
    }

    @Info(value="Gets the nearest horizontal direction to where the player is looking. NORTH if there is no player")
    public class_2350 getHorizontalDirection() {
        return this.context.method_8042();
    }

    @Info(value="Returns if the player is using the 'secondary' function of this item. Basically checks if they are holding shift")
    public boolean isSecondaryUseActive() {
        return this.context.method_8046();
    }

    @Info(value="Get the horizontal rotation of the player")
    public float getRotation() {
        return this.context.method_8044();
    }

    @Info(value="Gets the FluidSate at the clicked position")
    public class_3610 getFluidStateAtClickedPos() {
        return this.context.method_8045().method_8316(this.context.method_8037());
    }

    @Info(value="Checks if the position clicked has a specified fluid there")
    public boolean isClickedPosIn(class_3611 fluid) {
        return this.getFluidStateAtClickedPos().method_39360(fluid);
    }

    @Info(value="Set if this block is waterlogged or not")
    public BlockStateModifyPlacementCallbackJS waterlogged(boolean waterlogged) {
        this.setValue(class_2741.field_12508, waterlogged);
        return this;
    }

    @Info(value="Set this block as waterlogged if it is in water")
    public BlockStateModifyPlacementCallbackJS waterlogged() {
        return this.waterlogged(this.isInWater());
    }

    @Info(value="Checks if this block is in water")
    public boolean isInWater() {
        return this.getFluidStateAtClickedPos().method_15772() == class_3612.field_15910;
    }

    @Info(value="Checks if the block currently occupying the position this is being placed in is the same block type.\nUsed for things like candles, where multiple can be in the same block-space.\n")
    public boolean isReplacingSelf() {
        return this.getLevel().method_8320(this.getClickedPos()).method_26204() == this.minecraftBlock;
    }
}

