/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.bindings;

import dev.latvian.mods.kubejs.block.predicate.BlockEntityPredicate;
import dev.latvian.mods.kubejs.block.predicate.BlockIDPredicate;
import dev.latvian.mods.kubejs.block.predicate.BlockPredicate;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.Tags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

@Info(value="Various block related helper functions")
public class BlockWrapper {
    private static Map<String, class_2350> facingMap;

    public static BlockIDPredicate id(class_2960 id) {
        return new BlockIDPredicate(id);
    }

    public static BlockIDPredicate id(class_2960 id, Map<String, Object> properties) {
        BlockIDPredicate b = BlockWrapper.id(id);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            b = b.with(entry.getKey(), entry.getValue().toString());
        }
        return b;
    }

    public static BlockEntityPredicate entity(class_2960 id) {
        return new BlockEntityPredicate(id);
    }

    public static BlockPredicate custom(BlockPredicate predicate) {
        return predicate;
    }

    @Info(value="Get a map of direction name to Direction. Functionally identical to Direction.ALL")
    public static Map<String, class_2350> getFacing() {
        if (facingMap == null) {
            facingMap = new HashMap<String, class_2350>(6);
            for (class_2350 facing : class_2350.values()) {
                facingMap.put(facing.method_15434(), facing);
            }
        }
        return facingMap;
    }

    @Info(value="Gets a Block from a block id")
    public static class_2248 getBlock(class_2960 id) {
        return RegistryInfo.BLOCK.getValue(id);
    }

    @Info(value="Gets a blocks id from the Block")
    @Nullable
    public static class_2960 getId(class_2248 block) {
        return RegistryInfo.BLOCK.getId(block);
    }

    @Info(value="Gets a list of the classname of all registered blocks")
    public static List<String> getTypeList() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<class_5321<class_2248>, class_2248> block : RegistryInfo.BLOCK.entrySet()) {
            list.add(block.getKey().method_29177().toString());
        }
        return list;
    }

    @Info(value="Gets a list of all blocks with tags")
    public static List<class_2960> getTaggedIds(class_2960 tag) {
        return (List)class_156.method_654(new LinkedList(), list -> {
            for (class_6880 holder : class_7923.field_41175.method_40286(Tags.block(tag))) {
                holder.method_40230().map(class_5321::method_29177).ifPresent(list::add);
            }
        });
    }
}

