/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.module.StructurePieceTypeModule;
import com.yungnickyoung.minecraft.bettermineshafts.world.config.BetterMineshaftConfiguration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BetterMineshaftPiece;
import com.yungnickyoung.minecraft.yungsapi.world.util.BoundingBoxHelper;
import java.util.Arrays;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2443;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;

public class SmallTunnelTurn
extends BetterMineshaftPiece {
    private final TurnDirection turnDirection;
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 5;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 4;

    public SmallTunnelTurn(class_2487 compoundTag) {
        super(StructurePieceTypeModule.SMALL_TUNNEL_TURN, compoundTag);
        this.turnDirection = TurnDirection.valueOf(compoundTag.method_10550("TurnDirection"));
    }

    public SmallTunnelTurn(int chunkPieceLen, class_5819 randomSource, class_3341 blockBox, class_2350 direction, BetterMineshaftConfiguration config) {
        super(StructurePieceTypeModule.SMALL_TUNNEL_TURN, chunkPieceLen, config, blockBox);
        this.method_14926(direction);
        this.turnDirection = randomSource.method_43056() ? TurnDirection.LEFT : TurnDirection.RIGHT;
    }

    @Override
    protected void method_14943(class_6625 structurePieceSerializationContext, class_2487 compoundTag) {
        super.method_14943(structurePieceSerializationContext, compoundTag);
        compoundTag.method_10569("TurnDirection", this.turnDirection.value);
    }

    public static class_3341 determineBoxPosition(class_6130 structurePieceAccessor, int x, int y, int z, class_2350 direction) {
        class_3341 blockBox = BoundingBoxHelper.boxFromCoordsWithRotation((int)x, (int)y, (int)z, (int)5, (int)5, (int)5, (class_2350)direction);
        class_3443 intersectingPiece = structurePieceAccessor.method_35461(blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void method_14918(class_3443 structurePiece, class_6130 structurePieceAccessor, class_5819 randomSource) {
        class_2350 direction = this.method_14934();
        if (direction == null) {
            return;
        }
        class_2350 nextDirection = this.turnDirection == TurnDirection.LEFT ? direction.method_10160() : direction.method_10170();
        switch (nextDirection) {
            default: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35415(), this.field_15315.method_35416(), this.field_15315.method_35417() - 1, nextDirection, this.field_15316);
                break;
            }
            case field_11035: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35418(), this.field_15315.method_35416(), this.field_15315.method_35420() + 1, nextDirection, this.field_15316);
                break;
            }
            case field_11039: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35415() - 1, this.field_15315.method_35416(), this.field_15315.method_35420(), nextDirection, this.field_15316);
                break;
            }
            case field_11034: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, randomSource, this.field_15315.method_35418() + 1, this.field_15315.method_35416(), this.field_15315.method_35417(), nextDirection, this.field_15316);
            }
        }
    }

    public void method_14931(class_5281 world, class_5138 structureManager, class_2794 chunkGenerator, class_5819 randomSource, class_3341 box, class_1923 chunkPos, class_2338 blockPos) {
        class_2350 direction = this.method_14934();
        this.chanceReplaceNonAir(world, box, randomSource, this.config.replacementRate, 0, 1, 0, 4, 4, 4, this.config.blockStateRandomizers.mainRandomizer);
        this.chanceReplaceNonAir(world, box, randomSource, this.config.replacementRate, 0, 0, 0, 4, 0, 4, this.config.blockStateRandomizers.floorRandomizer);
        this.fill(world, box, 1, 1, 0, 3, 3, 3, AIR);
        this.replaceAirOrChains(world, box, 1, 0, 0, 3, 0, 3, this.config.blockStates.mainBlockState);
        this.fill(world, box, 2, 1, 0, 2, 1, 1, class_2246.field_10167.method_9564());
        if (this.turnDirection == TurnDirection.LEFT) {
            if (direction == class_2350.field_11043 || direction == class_2350.field_11034) {
                this.generateLeftTurn(world, box);
            } else {
                this.generateRightTurn(world, box);
            }
        } else if (direction == class_2350.field_11043 || direction == class_2350.field_11034) {
            this.generateRightTurn(world, box);
        } else {
            this.generateLeftTurn(world, box);
        }
        this.addBiomeDecorations(world, box, randomSource, 0, 0, 0, 4, 3, 4);
        this.addVines(world, box, randomSource, this.config.decorationChances.vineChance, 1, 0, 1, 3, 4, 3);
        this.generatePillarsOrChains(world, box, randomSource);
    }

    private void generateLeftTurn(class_5281 world, class_3341 box) {
        this.fill(world, box, 0, 1, 1, 0, 3, 3, AIR);
        this.replaceAirOrChains(world, box, 0, 0, 1, 0, 0, 3, this.config.blockStates.mainBlockState);
        this.fill(world, box, 2, 1, 2, 2, 1, 2, (class_2680)class_2246.field_10167.method_9564().method_11657((class_2769)class_2443.field_11369, (Comparable)class_2768.field_12671));
        this.fill(world, box, 0, 1, 2, 1, 1, 2, (class_2680)class_2246.field_10167.method_9564().method_11657((class_2769)class_2443.field_11369, (Comparable)class_2768.field_12674));
    }

    private void generateRightTurn(class_5281 world, class_3341 box) {
        this.fill(world, box, 4, 1, 1, 4, 3, 3, AIR);
        this.replaceAirOrChains(world, box, 4, 0, 1, 4, 0, 3, this.config.blockStates.mainBlockState);
        this.fill(world, box, 2, 1, 2, 2, 1, 2, (class_2680)class_2246.field_10167.method_9564().method_11657((class_2769)class_2443.field_11369, (Comparable)class_2768.field_12664));
        this.fill(world, box, 3, 1, 2, 4, 1, 2, (class_2680)class_2246.field_10167.method_9564().method_11657((class_2769)class_2443.field_11369, (Comparable)class_2768.field_12674));
    }

    private void generatePillarsOrChains(class_5281 world, class_3341 box, class_5819 randomSource) {
        this.generatePillarDownOrChainUp(world, randomSource, box, 1, 0, 1);
        this.generatePillarDownOrChainUp(world, randomSource, box, 3, 0, 1);
        this.generatePillarDownOrChainUp(world, randomSource, box, 1, 0, 3);
        this.generatePillarDownOrChainUp(world, randomSource, box, 3, 0, 3);
    }

    public static enum TurnDirection {
        LEFT(0),
        RIGHT(1);

        private final int value;

        private TurnDirection(int value) {
            this.value = value;
        }

        public static TurnDirection valueOf(int value) {
            return Arrays.stream(TurnDirection.values()).filter(dir -> dir.value == value).findFirst().get();
        }
    }
}

