/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.fabric;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.teamresourceful.resourcefullib.common.comptibility.CompatabilityManager;
import com.teamresourceful.resourcefullib.common.lib.Constants;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;

public class FabricCompatibilityHandler {
    private static final String KEY = "resourcefullib:compatibility";

    public static void load() {
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            ModMetadata metadata = mod.getMetadata();
            if (!metadata.containsCustomValue(KEY)) continue;
            try {
                FabricCompatibilityHandler.initMod(metadata);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Resourceful Lib failed to load compatibility for mod: " + metadata.getName());
                e.printStackTrace();
            }
        }
    }

    private static void initMod(ModMetadata metadata) {
        CustomValue.CvArray array = metadata.getCustomValue(KEY).getAsArray();
        CompatabilityManager.check(metadata.getId(), FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT, FabricCompatibilityHandler.toJsonArray(array));
    }

    private static JsonArray toJsonArray(CustomValue.CvArray array) {
        JsonArray jsonArray = new JsonArray();
        for (CustomValue value : array) {
            jsonArray.add(FabricCompatibilityHandler.toJsonElement(value));
        }
        return jsonArray;
    }

    private static JsonElement toJsonElement(CustomValue value) {
        return switch (value.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case CustomValue.CvType.NULL -> JsonNull.INSTANCE;
            case CustomValue.CvType.BOOLEAN -> new JsonPrimitive(Boolean.valueOf(value.getAsBoolean()));
            case CustomValue.CvType.NUMBER -> new JsonPrimitive(value.getAsNumber());
            case CustomValue.CvType.STRING -> new JsonPrimitive(value.getAsString());
            case CustomValue.CvType.ARRAY -> FabricCompatibilityHandler.toJsonArray(value.getAsArray());
            case CustomValue.CvType.OBJECT -> {
                CustomValue.CvObject object = value.getAsObject();
                JsonObject jsonObject = new JsonObject();
                for (Map.Entry entry : object) {
                    jsonObject.add((String)entry.getKey(), FabricCompatibilityHandler.toJsonElement((CustomValue)entry.getValue()));
                }
                yield jsonObject;
            }
        };
    }
}

