/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import shetiphian.core.common.TagHelper;
import shetiphian.enderchests.Values;

@Config(name="enderchests")
public class Configuration
extends PartitioningSerializer.GlobalData {
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.TransitiveObject
    public ClientFile CLIENT = new ClientFile();
    @ConfigEntry.Category(value="common")
    @ConfigEntry.Gui.TransitiveObject
    public CommonFile COMMON = new CommonFile();

    private static void process_client(ClientFile clientFile) {
        Values.colorValues[0] = clientFile.COLOR_VALUES.white;
        Values.colorValues[1] = clientFile.COLOR_VALUES.orange;
        Values.colorValues[2] = clientFile.COLOR_VALUES.magenta;
        Values.colorValues[3] = clientFile.COLOR_VALUES.light_blue;
        Values.colorValues[4] = clientFile.COLOR_VALUES.yellow;
        Values.colorValues[5] = clientFile.COLOR_VALUES.lime;
        Values.colorValues[6] = clientFile.COLOR_VALUES.pink;
        Values.colorValues[7] = clientFile.COLOR_VALUES.gray;
        Values.colorValues[8] = clientFile.COLOR_VALUES.light_gray;
        Values.colorValues[9] = clientFile.COLOR_VALUES.cyan;
        Values.colorValues[10] = clientFile.COLOR_VALUES.purple;
        Values.colorValues[11] = clientFile.COLOR_VALUES.blue;
        Values.colorValues[12] = clientFile.COLOR_VALUES.brown;
        Values.colorValues[13] = clientFile.COLOR_VALUES.green;
        Values.colorValues[14] = clientFile.COLOR_VALUES.red;
        Values.colorValues[15] = clientFile.COLOR_VALUES.black;
    }

    private static void process_common(CommonFile commonFile) {
        int chestMin = commonFile.UPGRADE_SETTINGS.chest_size_min;
        int chestMax = commonFile.UPGRADE_SETTINGS.chest_size_max;
        if (chestMin > chestMax) {
            commonFile.UPGRADE_SETTINGS.chest_size_min = chestMax;
            commonFile.UPGRADE_SETTINGS.chest_size_max = chestMin;
        }
        if (Values.canProcessTags) {
            Configuration.processTagLists(commonFile);
        }
    }

    public static void processTagLists(CommonFile commonFile) {
        Configuration.process(commonFile.UPGRADE_ITEMS.personal, Values.listPersonal, class_1802.field_8477);
        Configuration.process(commonFile.UPGRADE_ITEMS.team, Values.listTeam, class_1802.field_8687);
        Configuration.process(commonFile.UPGRADE_ITEMS.small_capacity, Values.listSmallCap_Multi, class_1802.field_8634);
        Configuration.process(commonFile.UPGRADE_ITEMS.large_capacity, Values.listLargeCap_Multi, class_1802.field_8449);
        Configuration.process(commonFile.UPGRADE_ITEMS.small_capacity_singleuse, Values.listSmallCap_Single, null);
        Configuration.process(commonFile.UPGRADE_ITEMS.large_capacity_singleuse, Values.listLargeCap_Single, null);
    }

    private static void process(Set<String> names, ArrayList<class_1792> list, class_1792 basic) {
        list.clear();
        for (String name : names) {
            if (Strings.isNullOrEmpty((String)name)) continue;
            boolean isTag = false;
            if (name.toLowerCase().startsWith("tag|")) {
                isTag = true;
                name = name.substring(4);
            }
            if (isTag) {
                TagHelper.getItems((String)name).forEach(item -> Configuration.addToList(item, list));
                continue;
            }
            Configuration.addToList((class_1792)class_7923.field_41178.method_10223(new class_2960(name)), list);
        }
        if (list.isEmpty() && basic != null) {
            list.add(basic);
        }
    }

    private static void addToList(class_1792 item, ArrayList<class_1792> list) {
        if (list != null && item != null && !list.contains(item)) {
            list.add(item);
        }
    }

    @Config(name="client")
    public static class ClientFile
    implements ConfigData {
        @Comment(value="Select A GUI Style")
        @ConfigEntry.Gui.CollapsibleObject
        public Menu_GUI GUI_STYLE = new Menu_GUI();
        @Comment(value="Color Values for Bands, \r\nFormat: Decimal Values (0 to 16,777,215) \r\nYou can use this website to get the decimal value of any color: \r\nhttp://www.colorhexa.com \r\nOr by using the Color Mixer from this website: \r\nhttp://www.mathsisfun.com/hexadecimal-decimal-colors.html")
        @ConfigEntry.Gui.CollapsibleObject
        public Menu_Color COLOR_VALUES = new Menu_Color();

        public void validatePostLoad() throws ConfigData.ValidationException {
            super.validatePostLoad();
            try {
                Configuration.process_client(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static class Menu_GUI {
            @Comment(value="EnderChest \r\n#Allowed Values: DEFAULT, VANILLA")
            public STYLE ender_chest = STYLE.DEFAULT;

            public static enum STYLE {
                DEFAULT,
                VANILLA;

            }
        }

        public static class Menu_Color {
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int white = 0xFFFFFF;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int orange = 14517579;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int magenta = 12411333;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int light_blue = 8296912;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int yellow = 12892206;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int lime = 4832573;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int pink = 14195370;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int gray = 0x464646;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int light_gray = 0xA9AFAF;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int cyan = 3373205;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int purple = 8996546;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int blue = 3292826;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int brown = 5650466;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int green = 3821086;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int red = 0xA53A35;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int black = 0x262626;
        }
    }

    @Config(name="common")
    public static class CommonFile
    implements ConfigData {
        @Comment(value="With this disabled chests are essentially locked to the crafted color as dyes will no longer work")
        public boolean enable_in_world_coloring = true;
        @Comment(value="Item used to upgrade the EnderChests")
        @ConfigEntry.Gui.CollapsibleObject
        public Menu_Upgrade UPGRADE_ITEMS = new Menu_Upgrade();
        @Comment(value="Adjust how many inventory slots are available")
        @ConfigEntry.Gui.CollapsibleObject
        public Menu_Settings UPGRADE_SETTINGS = new Menu_Settings();
        @Comment(value="")
        @ConfigEntry.Gui.CollapsibleObject
        public Menu_Access ACCESS_SETTINGS = new Menu_Access();

        public void validatePostLoad() throws ConfigData.ValidationException {
            super.validatePostLoad();
            try {
                Configuration.process_common(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static class Menu_Upgrade {
            @Comment(value="Items used to make the chests personal")
            Set<String> personal = this.getListOf("tag|c:diamonds");
            @Comment(value="Items used to make the chests team chests")
            Set<String> team = this.getListOf("tag|c:emeralds");
            @Comment(value="Items that upgrade storage capacity by 3")
            Set<String> small_capacity = this.getListOf("tag|c:ender_pearls");
            @Comment(value="Items that upgrade storage capacity by 9")
            Set<String> large_capacity = this.getListOf("minecraft:ender_eye");
            @Comment(value="Items that upgrade storage capacity by 3 \r\nEach item can only be use once per chest")
            Set<String> small_capacity_singleuse = new HashSet<String>();
            @Comment(value="Items that upgrade storage capacity by 9 \r\nEach item can only be use once per chest")
            Set<String> large_capacity_singleuse = new HashSet<String>();
            Predicate<Object> validator = object -> {
                if (object instanceof String) {
                    String string = (String)object;
                    return Strings.isNullOrEmpty((String)string) || string.split(":").length == 2;
                }
                return false;
            };

            private Set<String> getListOf(String ... values) {
                return new HashSet<String>(Arrays.asList(values));
            }
        }

        public static class Menu_Settings {
            @Comment(value="Minimum capacity an EnderChest holds")
            @ConfigEntry.BoundedDiscrete(min=9L, max=27L)
            public int chest_size_min = 9;
            @Comment(value="Maximum capacity an EnderChest holds")
            @ConfigEntry.BoundedDiscrete(min=9L, max=54L)
            public int chest_size_max = 27;
        }

        public static class Menu_Access {
            @Comment(value="When enabled these bags access a players vanilla EnderChest, if disabled they will only be a crafting ingredient")
            public boolean ender_pouch = true;
            @Comment(value="Enables the usage of public chests, if disabled chests must be upgraded before use")
            public boolean public_chests = true;
            @Comment(value="Enables the creation of personal chests, if disabled chests can not set personal. \r\nDoes not effect chests that are already set as personal")
            public boolean personal_chests = true;
            @Comment(value="Enables the creation of team chests, if disabled chests can not be set team. \r\nDoes not effect chests that are already set as team")
            public boolean team_chests = true;
            @Comment(value="Enables the usage of public bags, if disabled bags must be linked to an upgraded chest before use")
            public boolean public_bags = true;
            @Comment(value="Enables the linking of bags to personal chests. \r\nDoes not effect bags that are already linked to personal chests")
            public boolean personal_bags = true;
            @Comment(value="Enables the linking of bags to team chests. \r\nDoes not effect bags that are already linked to team chests")
            public boolean team_bags = true;
            @Comment(value="Public chests can be used with automation.")
            public boolean public_automation = true;
            @Comment(value="Personal chests can be used with automation.")
            public boolean personal_automation = true;
            @Comment(value="Team chests can be used with automation.")
            public boolean team_automation = true;
            @Comment(value="While true a Personal chest can only be edited (upgrade, move, etc) by the owner")
            public boolean personal_edit_lock = true;
            @Comment(value="While true a Team chest can only be edited (upgrade, move, etc) by a team member")
            public boolean team_edit_lock = true;
            @Comment(value="While true only the owner can link a bag to their chests")
            public boolean personal_link_lock = true;
            @Comment(value="While true only a team member can link a bag to team chests")
            public boolean team_link_lock = true;
            @Comment(value="While true only the owner can use the chest")
            public boolean personal_use_lock = false;
            @Comment(value="While true only a team member can use the chest")
            public boolean team_use_lock = false;
        }
    }
}

