/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.block;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import team.creative.ambientsounds.AmbientSounds;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;

public final class AmbientBlockFilters {
    public static final NamedHandlerRegistry<Function<String, Predicate<class_2680>>> REGISTRY = new NamedHandlerRegistry(x -> state -> true);

    public static Predicate<class_2680> get(String data) {
        String[] conditions = data.split("&");
        Predicate[] parsed = new Predicate[conditions.length];
        for (int i = 0; i < parsed.length; ++i) {
            parsed[i] = AmbientBlockFilters.parse(conditions[i]);
        }
        return state -> {
            for (int i = 0; i < parsed.length; ++i) {
                if (parsed[i].test(state)) continue;
                return false;
            }
            return true;
        };
    }

    private static Predicate<class_2680> parse(String data) {
        String[] parts = data.split("->");
        if (parts.length == 1) {
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(parts[0]));
            return state -> state.method_26204() == block;
        }
        if (parts.length != 2) {
            AmbientSounds.LOGGER.error("Found invalid block filter '{}'. It will be ignored", (Object)data);
            return state -> true;
        }
        try {
            return (Predicate)((Function)REGISTRY.getOrThrow(parts[0])).apply(parts[1]);
        }
        catch (IllegalArgumentException e) {
            AmbientSounds.LOGGER.error("Found invalid block filter type {}. '{}' will be ignored", (Object)parts[0], (Object)data);
            return state -> true;
        }
    }

    static {
        REGISTRY.register("t", data -> {
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(data));
            return state -> state.method_26164(tag);
        });
        REGISTRY.register("p", data -> {
            String[] parts = data.split("=");
            if (parts.length != 2) {
                AmbientSounds.LOGGER.error("Found invalid property condition '{}'. It will be ignored", data);
                return state -> true;
            }
            return state -> {
                class_2769 property = state.method_26204().method_9595().method_11663(parts[0]);
                if (property == null) {
                    return false;
                }
                Optional value = property.method_11900(parts[1]);
                if (value.isPresent()) {
                    return state.method_11654(property).equals(value.get());
                }
                return false;
            };
        });
    }
}

