/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.gui;

import com.leobeliik.extremesoundmuffler.CommonConfig;
import com.leobeliik.extremesoundmuffler.Constants;
import com.leobeliik.extremesoundmuffler.SoundMufflerCommon;
import com.leobeliik.extremesoundmuffler.gui.buttons.MuffledSlider;
import com.leobeliik.extremesoundmuffler.interfaces.IColorsGui;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import com.leobeliik.extremesoundmuffler.utils.DataManager;
import com.leobeliik.extremesoundmuffler.utils.Tips;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class MufflerScreen
extends class_437
implements ISoundLists,
IColorsGui {
    private static final class_310 minecraft = class_310.method_1551();
    private static boolean isMuffling = true;
    private static class_2561 toggleSoundsListMessage;
    private static class_2561 screenTitle;
    private static class_2561 tip;
    private final int xSize = 256;
    private final int ySize = 202;
    private final boolean isAnchorsDisabled = CommonConfig.get().disableAnchors().get();
    private int minYButton;
    private int maxYButton;
    private int index;
    private class_4185 btnTMS;
    private class_4185 btnDelete;
    private class_4185 btnCSL;
    private class_4185 btnSetAnchor;
    private class_4185 btnEditAnchor;
    private class_4185 btnNextSounds;
    private class_4185 btnPrevSounds;
    private class_4185 btnAccept;
    private class_4185 btnCancel;
    private class_4185 btnAnchor;
    private class_342 searchBar;
    private class_342 editAnchorTitleBar;
    private class_342 editRadBar;
    private MuffledSlider firstSoundButton;
    private MuffledSlider lastSoundButton;
    private Anchor anchor;

    private MufflerScreen(class_2561 title, Anchor anchor) {
        super(title);
        screenTitle = title;
        this.anchor = anchor;
        minecraft.method_1507((class_437)this);
    }

    protected void method_25426() {
        super.method_25426();
        this.minYButton = this.getY() + 46;
        this.maxYButton = this.getY() + 164;
        this.addButtons();
        this.addSideButtons();
        this.addAnchorButtons();
        this.addSoundListButtons();
    }

    public void method_25394(@NotNull class_332 stack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(stack);
        SoundMufflerCommon.renderGui();
        stack.method_25302(SoundMufflerCommon.getTextureRL(), this.getX(), this.getY(), 0, 0, 256, 202);
        this.renderSideScreen(stack);
        super.method_25394(stack, mouseX, mouseY, partialTicks);
        stack.method_27534(this.field_22793, screenTitle, this.getX() + 128, this.getY() + 8, 0xFFFFFF);
        this.renderTips(stack);
        this.renderButtons(stack, mouseX, mouseY);
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        this.editRadBar.method_1890(s -> s.matches("[0-9]*(?:[0-9]*)?"));
        if (keyCode == 257 || keyCode == 335) {
            this.searchBar.method_25365(false);
            this.editAnchorTitleBar.method_25365(false);
            this.editRadBar.method_25365(false);
            return true;
        }
        if (!(this.searchBar.method_25370() || this.editAnchorTitleBar.method_25370() || this.editRadBar.method_25370() || !MufflerScreen.minecraft.field_1690.field_1822.method_1417(keyCode, scanCode) && !Constants.soundMufflerKey.method_1417(keyCode, scanCode))) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.searchBar.method_25370()) {
            this.updateButtons();
        }
        if (!this.editRadBar.method_1882().isEmpty()) {
            int Radius = Integer.parseInt(this.editRadBar.method_1882());
            this.editRadBar.method_1868(Radius > 32 || Radius < 1 ? 65535 : 0xFFFFFF);
        } else {
            this.editRadBar.method_1868(0xFFFFFF);
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double direction) {
        if (this.firstSoundButton == null) {
            return false;
        }
        if (direction > 0.0 && this.firstSoundButton.method_46427() == this.minYButton || direction < 0.0 && this.lastSoundButton.method_46427() <= this.maxYButton) {
            return false;
        }
        this.method_25396().stream().filter(b -> b instanceof MuffledSlider).map(b -> (MuffledSlider)b).forEach(b -> {
            b.method_46419((int)((double)b.method_46427() + (double)(b.method_25364() * 10) * class_3532.method_15350((double)direction, (double)-1.0, (double)1.0)));
            b.isVisible(b.method_46427() >= this.minYButton && b.method_46427() <= this.maxYButton);
        });
        return super.method_25401(mouseX, mouseY, direction);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 1) {
            if (this.searchBar.method_25370()) {
                this.searchBar.method_1852("");
                this.updateButtons();
                return true;
            }
            if (this.editAnchorTitleBar.method_25370()) {
                this.editAnchorTitleBar.method_1852("");
                return true;
            }
            if (this.editRadBar.method_25367()) {
                this.editRadBar.method_1852("");
                return true;
            }
        } else {
            this.searchBar.method_25365(this.searchBar.method_25405(mouseX, mouseY));
            this.editAnchorTitleBar.method_25365(this.editAnchorTitleBar.method_25405(mouseX, mouseY));
            this.editRadBar.method_25365(this.editRadBar.method_25405(mouseX, mouseY));
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25419() {
        DataManager.saveData();
        super.method_25419();
    }

    private void open(class_2561 title, Anchor anchor) {
        new MufflerScreen(title, anchor);
    }

    public static void open() {
        new MufflerScreen((class_2561)class_2561.method_43471((String)"main_screen.main_title"), null);
    }

    private void addButtons() {
        this.btnCSL = class_4185.method_46430((class_2561)class_2561.method_43471((String)"main_screen.btn.csl.recent"), b -> {
            boolean isAnchorMuffling = this.anchor != null && !this.anchor.getMuffledSounds().isEmpty();
            class_2561 component = this.btnCSL.method_25369();
            toggleSoundsListMessage = class_2561.method_43471((String)"main_screen.btn.csl.recent").equals((Object)component) ? class_2561.method_43471((String)"main_screen.btn.csl.all") : (class_2561.method_43471((String)"main_screen.btn.csl.all").equals((Object)component) ? class_2561.method_43471((String)"main_screen.btn.csl.muffled") : class_2561.method_43471((String)"main_screen.btn.csl.recent"));
            b.method_25355(toggleSoundsListMessage);
            this.updateButtons();
        }).method_46434(this.getX() + 13, this.getY() + 181, 52, 13).method_46431();
        this.method_25429((class_364)this.btnCSL);
        this.searchBar = new class_342(this.field_22793, this.getX() + 74, this.getY() + 183, 119, 13, (class_2561)class_2561.method_43473());
        ((class_342)this.method_37063((class_364)this.searchBar)).method_1858(false);
        this.btnTMS = class_4185.method_46430((class_2561)class_2561.method_43471((String)"main_screen.btn.tms.stop"), b -> {
            isMuffling = !isMuffling;
        }).method_46434(this.getX() + 229, this.getY() + 180, 17, 17).method_46431();
        this.method_25429((class_364)this.btnTMS);
        this.btnDelete = class_4185.method_46430((class_2561)class_2561.method_43471((String)"main_screen.btn.delete.sounds"), b -> {
            if (MufflerScreen.method_25442()) {
                recentSoundsList.clear();
            } else if (this.anchor == null) {
                muffledSounds.clear();
            } else {
                this.anchor.deleteAnchor();
            }
            this.updateButtons();
        }).method_46434(this.getX() + 205, this.getY() + 180, 17, 17).method_46431();
        this.method_25429((class_364)this.btnDelete);
        this.btnPrevSounds = class_4185.method_46430((class_2561)class_2561.method_43473(), b -> this.method_25401(0.0, 0.0, 1.0)).method_46434(this.getX() + 10, this.getY() + 22, 13, 20).method_46431();
        this.method_25429((class_364)this.btnPrevSounds);
        this.btnNextSounds = class_4185.method_46430((class_2561)class_2561.method_43473(), b -> this.method_25401(0.0, 0.0, -1.0)).method_46434(this.getX() + 233, this.getY() + 22, 13, 20).method_46431();
        this.method_25429((class_364)this.btnNextSounds);
    }

    private void addSideButtons() {
        this.btnSetAnchor = class_4185.method_46430((class_2561)class_2561.method_43473(), b -> this.anchor.setAnchor()).method_46434(this.getX() + 261, this.getY() + 62, 11, 11).method_46431();
        ((class_4185)this.method_25429((class_364)class_4185.method_46430((class_2561)class_2561.method_43473(), b -> this.anchor.setAnchor()).method_46434(this.getX() + 261, this.getY() + 62, 11, 11).method_46431())).field_22763 = false;
        this.btnEditAnchor = class_4185.method_46430((class_2561)class_2561.method_43473(), b -> this.editTitle()).method_46434(this.getX() + 275, this.getY() + 62, 11, 11).method_46431();
        ((class_4185)this.method_25429((class_364)class_4185.method_46430((class_2561)class_2561.method_43473(), b -> this.editTitle()).method_46434(this.getX() + 275, this.getY() + 62, 11, 11).method_46431())).field_22763 = false;
        this.editAnchorTitleBar = new class_342(this.field_22793, this.getX() + 302, this.btnEditAnchor.method_46427() + 20, 84, 11, (class_2561)class_2561.method_43473());
        ((class_342)this.method_37063((class_364)new class_342(this.field_22793, this.getX() + 302, this.btnEditAnchor.method_46427() + 20, 84, 11, (class_2561)class_2561.method_43473()))).field_22764 = false;
        this.editRadBar = new class_342(this.field_22793, this.getX() + 302, this.editAnchorTitleBar.method_46427() + 15, 30, 11, (class_2561)class_2561.method_43473());
        ((class_342)this.method_37063((class_364)new class_342(this.field_22793, this.getX() + 302, this.editAnchorTitleBar.method_46427() + 15, 30, 11, (class_2561)class_2561.method_43473()))).field_22764 = false;
        this.btnAccept = class_4185.method_46430((class_2561)class_2561.method_43471((String)"main_screen.btn.accept"), b -> {
            if (!this.editAnchorTitleBar.method_1882().isEmpty() && !this.editRadBar.method_1882().isEmpty() && this.anchor != null) {
                this.anchor.editAnchor(this.editAnchorTitleBar.method_1882(), class_3532.method_15340((int)Integer.parseInt(this.editRadBar.method_1882()), (int)1, (int)32));
                screenTitle = class_2561.method_30163((String)this.editAnchorTitleBar.method_1882());
                this.editTitle();
            }
        }).method_46434(this.getX() + 259, this.editRadBar.method_46427() + 15, 40, 20).method_46431();
        ((class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"main_screen.btn.accept"), b -> {
            if (!this.editAnchorTitleBar.method_1882().isEmpty() && !this.editRadBar.method_1882().isEmpty() && this.anchor != null) {
                this.anchor.editAnchor(this.editAnchorTitleBar.method_1882(), class_3532.method_15340((int)Integer.parseInt(this.editRadBar.method_1882()), (int)1, (int)32));
                screenTitle = class_2561.method_30163((String)this.editAnchorTitleBar.method_1882());
                this.editTitle();
            }
        }).method_46434(this.getX() + 259, this.editRadBar.method_46427() + 15, 40, 20).method_46431())).field_22764 = false;
        this.btnCancel = class_4185.method_46430((class_2561)class_2561.method_43471((String)"main_screen.btn.cancel"), b -> this.editTitle()).method_46434(this.getX() + 300, this.editRadBar.method_46427() + 15, 40, 20).method_46431();
        ((class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"main_screen.btn.cancel"), b -> this.editTitle()).method_46434(this.getX() + 300, this.editRadBar.method_46427() + 15, 40, 20).method_46431())).field_22764 = false;
    }

    private void addAnchorButtons() {
        int buttonW = this.getX() + 30;
        for (int i = 0; i <= 9; ++i) {
            if (this.isAnchorsDisabled) {
                String[] disabledMsg = new String[]{"-", "D", "i", "s", "a", "b", "l", "e", "d", "-"};
                this.btnAnchor = class_4185.method_46430((class_2561)class_2561.method_30163((String)disabledMsg[i]), b -> {}).method_46434(buttonW, this.getY() + 24, 16, 16).method_46431();
                this.btnAnchor.field_22763 = false;
            } else {
                int finalI = i;
                this.btnAnchor = class_4185.method_46430((class_2561)class_2561.method_30163((String)String.valueOf(i)), b -> {
                    this.anchor = (Anchor)anchorList.get(finalI);
                    this.hideSideButtons();
                    if (screenTitle.getString().equals(this.anchor.getName())) {
                        this.anchor = null;
                        screenTitle = class_2561.method_43471((String)"main_screen.main_title");
                    } else {
                        screenTitle = class_2561.method_30163((String)this.anchor.getName());
                        this.btnSetAnchor.field_22763 = true;
                    }
                    this.updateButtons();
                }).method_46434(buttonW, this.getY() + 24, 16, 16).method_46431();
            }
            ((class_4185)this.method_37063((class_364)this.btnAnchor)).method_25350(0.0f);
            buttonW += 20;
        }
    }

    private void addSoundListButtons() {
        int bx;
        int by;
        block15: {
            block14: {
                by = this.minYButton;
                bx = CommonConfig.get().leftButtons().get() != false ? this.getX() + 36 : this.getX() + 11;
                this.firstSoundButton = null;
                soundsList.clear();
                class_2561 component = this.btnCSL.method_25369();
                if (class_2561.method_43471((String)"main_screen.btn.csl.recent").equals((Object)component)) {
                    soundsList.addAll(recentSoundsList);
                    Collections.reverse(soundsList);
                } else if (class_2561.method_43471((String)"main_screen.btn.csl.all").equals((Object)component)) {
                    class_7923.field_41172.forEach(k -> soundsList.add(k.method_14833()));
                    Collections.sort(soundsList);
                } else {
                    soundsList.addAll(this.anchor == null ? muffledSounds.keySet() : this.anchor.getMuffledSounds().keySet());
                }
                if (CommonConfig.get().lawfulAllList().get().booleanValue() && this.btnCSL.method_25369().equals(class_2561.method_43471((String)"main_screen.btn.csl.all"))) break block14;
                if (!this.btnCSL.method_25369().equals(class_2561.method_43471((String)"main_screen.btn.csl.recent"))) break block15;
            }
            forbiddenSounds.stream().map(fs -> sl -> sl.toString().contains((CharSequence)fs)).forEach(soundsList::removeIf);
        }
        if (soundsList.isEmpty()) {
            return;
        }
        for (class_2960 sound : soundsList) {
            if (!sound.toString().contains(this.searchBar.method_1882())) continue;
            double volume = this.anchor == null ? (muffledSounds.get(sound) == null ? 1.0 : (Double)muffledSounds.get(sound)) : (this.anchor.getMuffledSounds().get(sound) == null ? 1.0 : (Double)this.anchor.getMuffledSounds().get(sound));
            int bg = this.method_25396().size() % 2 == 0 ? darkBG : brightBG;
            MuffledSlider btnSound = new MuffledSlider(bx, by, bg, sound, volume, this);
            if (this.anchor != null) {
                this.setFGColor(btnSound, this.anchor.getMuffledSounds().containsKey(sound) ? "aqua" : "white");
            } else if (!muffledSounds.isEmpty()) {
                this.setFGColor(btnSound, muffledSounds.containsKey(sound) ? "aqua" : "white");
            } else {
                this.setFGColor(btnSound, "white");
            }
            this.method_37063((class_364)btnSound);
            by += btnSound.method_25364();
            btnSound.isVisible(btnSound.method_46427() < this.maxYButton);
            if (this.firstSoundButton == null) {
                this.firstSoundButton = btnSound;
            }
            this.lastSoundButton = btnSound;
        }
    }

    private void updateButtons() {
        Iterator iterator = this.method_25396().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof MuffledSlider)) continue;
            MuffledSlider button = (MuffledSlider)e;
            button.isVisible(false);
            iterator.remove();
        }
        this.addSoundListButtons();
    }

    private void renderButtons(class_332 stack, int mouseX, int mouseY) {
        boolean notMuffling;
        class_5250 message;
        SoundMufflerCommon.renderGui();
        if (isMuffling) {
            stack.method_25290(SoundMufflerCommon.getTextureRL(), this.btnTMS.method_46426() + 1, this.btnTMS.method_46427(), 54.0f, 202.0f, 15, 15, 256, 256);
        }
        class_5250 class_52502 = message = isMuffling ? class_2561.method_43471((String)"main_screen.btn.tms.stop") : class_2561.method_43471((String)"main_screen.btn.tms.start");
        if (this.btnTMS.method_25405((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (class_2561)message, (class_339)this.btnTMS);
        }
        class_5250 class_52503 = message = this.anchor == null ? class_2561.method_43471((String)"main_screen.btn.delete.sounds") : class_2561.method_43471((String)"main_screen.btn.delete.anchor");
        if (MufflerScreen.method_25442()) {
            SoundMufflerCommon.renderGui();
            stack.method_25290(SoundMufflerCommon.getTextureRL(), this.btnDelete.method_46426() + 2, this.btnDelete.method_46427() + 1, 54.0f, 217.0f, 13, 13, 256, 256);
            message = class_2561.method_43471((String)"main_screen.btn.delete.list");
        }
        if (this.btnDelete.method_25405((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (class_2561)message, (class_339)this.btnDelete);
        }
        class_5250 searchHint = class_2561.method_43471((String)"gui.recipebook.search_hint").method_27692(class_124.field_1056).method_27692(class_124.field_1080);
        if (!this.searchBar.method_25370() && this.searchBar.method_1882().isEmpty()) {
            stack.method_27535(this.field_22793, (class_2561)searchHint, this.searchBar.method_46426() + 1, this.searchBar.method_46427() + 1, -1);
        }
        boolean bl = notMuffling = this.anchor == null ? muffledSounds.isEmpty() : this.anchor.getMuffledSounds().isEmpty();
        if (notMuffling && this.btnCSL.method_25369().equals(class_2561.method_43471((String)"main_screen.btn.csl.muffled"))) {
            class_5250 text = class_2561.method_43471((String)"main_screen.empty").method_27661().method_27692(class_124.field_1056).method_27692(class_124.field_1080);
            stack.method_27534(this.field_22793, (class_2561)text, this.getX() + 128, this.getY() + 101, 0xFFFFFF);
        }
        float centerX = (float)this.btnCSL.method_46426() + (float)this.btnCSL.method_25368() / 2.0f - (float)this.field_22793.method_1727(this.btnCSL.method_25369().getString()) / 2.0f;
        stack.method_51433(this.field_22793, this.btnCSL.method_25369().getString(), (int)centerX, this.btnCSL.method_46427() + 3, 0, false);
        message = class_2561.method_43469((String)"main_screen.btn.csl.tooltip", (Object[])new Object[]{this.btnCSL.method_25369().getString()});
        if (this.btnCSL.method_25405((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (class_2561)message, (class_339)this.btnCSL);
        }
        message = class_2561.method_43471((String)"main_screen.btn.next_sounds");
        if (this.btnNextSounds.method_25405((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (class_2561)message, (class_339)this.btnNextSounds);
        }
        message = class_2561.method_43471((String)"main_screen.btn.previous_sounds");
        if (this.btnPrevSounds.method_25405((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (class_2561)message, (class_339)this.btnPrevSounds);
        }
        if (mouseX > this.getX() + 30 && mouseX < this.btnAnchor.method_46426() + this.btnAnchor.method_25368() && mouseY > this.btnAnchor.method_46427() && mouseY < this.btnAnchor.method_46427() + this.btnAnchor.method_25364() && CommonConfig.get().disableAnchors().get().booleanValue()) {
            stack.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"main_screen.btn.anchors.disabled"), this.getX() + 60, this.getY() + 40);
        }
        for (class_364 widget : this.method_25396()) {
            if (!(widget instanceof class_339)) continue;
            class_339 btn = (class_339)widget;
            if (btn instanceof MuffledSlider) {
                if (this.anchor == null || this.anchor.getAnchorPos() != null || !((MuffledSlider)widget).getBtnToggleSound().method_25405((double)mouseX, (double)mouseY)) continue;
                this.renderButtonTooltip(stack, (class_2561)class_2561.method_43471((String)"main_screen.btn.anchors.set_message"), (class_339)((MuffledSlider)widget).getBtnToggleSound());
                continue;
            }
            if (!btn.method_25369().getString().matches("[0-9]") || anchorList.isEmpty()) continue;
            String color = ((Anchor)anchorList.get(Integer.parseInt(btn.method_25369().getString()))).getAnchorPos() != null ? "green" : "white";
            this.setFGColor(btn, color);
            if (this.anchor == null || !btn.method_25369().getString().equals(String.valueOf(this.anchor.getAnchorId()))) continue;
            SoundMufflerCommon.renderGui();
            stack.method_25290(SoundMufflerCommon.getTextureRL(), btn.method_46426() - 5, btn.method_46427() - 2, 71.0f, 202.0f, 27, 22, 256, 256);
        }
        if (this.editRadBar.method_25367()) {
            this.renderButtonTooltip(stack, (class_2561)class_2561.method_43471((String)"main_screen.btn.anchors.set_range"), (class_339)this.editRadBar);
        }
        if (this.editAnchorTitleBar.method_25367()) {
            this.renderButtonTooltip(stack, (class_2561)class_2561.method_43471((String)"main_screen.btn.anchors.set_title"), (class_339)this.editAnchorTitleBar);
        }
        if (this.btnSetAnchor.method_25405((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (class_2561)class_2561.method_43471((String)"main_screen.btn.anchors.set"), (class_339)this.btnSetAnchor);
        }
        if (this.btnEditAnchor.method_25405((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (class_2561)class_2561.method_43471((String)"main_screen.btn.anchors.edit"), (class_339)this.btnEditAnchor);
        }
    }

    private void renderSideScreen(class_332 stack) {
        String Radius;
        if (this.anchor == null) {
            return;
        }
        String dimensionName = "";
        int x = this.btnSetAnchor.method_46426();
        int y = this.btnSetAnchor.method_46427();
        int stringW = this.field_22793.method_27525((class_5348)class_2561.method_43471((String)"main_screen.side_screen.dimension"));
        String string = Radius = this.anchor.getRadius() == 0 ? "" : String.valueOf(this.anchor.getRadius());
        if (this.anchor.getDimension() != null) {
            stringW += this.field_22793.method_1727(this.anchor.getDimension().method_12832());
            dimensionName = this.anchor.getDimension().method_12832();
        }
        stack.method_25294(x - 5, y - 57, x + stringW + 7, y + 17, whiteBG);
        stack.method_25294(x - 5, y - 56, x + stringW + 6, y + 16, darkBG);
        stack.method_27535(this.field_22793, (class_2561)class_2561.method_43469((String)"main_screen.side_screen.x", (Object[])new Object[]{this.anchor.getX()}), x + 1, y - 50, 0xFFFFFF);
        stack.method_27535(this.field_22793, (class_2561)class_2561.method_43469((String)"main_screen.side_screen.y", (Object[])new Object[]{this.anchor.getY()}), x + 1, y - 40, 0xFFFFFF);
        stack.method_27535(this.field_22793, (class_2561)class_2561.method_43469((String)"main_screen.side_screen.z", (Object[])new Object[]{this.anchor.getZ()}), x + 1, y - 30, 0xFFFFFF);
        stack.method_27535(this.field_22793, (class_2561)class_2561.method_43469((String)"main_screen.side_screen.radius", (Object[])new Object[]{Radius}), x + 1, y - 20, 0xFFFFFF);
        stack.method_27535(this.field_22793, (class_2561)class_2561.method_43469((String)"main_screen.side_screen.dimension", (Object[])new Object[]{dimensionName}), x + 1, y - 10, 0xFFFFFF);
        SoundMufflerCommon.renderGui();
        stack.method_25290(SoundMufflerCommon.getTextureRL(), x, y, 0.0f, 69.45f, 11, 11, 88, 88);
        if (this.anchor.getAnchorPos() != null) {
            this.btnEditAnchor.field_22763 = true;
            stack.method_25290(SoundMufflerCommon.getTextureRL(), this.btnEditAnchor.method_46426(), this.btnEditAnchor.method_46427(), 32.0f, 213.0f, 11, 11, 256, 256);
        } else {
            this.btnEditAnchor.field_22763 = false;
        }
        x = this.btnSetAnchor.method_46426();
        y = this.editAnchorTitleBar.method_46427();
        if (this.editRadBar.field_22764) {
            stack.method_25294(x + stringW + 7, y - 5, this.editAnchorTitleBar.method_46426() + this.editAnchorTitleBar.method_25368() + 4, this.btnAccept.method_46427() + 23, whiteBG);
            stack.method_25294(x - 5, this.btnAccept.method_46427() + 23, this.editAnchorTitleBar.method_46426() + this.editAnchorTitleBar.method_25368() + 4, this.btnAccept.method_46427() + 24, whiteBG);
            stack.method_25294(x - 6, y - 4, this.editAnchorTitleBar.method_46426() + this.editAnchorTitleBar.method_25368() + 3, this.btnAccept.method_46427() + 23, darkBG);
            stack.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"main_screen.side_screen.title"), x - 2, y + 1, 0xFFFFFF);
            stack.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"main_screen.side_screen.radius"), x - 2, this.editRadBar.method_46427() + 1, 0xFFFFFF);
        }
    }

    private void renderButtonTooltip(class_332 stack, class_2561 message, class_339 button) {
        int CSLShift = button.equals(this.btnCSL) ? 25 : 0;
        int centeredMessageX = button.method_46426() - (this.field_22793.method_27525((class_5348)message) - CSLShift) / 2;
        int centeredMessageY = button.equals(this.btnPrevSounds) || button.equals(this.btnNextSounds) ? button.method_46427() - 1 : button.method_46427() + button.method_25364() + 16;
        stack.method_51438(this.field_22793, message, centeredMessageX, centeredMessageY);
    }

    private void renderTips(class_332 stack) {
        if (CommonConfig.get().showTip().get().booleanValue()) {
            if (this.index % 500 == 0) {
                tip = class_2561.method_43471((String)Tips.randomTip());
                this.index = 0;
            }
            Objects.requireNonNull(this.field_22793);
            int h = 9 * (this.field_22793.method_27525((class_5348)class_2561.method_43469((String)"main_screen.tip", (Object[])new Object[]{tip})) / 240 + 1) + 215;
            stack.method_25294(this.getX() - 2, this.getY() + 208, this.getX() + 257, this.getY() + h + 2, darkBG);
            stack.method_25294(this.getX() - 1, this.getY() + 209, this.getX() + 256, this.getY() + h + 1, goldBG);
            stack.method_25294(this.getX(), this.getY() + 210, this.getX() + 255, this.getY() + h, darkBG);
            stack.method_51440(this.field_22793, (class_5348)class_2561.method_43469((String)"main_screen.tip", (Object[])new Object[]{tip}), this.getX() + 5, this.getY() + 213, 245, 0xFFFFFF);
            ++this.index;
        }
    }

    private void hideSideButtons() {
        this.btnSetAnchor.field_22763 = false;
        this.btnEditAnchor.field_22763 = false;
        this.editAnchorTitleBar.field_22764 = false;
        this.editRadBar.field_22764 = false;
        this.btnAccept.field_22764 = false;
        this.btnCancel.field_22764 = false;
    }

    private void editTitle() {
        this.editAnchorTitleBar.method_1852(this.anchor.getName());
        this.editAnchorTitleBar.field_22764 = !this.editAnchorTitleBar.field_22764;
        this.editRadBar.method_1852(String.valueOf(this.anchor.getRadius()));
        this.editRadBar.field_22764 = !this.editRadBar.field_22764;
        this.btnAccept.field_22764 = !this.btnAccept.field_22764;
        this.btnCancel.field_22764 = !this.btnCancel.field_22764;
        this.editRadBar.method_1868(0xFFFFFF);
    }

    public boolean removeSoundMuffled(class_2960 sound) {
        if (this.anchor != null) {
            if (this.anchor.getAnchorPos() != null) {
                this.anchor.removeSound(sound);
                return true;
            }
        } else {
            muffledSounds.remove(sound);
            return true;
        }
        return false;
    }

    public boolean addSoundMuffled(class_2960 sound, double volume) {
        if (this.anchor != null) {
            if (this.anchor.getAnchorPos() != null) {
                this.anchor.addSound(sound, volume);
                return true;
            }
        } else {
            muffledSounds.put(sound, volume);
            return true;
        }
        return false;
    }

    public void replaceVolume(class_2960 sound, double volume) {
        if (this.anchor != null) {
            this.anchor.replaceSound(sound, volume);
        } else {
            muffledSounds.replace(sound, volume);
        }
    }

    public static boolean isMuffling() {
        return isMuffling;
    }

    private int getX() {
        return (this.field_22789 - 256) / 2;
    }

    private int getY() {
        return (this.field_22790 - 202) / 2;
    }

    public class_2561 getBtnCSLTitle() {
        return this.btnCSL.method_25369();
    }
}

