/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils;

import fuzs.easyanvils.config.ClientConfig;
import fuzs.easyanvils.config.ServerConfig;
import fuzs.easyanvils.handler.ItemInteractionHandler;
import fuzs.easyanvils.init.ModRegistry;
import fuzs.easyanvils.network.S2CAnvilRepairMessage;
import fuzs.easyanvils.network.S2COpenNameTagEditorMessage;
import fuzs.easyanvils.network.client.C2SNameTagUpdateMessage;
import fuzs.easyanvils.network.client.C2SRenameItemMessage;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.ModLifecycleContext;
import fuzs.puzzleslib.api.event.v1.entity.player.AnvilRepairCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.network.v2.MessageDirection;
import fuzs.puzzleslib.api.network.v2.NetworkHandlerV2;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2969;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyAnvils
implements ModConstructor {
    public static final String MOD_ID = "easyanvils";
    public static final String MOD_NAME = "Easy Anvils";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Easy Anvils");
    public static final NetworkHandlerV2 NETWORK = NetworkHandlerV2.build((String)"easyanvils");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"easyanvils").client(ClientConfig.class).server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.touch();
        EasyAnvils.registerMessages();
        EasyAnvils.registerHandlers();
    }

    private static void registerHandlers() {
        PlayerInteractEvents.USE_ITEM.register(ItemInteractionHandler::onUseItem);
        PlayerInteractEvents.USE_BLOCK.register(ItemInteractionHandler::onUseBlock);
        AnvilRepairCallback.EVENT.register(ItemInteractionHandler::onAnvilRepair);
    }

    private static void registerMessages() {
        NETWORK.register(S2COpenNameTagEditorMessage.class, S2COpenNameTagEditorMessage::new, MessageDirection.TO_CLIENT);
        NETWORK.register(C2SNameTagUpdateMessage.class, C2SNameTagUpdateMessage::new, MessageDirection.TO_SERVER);
        NETWORK.register(S2CAnvilRepairMessage.class, S2CAnvilRepairMessage::new, MessageDirection.TO_CLIENT);
        NETWORK.register(C2SRenameItemMessage.class, C2SRenameItemMessage::new, MessageDirection.TO_SERVER);
    }

    public void onCommonSetup(ModLifecycleContext context) {
        context.enqueueWork(() -> class_2315.method_10009((class_1935)class_1802.field_8773, (class_2357)new class_2969(){

            public class_1799 method_10135(class_2342 source, class_1799 stack) {
                if (!((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).anvilRepairing) {
                    return super.method_10135(source, stack);
                }
                class_2350 direction = (class_2350)source.method_10120().method_11654((class_2769)class_2315.field_10918);
                class_2338 pos = source.method_10122().method_10093(direction);
                class_3218 level = source.method_10207();
                class_2680 state = level.method_8320(pos);
                this.method_27955(true);
                if (state.method_26164(class_3481.field_15486)) {
                    if (ItemInteractionHandler.tryRepairAnvil((class_1937)level, pos, state)) {
                        stack.method_7934(1);
                    } else {
                        this.method_27955(false);
                    }
                    return stack;
                }
                return super.method_10135(source, stack);
            }
        }));
    }
}

