/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.network;

import de.ambertation.wunderreich.Wunderreich;
import de.ambertation.wunderreich.network.AddRemoveWunderKisteMessage;
import de.ambertation.wunderreich.network.ChangedSDFMessage;
import de.ambertation.wunderreich.network.ChangedTargetBlockMessage;
import de.ambertation.wunderreich.network.CycleTradesMessage;
import de.ambertation.wunderreich.network.SelectWhisperMessage;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public abstract class ServerBoundPacketHandler<D> {
    protected class_2960 CHANNEL;

    public static <T extends ServerBoundPacketHandler> T register(String channel, T packetHandler) {
        packetHandler.CHANNEL = Wunderreich.ID(channel);
        ServerPlayConnectionEvents.INIT.register((handler, server) -> ServerPlayNetworking.registerReceiver((class_3244)handler, (class_2960)packetHandler.CHANNEL, (_server, _player, _handler, _buf, _responseSender) -> packetHandler.receiveOnServer(_server, _player, _handler, _buf, _responseSender)));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> ServerPlayNetworking.unregisterReceiver((class_3244)handler, (class_2960)packetHandler.CHANNEL));
        return packetHandler;
    }

    public static void register() {
        AddRemoveWunderKisteMessage.INSTANCE.onRegister();
        CycleTradesMessage.INSTANCE.onRegister();
        SelectWhisperMessage.INSTANCE.onRegister();
        ChangedSDFMessage.INSTANCE.onRegister();
        ChangedTargetBlockMessage.INSTANCE.onRegister();
    }

    public void sendToServer(D content) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            this._sendToServer(content);
        }
    }

    private void _sendToServer(D content) {
        class_2540 buf = PacketByteBufs.create();
        this.serializeOnClient(buf, content);
        ClientPlayNetworking.send((class_2960)this.CHANNEL, (class_2540)buf);
    }

    void receiveOnServer(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        D content = this.deserializeOnServer(buf, player, responseSender);
        server.execute(() -> this.processOnGameThread(server, player, content));
    }

    protected abstract void serializeOnClient(class_2540 var1, D var2);

    protected abstract D deserializeOnServer(class_2540 var1, class_3222 var2, PacketSender var3);

    protected abstract void processOnGameThread(MinecraftServer var1, class_3222 var2, D var3);

    protected void onRegister() {
    }
}

