/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.network;

import de.ambertation.wunderreich.Wunderreich;
import de.ambertation.wunderreich.config.Configs;
import de.ambertation.wunderreich.interfaces.IMerchantMenu;
import de.ambertation.wunderreich.items.TrainedVillagerWhisperer;
import de.ambertation.wunderreich.items.VillagerWhisperer;
import de.ambertation.wunderreich.network.ClosestWhisperer;
import de.ambertation.wunderreich.network.ServerBoundPacketHandler;
import de.ambertation.wunderreich.registries.WunderreichItems;
import de.ambertation.wunderreich.registries.WunderreichRules;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1728;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.server.MinecraftServer;

public class CycleTradesMessage
extends ServerBoundPacketHandler<Content> {
    public static final CycleTradesMessage INSTANCE = ServerBoundPacketHandler.register("cycle_trades", new CycleTradesMessage());

    protected CycleTradesMessage() {
    }

    public static class_1799 holds(class_1657 player, class_1792 item) {
        if (player.method_6047().method_31574(item)) {
            return player.method_6047();
        }
        if (player.method_6079().method_31574(item)) {
            return player.method_6079();
        }
        return null;
    }

    public static class_1799 containsWhisperer(class_1657 player) {
        class_1799 res = null;
        if (Configs.ITEM_CONFIG.isEnabled(WunderreichItems.BLANK_WHISPERER)) {
            res = CycleTradesMessage.holds(player, WunderreichItems.BLANK_WHISPERER);
        }
        if (res == null && Configs.ITEM_CONFIG.isEnabled(WunderreichItems.WHISPERER)) {
            if (player.method_6047().method_7909() instanceof TrainedVillagerWhisperer) {
                res = player.method_6047();
            } else if (player.method_6079().method_7909() instanceof TrainedVillagerWhisperer) {
                res = player.method_6079();
            }
        }
        return res;
    }

    public static ClosestWhisperer getClosestWhisperer(class_1646 villager, boolean doLog) {
        class_1937 class_19372 = villager.method_37908();
        if (class_19372 instanceof class_3218) {
            class_1304 slot;
            class_1799 whisperer;
            class_3218 server = (class_3218)class_19372;
            class_1657 p = server.method_18460((class_1297)villager, 6.0);
            if (p == null) {
                return null;
            }
            class_1799 mainHand = p.method_6047();
            class_1799 offHand = p.method_6079();
            if (mainHand.method_31574(WunderreichItems.WHISPERER)) {
                whisperer = mainHand;
                slot = class_1304.field_6173;
            } else if (offHand.method_31574(WunderreichItems.WHISPERER)) {
                whisperer = offHand;
                slot = class_1304.field_6171;
            } else {
                return null;
            }
            if (doLog) {
                Wunderreich.LOGGER.info("Player " + p.method_5477() + " uses Whisperer on Librarian");
            }
            return new ClosestWhisperer(whisperer, p, slot);
        }
        return null;
    }

    public static boolean canSelectTrades(class_1646 villager) {
        return CycleTradesMessage.canSelectTrades(villager, true);
    }

    public static boolean canSelectTrades(class_1646 villager, boolean doLog) {
        if (!WunderreichRules.Whispers.allowLibrarianSelection()) {
            return false;
        }
        if (villager == null || villager.method_19269() > 0) {
            return false;
        }
        class_3850 villagerData = villager.method_7231();
        class_3852 profession = villagerData.method_16924();
        if (profession == null || !class_3852.field_17060.equals((Object)profession)) {
            return false;
        }
        ClosestWhisperer whispererStack = CycleTradesMessage.getClosestWhisperer(villager, doLog);
        return whispererStack != null;
    }

    public static boolean hasSelectedTrades(class_1646 villager, class_1916 offers) {
        if (offers == null) {
            return true;
        }
        if (!CycleTradesMessage.canSelectTrades(villager, false)) {
            return true;
        }
        ClosestWhisperer whispererStack = CycleTradesMessage.getClosestWhisperer(villager, false);
        if (whispererStack == null) {
            return true;
        }
        VillagerWhisperer whisperer = (VillagerWhisperer)whispererStack.stack().method_7909();
        for (class_1914 offer : offers) {
            if (!offer.method_8250().method_31574(class_1802.field_8598)) continue;
            class_2499 enchantments = class_1772.method_7806((class_1799)offer.method_8250());
            if (!enchantments.isEmpty()) {
                int duraCost;
                class_2960 type = class_1890.method_37427((class_2487)enchantments.method_10602(0));
                int n = duraCost = WunderreichRules.Whispers.cyclingNeedsWhisperer() ? 1 : 2;
                if (whisperer instanceof TrainedVillagerWhisperer) {
                    TrainedVillagerWhisperer trained = (TrainedVillagerWhisperer)whisperer;
                    if (!type.equals((Object)trained.getEnchantmentID(whispererStack.stack()))) continue;
                    whispererStack.stack().method_7956(duraCost, (class_1309)whispererStack.player(), player -> player.method_20235(whispererStack.slot()));
                    return true;
                }
                whispererStack.stack().method_7956(duraCost, (class_1309)whispererStack.player(), player -> player.method_20235(whispererStack.slot()));
                return true;
            }
            return true;
        }
        return false;
    }

    public static void cycleTrades(class_3222 player) {
        if (!(player.field_7512 instanceof class_1728)) {
            return;
        }
        if (!WunderreichRules.Whispers.allowTradesCycling()) {
            return;
        }
        class_1728 menu = (class_1728)player.field_7512;
        if (menu instanceof IMerchantMenu) {
            IMerchantMenu mmenu = (IMerchantMenu)menu;
            class_1646 villager = mmenu.wunder_getVillager();
            if (villager == null || villager.method_19269() > 0) {
                return;
            }
            if (WunderreichRules.Whispers.cyclingNeedsWhisperer()) {
                class_1799 whisp = CycleTradesMessage.containsWhisperer((class_1657)player);
                if (whisp == null) {
                    return;
                }
                whisp.method_7956(1, (class_1309)player, pp -> pp.method_20236(player.method_6047().method_31574(whisp.method_7909()) ? class_1268.field_5808 : class_1268.field_5810));
            }
            villager.method_16917(null);
            player.method_17354(menu.field_7763, villager.method_8264(), villager.method_7231().method_16925(), villager.method_19269(), villager.method_19270(), villager.method_20708());
        }
    }

    public void send() {
        this.sendToServer(null);
    }

    @Override
    protected void serializeOnClient(class_2540 buf, Content content) {
    }

    @Override
    protected Content deserializeOnServer(class_2540 buf, class_3222 player, PacketSender responseSender) {
        return null;
    }

    @Override
    protected void processOnGameThread(MinecraftServer server, class_3222 player, Content content) {
        CycleTradesMessage.cycleTrades(player);
    }

    protected record Content() {
    }
}

