/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.network;

import de.ambertation.wunderlib.math.Transform;
import de.ambertation.wunderlib.math.sdf.interfaces.MaterialProvider;
import de.ambertation.wunderlib.math.sdf.interfaces.Transformable;
import de.ambertation.wunderreich.gui.construction.RulerContainerMenu;
import de.ambertation.wunderreich.items.construction.ConstructionData;
import de.ambertation.wunderreich.network.ServerBoundPacketHandler;
import de.ambertation.wunderreich.registries.WunderreichItems;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ChangedSDFMessage
extends ServerBoundPacketHandler<Content> {
    public static final ChangedSDFMessage INSTANCE = ServerBoundPacketHandler.register("chg_sdf", new ChangedSDFMessage());

    protected ChangedSDFMessage() {
    }

    public void sendActive(class_1703 menu, int id) {
        this.sendToServer(new Content(menu == null ? -1 : menu.field_7763, 1, id, -1, null));
    }

    public void sendMaterial(class_1703 menu, int id) {
        this.sendToServer(new Content(menu == null ? -1 : menu.field_7763, 2, -1, id, null));
    }

    public void sendRealize(class_1703 menu) {
        this.sendToServer(new Content(menu == null ? -1 : menu.field_7763, 4, -1, -1, null));
    }

    public void sendTransform(class_1703 menu, Transform t) {
        if (t == null) {
            return;
        }
        this.sendToServer(new Content(menu == null ? -1 : menu.field_7763, 8, -1, -1, t));
    }

    @Override
    protected void serializeOnClient(class_2540 buf, Content content) {
        buf.writeByte(content.containerId);
        buf.method_10804(content.stateFlag);
        if ((content.stateFlag & 1) == 1) {
            buf.method_10804(content.active);
        }
        if ((content.stateFlag & 2) == 2) {
            buf.method_10804(content.material);
        }
        if ((content.stateFlag & 8) == 8) {
            content.transform.serializeToNetwork(buf);
        }
    }

    @Override
    protected Content deserializeOnServer(class_2540 buf, class_3222 player, PacketSender responseSender) {
        return new Content(buf, player);
    }

    @Override
    protected void processOnGameThread(MinecraftServer server, class_3222 player, Content content) {
        class_1799 s;
        ConstructionData constructionData = null;
        if (content.containerId == player.field_7512.field_7763) {
            class_1703 class_17032 = player.field_7512;
            if (class_17032 instanceof RulerContainerMenu) {
                RulerContainerMenu menu = (RulerContainerMenu)class_17032;
                constructionData = menu.data;
            }
        } else if ((content.containerId == -1 || content.containerId == 255) && (s = player.method_6047()).method_31574(WunderreichItems.RULER)) {
            constructionData = ConstructionData.getConstructionData(s);
        }
        if (constructionData == null) {
            return;
        }
        if ((content.stateFlag & 1) == 1) {
            constructionData.ACTIVE_SLOT.set(content.active);
            System.out.println(Integer.toHexString(constructionData.hashCode()) + "---- [ACTIVE_SLOT] ------------------");
            System.out.println(constructionData.SDF_DATA.get() + ", act=" + constructionData.ACTIVE_SLOT.get());
            System.out.println("-------------------------------------");
        }
        if ((content.stateFlag & 2) == 2 && (s = constructionData.getActiveSDF()) != null && s instanceof MaterialProvider) {
            MaterialProvider mp = (MaterialProvider)s;
            mp.setMaterialIndex(content.material);
            constructionData.SDF_DATA.set(s.getRoot());
        }
        if ((content.stateFlag & 4) == 4) {
            constructionData.realize(server, player);
        }
        if ((content.stateFlag & 8) == 8 && (s = constructionData.getActiveSDF()) != null && s instanceof Transformable) {
            Transformable t = (Transformable)s;
            t.setLocalTransform(content.transform);
            constructionData.SDF_DATA.set(s.getRoot());
        }
    }

    protected static final class Content {
        public static final int CHANGE_ACTIVE = 1;
        public static final int CHANGE_MATERIAL = 2;
        public static final int REALIZE = 4;
        public static final int CHANGE_TRANSFORM = 8;
        public final int containerId;
        public final int stateFlag;
        public final int active;
        public final int material;
        public final Transform transform;

        private Content(int containerId, int stateFlag, int active, int material, Transform transform) {
            this.containerId = containerId;
            this.stateFlag = stateFlag;
            this.active = active;
            this.material = material;
            this.transform = transform;
        }

        private Content(class_2540 buf, class_3222 player) {
            this.containerId = buf.readUnsignedByte();
            this.stateFlag = buf.method_10816();
            this.active = (this.stateFlag & 1) == 1 ? buf.method_10816() : -1;
            this.material = (this.stateFlag & 2) == 2 ? buf.method_10816() : -1;
            this.transform = (this.stateFlag & 8) == 8 ? Transform.deserializeFromNetwork((class_2540)buf) : null;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Content that = (Content)obj;
            return this.containerId == that.containerId && this.stateFlag == that.stateFlag && this.active == that.active && this.material == that.material;
        }

        public int hashCode() {
            return Objects.hash(this.containerId, this.stateFlag, this.active, this.material);
        }

        public String toString() {
            return "Content[containerId=" + this.containerId + ", stateFlag=" + this.stateFlag + ", active=" + this.active + ", material=" + this.material + "]";
        }
    }
}

