/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.gui.overlay;

import com.google.common.collect.ImmutableList;
import de.ambertation.wunderlib.math.Bounds;
import de.ambertation.wunderlib.math.Float2;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderlib.math.Transform;
import de.ambertation.wunderlib.ui.layout.LineWithWidth;
import de.ambertation.wunderlib.ui.layout.components.MultiLineText;
import de.ambertation.wunderreich.gui.overlay.RenderContext;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_863;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class TextRenderer {
    public static void render(@NotNull RenderContext ctx, Float3 pos, String content, int color) {
        ctx.pushText(content, pos, color);
    }

    public static void render(@NotNull RenderContext ctx, Float3 pos, int color) {
        ctx.pushText(pos.toString(), pos, color);
    }

    public static void render(@NotNull RenderContext ctx, Float3 pos, Float3 content, int color) {
        ctx.pushText(content.toString(), pos, color);
    }

    public static void render(@NotNull RenderContext ctx, Float3 pos, Bounds content, int color) {
        ctx.pushText(content.toString(), pos, color);
    }

    public static void render(@NotNull RenderContext ctx, Float3 pos, Transform content, int color) {
        ctx.pushText(content.toString(), pos, color);
    }

    public static float draw(class_332 guiGraphics, class_327 font, Float2 pos, int maxWidth, class_2561 c, int color) {
        c = MultiLineText.parse((class_2561)c);
        ImmutableList lines = (ImmutableList)font.method_1728((class_5348)c, maxWidth).stream().map(component -> new LineWithWidth(component, font.method_30880(component))).collect(ImmutableList.toImmutableList());
        int x = (int)pos.x;
        int y = (int)pos.y;
        for (LineWithWidth line : lines) {
            guiGraphics.method_35720(font, line.text(), x, y, color);
            Objects.requireNonNull(font);
            y += 9;
        }
        return y;
    }

    public record TextItem(String content, Float3 pos, int color) {
        public void render(@NotNull RenderContext ctx) {
            class_863.method_23105((class_4587)ctx.poseStack(), (class_4597)ctx.bufferSource(), (String)this.content, (double)this.pos.x, (double)this.pos.y, (double)this.pos.z, (int)this.color);
        }
    }
}

