/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.gui.overlay;

import de.ambertation.wunderlib.math.Float2;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderlib.math.Quaternion;
import de.ambertation.wunderlib.math.Transform;
import de.ambertation.wunderlib.math.sdf.SDF;
import de.ambertation.wunderreich.Wunderreich;
import de.ambertation.wunderreich.items.construction.ConstructionData;
import de.ambertation.wunderreich.mixin.client.overlay.MouseHandlerAccessor;
import de.ambertation.wunderreich.network.ChangedSDFMessage;
import de.ambertation.wunderreich.registries.WunderreichItems;
import java.util.function.BiFunction;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_4184;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3f;

public class InputManager {
    public static final InputManager INSTANCE = new InputManager();
    public static final int CONTROL_WIDGET_RADIUS = 25;
    public static final int LOCK_X = 1;
    public static final int LOCK_Y = 2;
    public static final int LOCK_Z = 4;
    public static final int LOCK_LOCAL = 8;
    public static final int LOCK_INVERT = 16;
    public static final int LOCK_SET = 32;
    private boolean transformMode = false;
    private class_1799 ruler = null;
    private Mode mode = Mode.NONE;
    private int lockFlag = 0;
    private boolean shiftDown = false;
    private boolean altDown = false;
    private boolean ctrlDown = false;
    private double lastX;
    private double lastY;
    private double startX;
    private double startY;
    private boolean negative = false;
    private String numberString = null;
    private class_4184 camera;
    private Transform startTransform = Transform.IDENTITY;
    private static final double MOUSE_SCALE = 0.1;

    public class_1799 getActiveRuler() {
        return this.ruler;
    }

    @ApiStatus.Internal
    public boolean handleKey(char keyChar, class_3675.class_306 key, int button) {
        int keyValue = key.method_1444();
        Wunderreich.LOGGER.info("handleKey: " + this.inTransformMode() + ", button=" + button + " - " + (button == 1) + ", key=" + key + ", c=" + keyChar + "(" + keyChar + "), mode=" + this.mode + ", lock=" + this.lockFlag + ", ruler=" + this.ruler + ", shift=" + this.shiftDown);
        if (keyValue == 340 || keyValue == 344) {
            if (button == 0) {
                this.shiftDown = false;
            } else if (button == 1) {
                this.shiftDown = true;
            }
        } else if (keyValue == 342 || keyValue == 346) {
            if (button == 0) {
                this.altDown = false;
            } else if (button == 1) {
                this.altDown = true;
            }
        } else if (keyValue == 341 || keyValue == 345) {
            if (button == 0) {
                this.ctrlDown = false;
            } else if (button == 1) {
                this.ctrlDown = true;
            }
        }
        if (class_310.method_1551().field_1755 != null) {
            return false;
        }
        if (this.inTransformMode()) {
            if (this.mode != Mode.NONE && (keyValue == 340 || keyValue == 344)) {
                return true;
            }
            if (button == 1) {
                if (this.mode == Mode.NONE) {
                    if (keyValue == 256) {
                        this.stopTransformMode();
                        return true;
                    }
                    switch (keyChar) {
                        case 't': {
                            if (this.altDown) {
                                this.updateTransform((sdf, t) -> t.moveTo(sdf.defaultTransform().center));
                                return true;
                            }
                            this.startTransformMode(Mode.TRANSLATE);
                            return true;
                        }
                        case 'r': {
                            if (this.altDown) {
                                this.updateTransform((sdf, t) -> t.setRotation(sdf.defaultTransform().rotation));
                                return true;
                            }
                            this.startTransformMode(Mode.ROTATE);
                            return true;
                        }
                        case 'z': {
                            if (this.altDown) {
                                this.updateTransform((sdf, t) -> t.setScale(sdf.defaultTransform().size));
                                return true;
                            }
                            this.startTransformMode(Mode.SCALE);
                            return true;
                        }
                    }
                } else {
                    if (keyValue == 256) {
                        this.endTransformMode(false);
                        return true;
                    }
                    if (keyValue == 257) {
                        this.endTransformMode(true);
                        return true;
                    }
                    if (keyValue == 259) {
                        this.addToNumberString(keyValue, keyChar);
                        return true;
                    }
                    switch (keyChar) {
                        case ',': 
                        case '-': 
                        case '.': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            this.addToNumberString(keyValue, keyChar);
                            return true;
                        }
                        case 'o': {
                            this.lockFlag ^= 0x20;
                            this.updateTransform();
                            return true;
                        }
                        case 'x': {
                            if ((this.lockFlag & 1) == 0) {
                                this.lockFlag = 1;
                                if (this.shiftDown) {
                                    this.lockFlag |= 0x10;
                                }
                            } else {
                                this.lockFlag ^= 8;
                            }
                            this.updateTransform();
                            return true;
                        }
                        case 'y': {
                            if ((this.lockFlag & 2) == 0) {
                                this.lockFlag = 2;
                                if (this.shiftDown) {
                                    this.lockFlag |= 0x10;
                                }
                            } else {
                                this.lockFlag ^= 8;
                            }
                            this.updateTransform();
                            return true;
                        }
                        case 'z': {
                            if ((this.lockFlag & 4) == 0) {
                                this.lockFlag = 4;
                                if (this.shiftDown) {
                                    this.lockFlag |= 0x10;
                                }
                            } else {
                                this.lockFlag ^= 8;
                            }
                            this.updateTransform();
                            return true;
                        }
                        case 'a': 
                        case 'd': 
                        case 's': 
                        case 'w': {
                            return false;
                        }
                    }
                }
            }
        }
        return false;
    }

    private void addToNumberString(int keyValue, char keyChar) {
        if (keyChar == '-') {
            this.negative = !this.negative;
        } else if (keyValue == 259) {
            if (this.numberString != null && !this.numberString.isBlank()) {
                this.numberString = this.numberString.substring(0, this.numberString.length() - 1);
            }
        } else {
            if (this.numberString == null) {
                this.numberString = "";
            }
            if (keyChar == ',') {
                keyChar = (char)46;
            }
            this.numberString = this.numberString + keyChar;
        }
        this.updateTransform();
    }

    private void updateTransform() {
        if (this.mode == Mode.TRANSLATE) {
            this.updateTransform(this::getMouseTranslation);
        } else if (this.mode == Mode.SCALE) {
            this.updateTransform(this::getMouseScale);
        } else if (this.mode == Mode.ROTATE) {
            this.updateTransform(this::getMouseRotation);
        }
    }

    private Transform getMouseScale(SDF sdf, Transform t) {
        double scale = this.getDelta().x;
        if ((this.lockFlag & 0x20) == 32) {
            Float3 size = t.size;
            if ((this.lockFlag & 0x10) == 16) {
                if ((this.lockFlag & 1) == 1) {
                    return this.startTransform.setScale(Float3.of((double)size.x, (double)scale, (double)scale));
                }
                if ((this.lockFlag & 2) == 2) {
                    return this.startTransform.setScale(Float3.of((double)scale, (double)size.y, (double)scale));
                }
                if ((this.lockFlag & 4) == 4) {
                    return this.startTransform.setScale(Float3.of((double)scale, (double)scale, (double)size.z));
                }
            } else {
                if ((this.lockFlag & 1) == 1) {
                    return this.startTransform.setScale(Float3.of((double)scale, (double)size.y, (double)size.z));
                }
                if ((this.lockFlag & 2) == 2) {
                    return this.startTransform.setScale(Float3.of((double)size.x, (double)scale, (double)size.z));
                }
                if ((this.lockFlag & 4) == 4) {
                    return this.startTransform.setScale(Float3.of((double)size.x, (double)size.y, (double)scale));
                }
            }
        } else if ((this.lockFlag & 8) == 8) {
            if ((this.lockFlag & 0x10) == 16) {
                if ((this.lockFlag & 1) == 1) {
                    return this.startTransform.scaleBy(sdf.getWorldTransformMatrix().getBasisY().mul(scale).add(sdf.getWorldTransformMatrix().getBasisZ().mul(scale)).add(sdf.getWorldTransformMatrix().getBasisX()));
                }
                if ((this.lockFlag & 2) == 2) {
                    return this.startTransform.scaleBy(sdf.getWorldTransformMatrix().getBasisX().mul(scale).add(sdf.getWorldTransformMatrix().getBasisZ().mul(scale)).add(sdf.getWorldTransformMatrix().getBasisY()));
                }
                if ((this.lockFlag & 4) == 4) {
                    return this.startTransform.scaleBy(sdf.getWorldTransformMatrix().getBasisX().mul(scale).add(sdf.getWorldTransformMatrix().getBasisY().mul(scale)).add(sdf.getWorldTransformMatrix().getBasisZ()));
                }
            } else {
                if ((this.lockFlag & 1) == 1) {
                    return this.startTransform.scaleBy(sdf.getWorldTransformMatrix().getBasisX().mul(scale).add(sdf.getWorldTransformMatrix().getBasisY()).add(sdf.getWorldTransformMatrix().getBasisZ()));
                }
                if ((this.lockFlag & 2) == 2) {
                    return this.startTransform.scaleBy(sdf.getWorldTransformMatrix().getBasisX().add(sdf.getWorldTransformMatrix().getBasisY().mul(scale)).add(sdf.getWorldTransformMatrix().getBasisZ()));
                }
                if ((this.lockFlag & 4) == 4) {
                    return this.startTransform.scaleBy(sdf.getWorldTransformMatrix().getBasisX().add(sdf.getWorldTransformMatrix().getBasisY()).add(sdf.getWorldTransformMatrix().getBasisZ().mul(scale)));
                }
            }
        } else if ((this.lockFlag & 0x10) == 16) {
            if ((this.lockFlag & 1) == 1) {
                return this.startTransform.scaleBy(Float3.of((double)1.0, (double)scale, (double)scale));
            }
            if ((this.lockFlag & 2) == 2) {
                return this.startTransform.scaleBy(Float3.of((double)scale, (double)1.0, (double)scale));
            }
            if ((this.lockFlag & 4) == 4) {
                return this.startTransform.scaleBy(Float3.of((double)scale, (double)scale, (double)1.0));
            }
        } else {
            if ((this.lockFlag & 1) == 1) {
                return this.startTransform.scaleBy(Float3.of((double)scale, (double)1.0, (double)1.0));
            }
            if ((this.lockFlag & 2) == 2) {
                return this.startTransform.scaleBy(Float3.of((double)1.0, (double)scale, (double)1.0));
            }
            if ((this.lockFlag & 4) == 4) {
                return this.startTransform.scaleBy(Float3.of((double)1.0, (double)1.0, (double)scale));
            }
        }
        if (this.camera != null) {
            return this.startTransform.scaleBy(Float3.of((double)scale));
        }
        return t;
    }

    private Transform getMouseRotation(SDF sdf, Transform t) {
        double angle = this.getDelta().x;
        Float3 axis = null;
        if ((this.lockFlag & 8) == 8) {
            if ((this.lockFlag & 1) == 1) {
                axis = sdf.getWorldTransformMatrix().getBasisX();
            } else if ((this.lockFlag & 2) == 2) {
                axis = sdf.getWorldTransformMatrix().getBasisY();
            } else if ((this.lockFlag & 4) == 4) {
                axis = sdf.getWorldTransformMatrix().getBasisZ();
            }
        } else if ((this.lockFlag & 1) == 1) {
            axis = Float3.X_AXIS;
        } else if ((this.lockFlag & 2) == 2) {
            axis = Float3.Y_AXIS;
        } else if ((this.lockFlag & 4) == 4) {
            axis = Float3.Z_AXIS;
        }
        if (this.camera != null && axis == null) {
            axis = Float3.of((Vector3f)this.camera.method_19335());
        }
        if (axis == null) {
            return t;
        }
        if ((this.lockFlag & 0x20) == 32) {
            return this.startTransform.setRotation(Quaternion.ofAxisAngle((Float3)axis, (double)angle));
        }
        return this.startTransform.rotateBy(Quaternion.ofAxisAngle((Float3)axis, (double)angle));
    }

    private Transform getMouseTranslation(SDF sdf, Transform t) {
        Float2 delta = this.getDelta();
        if ((this.lockFlag & 0x20) == 32) {
            Float3 pos = t.center;
            if ((this.lockFlag & 0x10) == 16) {
                if ((this.lockFlag & 1) == 1) {
                    return this.startTransform.moveTo(Float3.of((double)pos.x, (double)delta.y, (double)delta.x));
                }
                if ((this.lockFlag & 2) == 2) {
                    return this.startTransform.moveTo(Float3.of((double)delta.x, (double)pos.y, (double)delta.y));
                }
                if ((this.lockFlag & 4) == 4) {
                    return this.startTransform.moveTo(Float3.of((double)delta.x, (double)delta.y, (double)pos.z));
                }
            } else {
                if ((this.lockFlag & 1) == 1) {
                    return this.startTransform.moveTo(Float3.of((double)delta.x, (double)pos.y, (double)pos.z));
                }
                if ((this.lockFlag & 2) == 2) {
                    return this.startTransform.moveTo(Float3.of((double)pos.x, (double)delta.y, (double)pos.z));
                }
                if ((this.lockFlag & 4) == 4) {
                    return this.startTransform.moveTo(Float3.of((double)pos.x, (double)pos.y, (double)delta.x));
                }
            }
        } else if ((this.lockFlag & 8) == 8) {
            if ((this.lockFlag & 0x10) == 16) {
                if ((this.lockFlag & 1) == 1) {
                    return this.startTransform.moveBy(sdf.getWorldTransformMatrix().getBasisY().mul(delta.y).add(sdf.getWorldTransformMatrix().getBasisZ().mul(delta.x)));
                }
                if ((this.lockFlag & 2) == 2) {
                    return this.startTransform.moveBy(sdf.getWorldTransformMatrix().getBasisX().mul(delta.x).add(sdf.getWorldTransformMatrix().getBasisZ().mul(delta.y)));
                }
                if ((this.lockFlag & 4) == 4) {
                    return this.startTransform.moveBy(sdf.getWorldTransformMatrix().getBasisX().mul(delta.x).add(sdf.getWorldTransformMatrix().getBasisY().mul(delta.y)));
                }
            } else {
                if ((this.lockFlag & 1) == 1) {
                    return this.startTransform.moveBy(sdf.getWorldTransformMatrix().getBasisX().mul(delta.x));
                }
                if ((this.lockFlag & 2) == 2) {
                    return this.startTransform.moveBy(sdf.getWorldTransformMatrix().getBasisY().mul(delta.y));
                }
                if ((this.lockFlag & 4) == 4) {
                    return this.startTransform.moveBy(sdf.getWorldTransformMatrix().getBasisZ().mul(delta.x));
                }
            }
        } else if ((this.lockFlag & 0x10) == 16) {
            if ((this.lockFlag & 1) == 1) {
                return this.startTransform.moveBy(Float3.of((double)0.0, (double)delta.y, (double)delta.x));
            }
            if ((this.lockFlag & 2) == 2) {
                return this.startTransform.moveBy(Float3.of((double)delta.x, (double)0.0, (double)delta.y));
            }
            if ((this.lockFlag & 4) == 4) {
                return this.startTransform.moveBy(Float3.of((double)delta.x, (double)delta.y, (double)0.0));
            }
        } else {
            if ((this.lockFlag & 1) == 1) {
                return this.startTransform.moveBy(Float3.of((double)delta.x, (double)0.0, (double)0.0));
            }
            if ((this.lockFlag & 2) == 2) {
                return this.startTransform.moveBy(Float3.of((double)0.0, (double)delta.y, (double)0.0));
            }
            if ((this.lockFlag & 4) == 4) {
                return this.startTransform.moveBy(Float3.of((double)0.0, (double)0.0, (double)delta.x));
            }
        }
        if (this.camera != null) {
            Float3 up = Float3.of((Vector3f)this.camera.method_19336()).mul(-1.0 * delta.y);
            Float3 left = Float3.of((Vector3f)this.camera.method_35689()).mul(-1.0 * delta.x);
            return this.startTransform.moveBy(up.add(left));
        }
        return this.startTransform;
    }

    private void updateTransform(BiFunction<SDF, Transform, Transform> updater) {
        ConstructionData cd;
        if (this.ruler != null && (cd = ConstructionData.getConstructionData(this.ruler)) != null) {
            Transform newT = cd.updateActiveTransformOnClient(updater);
            ChangedSDFMessage.INSTANCE.sendTransform(null, newT);
        }
    }

    public Transform getCurrentTransform() {
        SDF s;
        ConstructionData cd;
        if (this.ruler != null && (cd = ConstructionData.getConstructionData(this.ruler)) != null && (s = cd.getActiveSDF()) != null) {
            return s.getLocalTransform();
        }
        return Transform.IDENTITY;
    }

    @ApiStatus.Internal
    public boolean onMove(MouseHandlerAccessor h, double mouseX, double mouseY) {
        boolean handled = false;
        if (this.inTransformMode() && class_310.method_1551().field_1755 == null) {
            if (this.mode != Mode.NONE && this.ruler != null) {
                h.wunder_setXPos(mouseX);
                h.wunder_setYPos(mouseY);
                h.wunder_setAccumulatedDX(0.0);
                h.wunder_setAccumulatedDY(0.0);
                this.lastX = mouseX;
                this.lastY = mouseY;
                if (this.mode == Mode.TRANSLATE) {
                    Float3 delta = Float3.of((double)(0.1 * (mouseX - this.lastX)), (double)(0.1 * (mouseY - this.lastY)), (double)0.0);
                    System.out.println("x:" + mouseX + ", y:" + mouseY + ", dx:" + delta.x + ", dy" + delta.y);
                    this.updateTransform(this::getMouseTranslation);
                } else if (this.mode == Mode.ROTATE) {
                    Float3 delta = Float3.of((double)(0.1 * (mouseX - this.lastX)), (double)(0.1 * (mouseY - this.lastY)), (double)0.0);
                    System.out.println("x:" + mouseX + ", y:" + mouseY + ", dx:" + delta.x + ", dy" + delta.y);
                    this.updateTransform(this::getMouseRotation);
                } else if (this.mode == Mode.SCALE) {
                    Float3 delta = Float3.of((double)(0.1 * (mouseX - this.startX)), (double)(0.1 * (mouseY - this.startY)), (double)0.0).add(1.0);
                    System.out.println("x:" + mouseX + ", y:" + mouseY + ", dx:" + delta.x + ", dy" + delta.y);
                    this.updateTransform(this::getMouseScale);
                }
                handled = true;
            }
        } else {
            this.lastX = mouseX;
            this.lastY = mouseY;
        }
        return handled;
    }

    @ApiStatus.Internal
    public boolean onPress(int button, int state, int unk) {
        if (class_310.method_1551().field_1755 != null) {
            return false;
        }
        if (this.inTransformMode() && this.mode != Mode.NONE) {
            if (state == 0) {
                this.endTransformMode(true);
            }
            return true;
        }
        System.out.println(button + ", " + state + ", " + unk);
        return false;
    }

    private void endTransformMode(boolean accept) {
        this.mode = Mode.NONE;
        this.lockFlag = 0;
        if (!accept) {
            this.updateTransform((sdf, t) -> this.startTransform);
        }
        Wunderreich.LOGGER.info("endTransformMode: " + this.inTransformMode() + ", mode=" + this.mode + ", lock=" + this.lockFlag + ", ruler=" + this.ruler + ", shift=" + this.shiftDown);
    }

    private void startTransformMode(Mode mode) {
        this.mode = mode;
        this.lockFlag = 0;
        this.numberString = null;
        this.negative = false;
        this.startTransform = this.getCurrentTransform();
        this.startX = this.lastX;
        this.startY = this.lastY;
        Wunderreich.LOGGER.info("startTransformMode: " + this.inTransformMode() + ", mode=" + mode + ", lock=" + this.lockFlag + ", ruler=" + this.ruler + ", shift=" + this.shiftDown);
    }

    public void startTransformMode() {
        SDF sdf;
        ConstructionData constructionData;
        class_1799 stack = class_310.method_1551().field_1724.method_6047();
        if (stack.method_31574(WunderreichItems.RULER) && (constructionData = ConstructionData.getConstructionData(stack)) != null && (sdf = constructionData.SDF_DATA.get()) != null && !sdf.isEmpty()) {
            this.ruler = stack;
            this.transformMode = true;
        }
    }

    public void stopTransformMode() {
        this.transformMode = false;
    }

    public boolean inTransformMode() {
        return this.transformMode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public int getLockFlag() {
        return this.lockFlag;
    }

    public void setCamera(class_4184 camera) {
        this.camera = camera;
    }

    public String getNumberString() {
        if (this.negative) {
            return "-" + this.numberString;
        }
        return this.numberString;
    }

    public boolean hasNumberString() {
        return this.numberString != null && !this.numberString.isBlank();
    }

    public boolean isValidNumberString() {
        if (!this.hasNumberString()) {
            return false;
        }
        try {
            Double.parseDouble(this.getNumberString());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public double getNumberStringValue() {
        if (!this.isValidNumberString()) {
            return 0.0;
        }
        return Double.parseDouble(this.getNumberString());
    }

    public Float2 getMouseDelta() {
        if (this.mode == Mode.NONE) {
            return Float2.ZERO;
        }
        if (!this.inTransformMode()) {
            return Float2.ZERO;
        }
        if (this.mode == Mode.SCALE) {
            return Float2.of((double)(this.lastX - (this.startX - 25.0)), (double)(this.lastY - this.startY));
        }
        if (this.mode == Mode.ROTATE) {
            return Float2.of((double)(this.lastX - this.startX), (double)(this.lastY - (this.startY - 25.0)));
        }
        if (this.mode == Mode.TRANSLATE && (this.lockFlag & 0x10) != 16 && this.lockFlag != 0) {
            if ((this.lockFlag & 2) == 2) {
                return Float2.of((double)0.0, (double)(this.lastY - this.startY));
            }
            return Float2.of((double)(this.lastX - this.startX), (double)0.0);
        }
        return Float2.of((double)(this.lastX - this.startX), (double)(this.lastY - this.startY));
    }

    public Float2 getDelta() {
        Float2 res = this.getDeltaInternal();
        if (this.ctrlDown) {
            res = res.round();
        }
        return res;
    }

    private Float2 getDeltaInternal() {
        if (this.isValidNumberString()) {
            if (this.mode == Mode.SCALE) {
                return Float2.of((double)this.getNumberStringValue(), (double)0.0);
            }
            if (this.mode == Mode.ROTATE) {
                return Float2.of((double)Math.toRadians(this.getNumberStringValue()), (double)0.0);
            }
            if (this.mode == Mode.TRANSLATE) {
                if (this.lockFlag == 0) {
                    return Float2.of((double)this.getNumberStringValue(), (double)0.0);
                }
                return Float2.of((double)this.getNumberStringValue());
            }
        }
        Float2 delta = this.getMouseDelta();
        if (this.mode == Mode.SCALE) {
            return Float2.of((double)Math.pow(delta.length() / 25.0, this.shiftDown ? 0.1 : 1.0), (double)0.0);
        }
        if (this.mode == Mode.ROTATE) {
            return Float2.of((double)(Math.signum(delta.x) * Float2.mY_AXIS.angleTo(delta)), (double)0.0);
        }
        return delta.mul(0.1);
    }

    public String getDeltaString() {
        Float2 delta = this.getDelta();
        if (this.mode == Mode.ROTATE) {
            return Float3.toString((double)Math.toDegrees(delta.x)) + "\u00b0";
        }
        return "dx=" + Float3.toString((double)delta.x) + ", dy=" + Float3.toString((double)delta.y);
    }

    public boolean willWriteAbsolute() {
        if ((this.lockFlag & 0x20) == 32) {
            if (this.mode == Mode.ROTATE) {
                return true;
            }
            return (this.lockFlag & 1) + (this.lockFlag & 2) + (this.lockFlag & 4) != 0;
        }
        return false;
    }

    public static enum Mode {
        NONE,
        TRANSLATE,
        ROTATE,
        SCALE;

    }
}

