/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.gui.construction;

import de.ambertation.wunderlib.math.sdf.SDF;
import de.ambertation.wunderlib.math.sdf.interfaces.MaterialProvider;
import de.ambertation.wunderreich.gui.construction.RulerContainerMenu;
import de.ambertation.wunderreich.gui.construction.RulerDataContainer;
import de.ambertation.wunderreich.items.construction.BluePrint;
import de.ambertation.wunderreich.items.construction.BluePrintData;
import de.ambertation.wunderreich.network.ChangedSDFMessage;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class SDFSlot
extends class_1735 {
    private ChangedActiveGraphIndex onActiveGraphIndexChange;
    private ChangedContent onChangedContent;
    public final RulerContainerMenu menu;
    private final SDFSlot[] inputs;
    private SDFSlot parentSlot;

    public SDFSlot(RulerDataContainer container, RulerContainerMenu menu, int x, int y, SDFSlot inp0, SDFSlot inp1, int activeGraphIndex) {
        super((class_1263)container, 0, x, y);
        this.menu = menu;
        inp0.parentSlot = this;
        inp1.parentSlot = this;
        this.inputs = new SDFSlot[]{inp0, inp1};
    }

    public SDFSlot(class_1263 container, RulerContainerMenu menu, int x, int y) {
        super(container, 0, x, y);
        this.menu = menu;
        this.inputs = new SDFSlot[0];
    }

    public boolean isMaster() {
        return this.parentSlot == null;
    }

    public int inputSlotInMaster() {
        if (this.isMaster()) {
            return -1;
        }
        for (int i = 0; i < this.parentSlot.inputs.length; ++i) {
            if (this.parentSlot.inputs[i] != this) continue;
            return i;
        }
        return -1;
    }

    public RulerDataContainer container() {
        return (RulerDataContainer)this.field_7871;
    }

    public void setOnActiveGraphIndexChange(ChangedActiveGraphIndex callback) {
        this.onActiveGraphIndexChange = callback;
    }

    public void setOnChangedContent(ChangedContent onChangedContent) {
        this.onChangedContent = onChangedContent;
    }

    private void setActiveGraphIndex(int newIdx) {
        System.out.println(Integer.toHexString(this.menu.data.hashCode()) + "---- [CHG ACTIVE] ------------------");
        int oldIdx = this.menu.data.ACTIVE_SLOT.get();
        System.out.println(oldIdx + " -> " + newIdx);
        if (newIdx != oldIdx) {
            this.menu.data.ACTIVE_SLOT.set(newIdx);
            if (this.onActiveGraphIndexChange != null) {
                this.onActiveGraphIndexChange.didChange(newIdx);
            }
            System.out.println(this.menu.data.SDF_DATA.get() + ", act=" + this.method_34266() + " - " + this.menu.data.ACTIVE_SLOT.get());
        }
    }

    public int method_7675() {
        return 1;
    }

    public class_1799 method_7677() {
        return this.field_7871.method_5438(this.method_34266());
    }

    public void method_7673(@NotNull class_1799 itemStack) {
        System.out.println(Integer.toHexString(this.menu.data.hashCode()) + "---- [SET] ------------------");
        System.out.println(this.method_34266() + ": " + itemStack + ", master:" + this.isMaster());
        System.out.println(this.menu.data.SDF_DATA.get() + ", act=" + this.method_34266() + " - " + this.menu.data.ACTIVE_SLOT.get());
        int idx = this.container().setItemAndGet(this.method_34266(), itemStack);
        System.out.println(this.menu.data.SDF_DATA.get() + ", idx=" + idx + ", act=" + this.method_34266() + " - " + this.menu.data.ACTIVE_SLOT.get());
        if (this.isMaster()) {
            this.setActiveGraphIndex(idx);
            System.out.println(this.menu.data.SDF_DATA.get() + ", act=" + this.method_34266() + " - " + this.menu.data.ACTIVE_SLOT.get());
        }
        this.method_7668();
    }

    public class_1799 method_7671(int i) {
        System.out.println(Integer.toHexString(this.menu.data.hashCode()) + "---- [REMOVE] ------------------");
        System.out.println(i);
        System.out.println(this.menu.data.SDF_DATA.get() + ", act=" + this.method_34266() + " - " + this.menu.data.ACTIVE_SLOT.get());
        RulerDataContainer.RemoveData res = this.container().removeItemAndGet(this.method_34266());
        System.out.println(this.menu.data.SDF_DATA.get() + ", idx=" + res.graphIdx() + ", act=" + this.method_34266() + " - " + this.menu.data.ACTIVE_SLOT.get());
        if (this.isMaster()) {
            this.setActiveGraphIndex(res.graphIdx());
            System.out.println(this.menu.data.SDF_DATA.get() + ", act=" + this.method_34266() + " - " + this.menu.data.ACTIVE_SLOT.get());
        }
        this.method_7668();
        return res.stack();
    }

    public int method_34266() {
        SDF parentSDF;
        if (this.isMaster()) {
            return this.menu.data.ACTIVE_SLOT.get();
        }
        int inputSlot = this.inputSlotInMaster();
        if (inputSlot < (parentSDF = this.container().getSDF(this.parentSlot.method_34266())).getInputSlotCount()) {
            return parentSDF.getSlot(inputSlot).getGraphIndex();
        }
        return -1;
    }

    public boolean method_7682() {
        return this.method_34266() >= 0;
    }

    public void method_7668() {
        if (this.isMaster()) {
            super.method_7668();
            if (this.onChangedContent != null) {
                this.onChangedContent.didChange();
            }
        } else if (this.parentSlot != null) {
            this.parentSlot.method_7668();
        }
    }

    public boolean method_7680(class_1799 itemStack) {
        if (itemStack.method_7909() instanceof BluePrint) {
            BluePrintData data = BluePrintData.getBluePrintData(itemStack);
            return data != null && data.SDF_DATA.get() != null;
        }
        return false;
    }

    public boolean method_7674(class_1657 player) {
        BluePrintData data;
        class_1799 itemStack = this.method_7677();
        if (itemStack.method_7909() instanceof BluePrint && (data = BluePrintData.getBluePrintData(itemStack)) != null && data.SDF_DATA.get() != null) {
            return true;
        }
        return super.method_7674(player);
    }

    public boolean hasInput(int inputSlot) {
        if (inputSlot < 0 || inputSlot >= this.inputs.length) {
            return false;
        }
        SDF s = this.getActiveSdf();
        return s == null || inputSlot < s.getInputSlotCount();
    }

    public void selectInput(int inputSlot) {
        System.out.println(Integer.toHexString(this.menu.data.hashCode()) + "---- [SELECT INPUT] ------------------");
        System.out.println(inputSlot + "  " + this.hasInput(inputSlot) + ", act=" + this.method_34266());
        if (this.hasInput(inputSlot)) {
            this.setActiveGraphIndex(this.inputs[inputSlot].method_34266());
        }
    }

    public SDF getActiveSdf() {
        return this.container().getSDF(this.method_34266());
    }

    public void printDebugInfo() {
        System.out.println(Integer.toHexString(this.menu.data.hashCode()) + "---- [DEBUG] ------------------");
        System.out.println(this.menu.data.SDF_DATA.get() + ", act=" + this.menu.data.ACTIVE_SLOT.get());
        System.out.println("slot=" + this.method_34266() + ", master:" + this.isMaster());
        for (int i = 0; i < this.inputs.length; ++i) {
            System.out.println("slot=" + this.inputs[i].method_34266() + ", input:" + i);
        }
        System.out.println("--------------------------------");
    }

    public void selectParent() {
        System.out.println(Integer.toHexString(this.menu.data.hashCode()) + "---- [SELECT PARENT] ------------------");
        System.out.println("act=" + this.method_34266());
        SDF s = this.getActiveSdf();
        if (s != null && s.getParent() != null) {
            this.setActiveGraphIndex(s.getParent().getGraphIndex());
        }
    }

    public int selectNextMaterialOnClient() {
        SDF s = this.getActiveSdf();
        if (s != null && s instanceof MaterialProvider) {
            MaterialProvider mp = (MaterialProvider)s;
            int idx = (mp.getMaterialIndex() + 1) % 8;
            mp.setMaterialIndex(idx);
            ChangedSDFMessage.INSTANCE.sendMaterial(this.menu, idx);
            return idx;
        }
        return -1;
    }

    public int getMaterialIndex() {
        SDF s = this.getActiveSdf();
        if (s != null && s instanceof MaterialProvider) {
            MaterialProvider mp = (MaterialProvider)s;
            return mp.getMaterialIndex();
        }
        return -1;
    }

    public boolean hasMaterial() {
        SDF s = this.getActiveSdf();
        return s != null && s instanceof MaterialProvider;
    }

    @FunctionalInterface
    static interface ChangedActiveGraphIndex {
        public void didChange(int var1);
    }

    @FunctionalInterface
    static interface ChangedContent {
        public void didChange();
    }
}

