/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.steamEngine;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.simibubi.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.simibubi.create.content.kinetics.steamEngine.SteamEngineBlockEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_3532;

public class SteamEngineInstance
extends BlockEntityInstance<SteamEngineBlockEntity>
implements DynamicInstance {
    protected final ModelData piston;
    protected final ModelData linkage;
    protected final ModelData connector;

    public SteamEngineInstance(MaterialManager materialManager, SteamEngineBlockEntity blockEntity) {
        super(materialManager, (class_2586)blockEntity);
        this.piston = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(AllPartialModels.ENGINE_PISTON, this.blockState).createInstance();
        this.linkage = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(AllPartialModels.ENGINE_LINKAGE, this.blockState).createInstance();
        this.connector = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(AllPartialModels.ENGINE_CONNECTOR, this.blockState).createInstance();
    }

    public void beginFrame() {
        Float angle = ((SteamEngineBlockEntity)this.blockEntity).getTargetAngle();
        if (angle == null) {
            this.piston.setEmptyTransform();
            this.linkage.setEmptyTransform();
            this.connector.setEmptyTransform();
            return;
        }
        class_2350 facing = SteamEngineBlock.getFacing(this.blockState);
        class_2350.class_2351 facingAxis = facing.method_10166();
        class_2350.class_2351 axis = class_2350.class_2351.field_11052;
        PoweredShaftBlockEntity shaft = ((SteamEngineBlockEntity)this.blockEntity).getShaft();
        if (shaft != null) {
            axis = KineticBlockEntityRenderer.getRotationAxisOf(shaft);
        }
        boolean roll90 = facingAxis.method_10179() && axis == class_2350.class_2351.field_11052 || facingAxis.method_10178() && axis == class_2350.class_2351.field_11051;
        float sine = class_3532.method_15374((float)angle.floatValue());
        float sine2 = class_3532.method_15374((float)(angle.floatValue() - 1.5707964f));
        float piston = (1.0f - sine) / 4.0f * 24.0f / 16.0f;
        this.transformed(this.piston, facing, roll90).translate(0.0, (double)piston, 0.0);
        ((ModelData)((ModelData)((ModelData)this.transformed(this.linkage, facing, roll90).centre()).translate(0.0, 1.0, 0.0).unCentre()).translate(0.0, (double)piston, 0.0).translate(0.0, 0.25, 0.5).rotateX((double)(sine2 * 23.0f))).translate(0.0, -0.25, -0.5);
        ((ModelData)((ModelData)this.transformed(this.connector, facing, roll90).translate(0.0, 2.0, 0.0).centre()).rotateXRadians((double)(-angle.floatValue() + 1.5707964f))).unCentre();
    }

    protected ModelData transformed(ModelData modelData, class_2350 facing, boolean roll90) {
        return (ModelData)((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)modelData.loadIdentity().translate((class_2382)this.getInstancePosition())).centre()).rotateY((double)AngleHelper.horizontalAngle(facing))).rotateX((double)(AngleHelper.verticalAngle(facing) + 90.0f))).rotateY(roll90 ? -90.0 : 0.0)).unCentre();
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.piston, this.linkage, this.connector});
    }

    protected void remove() {
        this.piston.delete();
        this.linkage.delete();
        this.connector.delete();
    }
}

