/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.fan.processing;

import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class FanProcessingTypeRegistry {
    private static final Map<class_2960, FanProcessingType> TYPES = new Object2ReferenceOpenHashMap();
    private static final Map<FanProcessingType, class_2960> IDS = new Reference2ObjectOpenHashMap();
    private static final List<FanProcessingType> SORTED_TYPES = new ReferenceArrayList();
    private static final List<FanProcessingType> SORTED_TYPES_VIEW = Collections.unmodifiableList(SORTED_TYPES);

    public static void register(class_2960 id, FanProcessingType type) {
        if (TYPES.put(id, type) != null) {
            throw new IllegalArgumentException("Tried to override FanProcessingType registration for id '" + id + "'. This is not supported!");
        }
        class_2960 prevId = IDS.put(type, id);
        if (prevId != null) {
            throw new IllegalArgumentException("Tried to register same FanProcessingType instance for multiple ids '" + prevId + "' and '" + id + "'. This is not supported!");
        }
        FanProcessingTypeRegistry.insertSortedType(type, id);
    }

    private static void insertSortedType(FanProcessingType type, class_2960 id) {
        int index = Collections.binarySearch(SORTED_TYPES, type, (type1, type2) -> type2.getPriority() - type1.getPriority());
        if (index >= 0) {
            throw new IllegalStateException();
        }
        SORTED_TYPES.add(-index - 1, type);
    }

    @Nullable
    public static FanProcessingType getType(class_2960 id) {
        return TYPES.get(id);
    }

    public static FanProcessingType getTypeOrThrow(class_2960 id) {
        FanProcessingType type = FanProcessingTypeRegistry.getType(id);
        if (type == null) {
            throw new IllegalArgumentException("Could not get FanProcessingType for id '" + id + "'!");
        }
        return type;
    }

    @Nullable
    public static class_2960 getId(FanProcessingType type) {
        return IDS.get(type);
    }

    public static class_2960 getIdOrThrow(FanProcessingType type) {
        class_2960 id = FanProcessingTypeRegistry.getId(type);
        if (id == null) {
            throw new IllegalArgumentException("Could not get id for FanProcessingType " + type + "!");
        }
        return id;
    }

    public static List<FanProcessingType> getSortedTypesView() {
        return SORTED_TYPES_VIEW;
    }
}

