/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.pulley;

import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.instancing.ConditionalInstance;
import com.jozufozu.flywheel.core.instancing.GroupInstance;
import com.jozufozu.flywheel.core.instancing.SelectInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.jozufozu.flywheel.light.LightPacking;
import com.jozufozu.flywheel.light.LightVolume;
import com.jozufozu.flywheel.light.TickingLightListener;
import com.jozufozu.flywheel.util.box.GridAlignedBB;
import com.jozufozu.flywheel.util.box.ImmutableBox;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftInstance;
import net.minecraft.class_1920;
import net.minecraft.class_1944;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_7833;
import org.joml.Vector3f;

public abstract class AbstractPulleyInstance<T extends KineticBlockEntity>
extends ShaftInstance<T>
implements DynamicInstance,
TickingLightListener {
    final OrientedData coil;
    final SelectInstance<OrientedData> magnet;
    final GroupInstance<OrientedData> rope;
    final ConditionalInstance<OrientedData> halfRope;
    protected float offset;
    protected final class_2350 rotatingAbout;
    protected final class_7833 rotationAxis;
    private final GridAlignedBB volume = new GridAlignedBB();
    private final LightVolume light;

    public AbstractPulleyInstance(MaterialManager dispatcher, T blockEntity) {
        super(dispatcher, blockEntity);
        this.rotatingAbout = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)this.axis);
        this.rotationAxis = class_7833.method_46356((Vector3f)this.rotatingAbout.method_23955());
        this.coil = ((OrientedData)this.getCoilModel().createInstance()).setPosition(this.getInstancePosition());
        this.magnet = new SelectInstance(this::getMagnetModelIndex);
        this.magnet.addModel(this.getMagnetModel()).addModel(this.getHalfMagnetModel());
        this.rope = new GroupInstance(this.getRopeModel());
        this.halfRope = new ConditionalInstance(this.getHalfRopeModel()).withCondition(this::shouldRenderHalfRope);
        this.updateOffset();
        this.updateVolume();
        this.light = new LightVolume((class_1920)this.world, (ImmutableBox)this.volume);
        this.light.initialize();
    }

    public void beginFrame() {
        this.updateOffset();
        this.coil.setRotation(this.rotationAxis.rotationDegrees(this.offset * 180.0f));
        int neededRopeCount = this.getNeededRopeCount();
        this.rope.resize(neededRopeCount);
        this.magnet.update().get().ifPresent(data -> {
            int i = Math.max(0, class_3532.method_15375((float)this.offset));
            short packed = this.light.getPackedLight(this.pos.method_10263(), this.pos.method_10264() - i, this.pos.method_10260());
            data.setPosition(this.getInstancePosition()).nudge(0.0f, -this.offset, 0.0f).setBlockLight(LightPacking.getBlock((short)packed)).setSkyLight(LightPacking.getSky((short)packed));
        });
        this.halfRope.update().get().ifPresent(rope1 -> {
            float f = this.offset % 1.0f;
            float halfRopeNudge = f > 0.75f ? f - 1.0f : f;
            short packed = this.light.getPackedLight(this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260());
            rope1.setPosition(this.getInstancePosition()).nudge(0.0f, -halfRopeNudge, 0.0f).setBlockLight(LightPacking.getBlock((short)packed)).setSkyLight(LightPacking.getSky((short)packed));
        });
        if (this.isRunning()) {
            int size = this.rope.size();
            int bottomY = this.pos.method_10264() - size;
            for (int i = 0; i < size; ++i) {
                short packed = this.light.getPackedLight(this.pos.method_10263(), bottomY + i, this.pos.method_10260());
                ((OrientedData)this.rope.get(i)).setPosition(this.getInstancePosition()).nudge(0.0f, -this.offset + (float)i + 1.0f, 0.0f).setBlockLight(LightPacking.getBlock((short)packed)).setSkyLight(LightPacking.getSky((short)packed));
            }
        } else {
            this.rope.clear();
        }
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.coil});
    }

    @Override
    public void remove() {
        super.remove();
        this.coil.delete();
        this.magnet.delete();
        this.rope.clear();
        this.halfRope.delete();
        this.light.delete();
    }

    protected abstract Instancer<OrientedData> getRopeModel();

    protected abstract Instancer<OrientedData> getMagnetModel();

    protected abstract Instancer<OrientedData> getHalfMagnetModel();

    protected abstract Instancer<OrientedData> getCoilModel();

    protected abstract Instancer<OrientedData> getHalfRopeModel();

    protected abstract float getOffset();

    protected abstract boolean isRunning();

    public boolean tickLightListener() {
        if (this.updateVolume()) {
            this.light.move((ImmutableBox)this.volume);
            return true;
        }
        return false;
    }

    private boolean updateVolume() {
        int length = class_3532.method_15386((float)this.offset) + 2;
        if (this.volume.sizeY() < length) {
            this.volume.assign(this.pos.method_10087(length), this.pos).fixMinMax();
            return true;
        }
        return false;
    }

    private void updateOffset() {
        this.offset = this.getOffset();
    }

    private int getNeededRopeCount() {
        return Math.max(0, class_3532.method_15386((float)(this.offset - 1.25f)));
    }

    private boolean shouldRenderHalfRope() {
        float f = this.offset % 1.0f;
        return this.offset > 0.75f && (f < 0.25f || f > 0.75f);
    }

    private int getMagnetModelIndex() {
        if (this.isRunning() || this.offset == 0.0f) {
            return this.offset > 0.25f ? 0 : 1;
        }
        return -1;
    }

    public boolean decreaseFramerateWithDistance() {
        return false;
    }

    public ImmutableBox getVolume() {
        return this.volume;
    }

    public void onLightUpdate(class_1944 type, ImmutableBox changed) {
        super.onLightUpdate(type, changed);
        this.light.onLightUpdate(type, changed);
    }
}

