/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.apache.commons.lang3.mutable.MutableInt;

@ParametersAreNonnullByDefault
public class BasinCategory
extends CreateRecipeCategory<BasinRecipe> {
    private final boolean needsHeating;

    public BasinCategory(CreateRecipeCategory.Info<BasinRecipe> info, boolean needsHeating) {
        super(info);
        this.needsHeating = needsHeating;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BasinRecipe recipe, IFocusGroup focuses) {
        List<Pair<class_1856, MutableInt>> condensedIngredients = ItemHelper.condenseIngredients(recipe.method_8117());
        int size = condensedIngredients.size() + recipe.getFluidIngredients().size();
        int xOffset = size < 3 ? (3 - size) * 19 / 2 : 0;
        int i = 0;
        for (Pair<class_1856, MutableInt> pair : condensedIngredients) {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            for (class_1799 itemStack : pair.getFirst().method_8105()) {
                class_1799 copy = itemStack.method_7972();
                copy.method_7939(pair.getSecond().getValue().intValue());
                stacks.add(copy);
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 17 + xOffset + i % 3 * 19, 51 - i / 3 * 19).setBackground(BasinCategory.getRenderedSlot(), -1, -1).addItemStacks(stacks);
            ++i;
        }
        for (FluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 17 + xOffset + i % 3 * 19, 51 - i / 3 * 19).setBackground(BasinCategory.getRenderedSlot(), -1, -1).addIngredients((IIngredientType)FabricTypes.FLUID_STACK, BasinCategory.toJei(BasinCategory.withImprovedVisibility(fluidIngredient.getMatchingFluidStacks())))).addTooltipCallback(BasinCategory.addFluidTooltip(fluidIngredient.getRequiredAmount()));
            ++i;
        }
        size = recipe.getRollableResults().size() + recipe.getFluidResults().size();
        i = 0;
        for (ProcessingOutput result : recipe.getRollableResults()) {
            int xPosition = 142 - (size % 2 != 0 && i == size - 1 ? 0 : (i % 2 == 0 ? 10 : -9));
            int yPosition = -19 * (i / 2) + 51;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, xPosition, yPosition).setBackground(BasinCategory.getRenderedSlot(result), -1, -1).addItemStack(result.getStack())).addTooltipCallback(BasinCategory.addStochasticTooltip(result));
            ++i;
        }
        for (FluidStack fluidResult : recipe.getFluidResults()) {
            int xPosition = 142 - (size % 2 != 0 && i == size - 1 ? 0 : (i % 2 == 0 ? 10 : -9));
            int yPosition = -19 * (i / 2) + 51;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, xPosition, yPosition).setBackground(BasinCategory.getRenderedSlot(), -1, -1).addIngredient((IIngredientType)FabricTypes.FLUID_STACK, (Object)BasinCategory.toJei(BasinCategory.withImprovedVisibility(fluidResult)))).addTooltipCallback(BasinCategory.addFluidTooltip(fluidResult.getAmount()));
            ++i;
        }
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE)) {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 134, 81).addItemStack(AllBlocks.BLAZE_BURNER.asStack());
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED)) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 153, 81).addItemStack(AllItems.BLAZE_CAKE.asStack());
        }
    }

    public void draw(BasinRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        boolean noHeat = requiredHeat == HeatCondition.NONE;
        int vRows = (1 + recipe.getFluidResults().size() + recipe.getRollableResults().size()) / 2;
        if (vRows <= 2) {
            AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 136, -19 * (vRows - 1) + 32);
        }
        AllGuiTextures shadow = noHeat ? AllGuiTextures.JEI_SHADOW : AllGuiTextures.JEI_LIGHT;
        shadow.render(graphics, 81, 58 + (noHeat ? 10 : 30));
        if (!this.needsHeating) {
            return;
        }
        AllGuiTextures heatBar = noHeat ? AllGuiTextures.JEI_NO_HEAT_BAR : AllGuiTextures.JEI_HEAT_BAR;
        heatBar.render(graphics, 4, 80);
        graphics.method_51439(class_310.method_1551().field_1772, (class_2561)Lang.translateDirect(requiredHeat.getTranslationKey(), new Object[0]), 9, 86, requiredHeat.getColor(), false);
    }
}

