/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.worldgen.features;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.worldgen.feature_configs.HugeConkFungusFeatureConfig;
import java.util.HashSet;
import java.util.function.BiConsumer;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2429;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3746;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class HugeConkFungusFeature
extends class_3031<HugeConkFungusFeatureConfig> {
    public HugeConkFungusFeature(Codec<HugeConkFungusFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<HugeConkFungusFeatureConfig> context) {
        class_5281 level = context.method_33652();
        class_5819 random = level.method_8409();
        class_2338 blockPos = context.method_33655();
        HugeConkFungusFeatureConfig config = (HugeConkFungusFeatureConfig)context.method_33656();
        HashSet set = Sets.newHashSet();
        BiConsumer<class_2338, class_2680> blockSetter = (blockPosx, blockState) -> {
            set.add(blockPosx.method_10062());
            level.method_8652(blockPosx, blockState, 19);
        };
        BiConsumer<class_2338, class_2680> blockSetter2 = (blockPosx, blockState) -> {
            set.add(blockPosx.method_10062());
            level.method_8652(blockPosx, (class_2680)((class_2680)((class_2680)((class_2680)blockState.method_11657((class_2769)class_2429.field_11332, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2429.field_11331, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2429.field_11335, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2429.field_11328, (Comparable)Boolean.valueOf(false)), 19);
        };
        int radius = random.method_43048(2) + config.radius;
        int i = 0;
        if (config.largeChance > 0) {
            i = random.method_43051(0, config.largeChance);
        }
        boolean large = i == 1;
        this.placeLeavesRow((class_3746)level, blockSetter2, random, config, blockPos, radius - 1, 0, large);
        this.placeLeavesRow((class_3746)level, blockSetter, random, config, blockPos, radius, -1, large);
        return false;
    }

    protected void placeLeavesRow(class_3746 level, BiConsumer<class_2338, class_2680> blockSetter, class_5819 random, HugeConkFungusFeatureConfig config, class_2338 pos, int range, int yOffset, boolean large) {
        int i = large ? 1 : 0;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int j = -range; j <= range + i; ++j) {
            for (int k = -range; k <= range + i; ++k) {
                if (this.shouldSkipLocationSignedOg(random, j, yOffset, k, range, large)) continue;
                mutableBlockPos.method_25504((class_2382)pos, j, yOffset, k);
                HugeConkFungusFeature.tryPlaceLeaf(level, blockSetter, random, config, (class_2338)mutableBlockPos);
            }
        }
    }

    protected static void tryPlaceLeaf(class_3746 level, BiConsumer<class_2338, class_2680> blockSetter, class_5819 random, HugeConkFungusFeatureConfig config, class_2338 pos) {
        if (HugeConkFungusFeature.validTreePos(level, pos)) {
            class_2680 blockState = config.foliageProvider.method_23455(random, pos);
            if (blockState.method_28498((class_2769)class_2741.field_12508)) {
                blockState = (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(level.method_35237(pos, fluidState -> fluidState.method_33659((class_3611)class_3612.field_15910))));
            }
            blockSetter.accept(pos, blockState);
        }
    }

    public static boolean isBlockWater(class_3746 level, class_2338 pos) {
        return level.method_16358(pos, blockState -> blockState.method_27852(class_2246.field_10382));
    }

    public static boolean isAirOrLeaves(class_3746 level, class_2338 pos) {
        return level.method_16358(pos, blockState -> blockState.method_26215() || blockState.method_26164(class_3481.field_15503) || blockState.method_27852(ModBlocks.CONK_FUNGUS.get()));
    }

    private static boolean isReplaceablePlant(class_3746 level, class_2338 pos) {
        return level.method_16358(pos, class_4970.class_4971::method_45474);
    }

    public static boolean validTreePos(class_3746 level, class_2338 pos) {
        return HugeConkFungusFeature.isAirOrLeaves(level, pos) || HugeConkFungusFeature.isReplaceablePlant(level, pos) || HugeConkFungusFeature.isBlockWater(level, pos);
    }

    protected boolean shouldSkipLocation(class_5819 random, int localX, int localY, int localZ, int range, boolean large) {
        return localX == range && localZ == range && range > 0;
    }

    protected boolean shouldSkipLocationSignedOg(class_5819 random, int localX, int localY, int localZ, int range, boolean large) {
        int j;
        int i;
        if (large) {
            i = Math.min(Math.abs(localX), Math.abs(localX - 1));
            j = Math.min(Math.abs(localZ), Math.abs(localZ - 1));
        } else {
            i = Math.abs(localX);
            j = Math.abs(localZ);
        }
        return this.shouldSkipLocation(random, i, localY, j, range, large);
    }
}

