/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.worldgen.feature_configs.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.spelunkery.worldgen.feature_configs.util.FastNoiseLite;
import net.minecraft.class_2338;

public class StonePattern {
    private FastNoiseLite noise;
    private final int noiseSeed;
    private final float primaryMin;
    private final float primaryMax;
    private final float secondaryMin;
    private final float secondaryMax;
    private final float verticalScale;
    public static final Codec<StonePattern> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("noise_seed").forGetter(stonePattern -> stonePattern.noiseSeed), (App)Codec.floatRange((float)-1.0f, (float)1.0f).fieldOf("primary_min").orElse((Object)Float.valueOf(0.0f)).forGetter(stonePattern -> Float.valueOf(stonePattern.primaryMin)), (App)Codec.floatRange((float)-1.0f, (float)1.0f).fieldOf("primary_max").orElse((Object)Float.valueOf(0.0f)).forGetter(stonePattern -> Float.valueOf(stonePattern.primaryMax)), (App)Codec.floatRange((float)-1.0f, (float)1.0f).fieldOf("secondary_min").orElse((Object)Float.valueOf(0.0f)).forGetter(stonePattern -> Float.valueOf(stonePattern.secondaryMin)), (App)Codec.floatRange((float)-1.0f, (float)1.0f).fieldOf("secondary_max").orElse((Object)Float.valueOf(0.0f)).forGetter(stonePattern -> Float.valueOf(stonePattern.secondaryMax)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("vertical_scale").orElse((Object)Float.valueOf(0.0f)).forGetter(stonePattern -> Float.valueOf(stonePattern.verticalScale))).apply((Applicative)instance, StonePattern::new));

    private StonePattern(int noiseSeed, float primaryMin, float primaryMax, float secondaryMin, float secondaryMax, float verticalScale) {
        FastNoiseLite noise = new FastNoiseLite(noiseSeed);
        noise.SetDomainWarpType(FastNoiseLite.DomainWarpType.OpenSimplex2);
        noise.SetRotationType3D(FastNoiseLite.RotationType3D.ImproveXZPlanes);
        noise.SetFrequency(0.03f);
        noise.SetDomainWarpAmp(1.5f);
        noise.SetFractalOctaves(1);
        this.noise = noise;
        this.noiseSeed = noiseSeed;
        this.primaryMin = primaryMin;
        this.primaryMax = primaryMax;
        this.secondaryMin = secondaryMin;
        this.secondaryMax = secondaryMax;
        this.verticalScale = verticalScale;
    }

    public void setSeed(int seed) {
        this.noise.SetSeed(seed);
    }

    public boolean shouldPlacePrimaryStone(class_2338 blockPos) {
        float x = blockPos.method_10263();
        float y = blockPos.method_10264();
        float z = blockPos.method_10260();
        float value = this.noise.GetNoise(x, y /= this.verticalScale, z);
        return value < this.primaryMax && value > this.primaryMin;
    }

    public boolean shouldPlaceSecondaryStone(class_2338 blockPos) {
        float x = blockPos.method_10263();
        float y = blockPos.method_10264();
        float z = blockPos.method_10260();
        float value = this.noise.GetNoise(x, y /= this.verticalScale, z);
        return value < this.secondaryMax && value > this.secondaryMin;
    }
}

