/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.items;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.ordana.spelunkery.configs.ClientConfigs;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.reg.ModGameEvents;
import com.ordana.spelunkery.utils.TranslationUtils;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3675;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class MagneticCompassItem
extends class_1792 {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String TAG_LODESTONE_POS = "LodestonePos";
    public static final String TAG_LODESTONE_DIMENSION = "LodestoneDimension";
    public static final String TAG_LODESTONE_TRACKED = "LodestoneTracked";
    private int tickCounter = 0;

    public MagneticCompassItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tooltip, @NotNull class_1836 context) {
        if (ClientConfigs.ENABLE_TOOLTIPS.get().booleanValue()) {
            class_2487 compoundTag = stack.method_7948();
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.spelunkery.player_pos", (Object[])new Object[]{this.getPlayerX(stack), this.getPlayerZ(stack)}).method_10862(class_2583.field_24360.method_27706(class_124.field_1077)));
            if (compoundTag.method_10545("magnetitePos")) {
                class_2338 blockPos = class_2512.method_10691((class_2487)compoundTag.method_10562("magnetitePos"));
                tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.spelunkery.magnetite_pos", (Object[])new Object[]{blockPos.method_10263(), blockPos.method_10260()}).method_10862(class_2583.field_24360.method_27706(class_124.field_1077)));
            }
            if (class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)class_310.method_1551().field_1690.field_1832.field_1655.method_1444())) {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.spelunkery.magnetic_compass_2").method_10862(class_2583.field_24360.method_27706(class_124.field_1080)));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.spelunkery.magnetic_compass_3").method_10862(class_2583.field_24360.method_27706(class_124.field_1080)));
                tooltip.add((class_2561)TranslationUtils.MAGNETIC_COMPASS_4.component());
            } else {
                tooltip.add((class_2561)TranslationUtils.CROUCH.component());
            }
        }
    }

    public void setPlayerX(class_1799 stack, int amount) {
        stack.method_7948().method_10569("ex", amount);
    }

    public int getPlayerX(class_1799 stack) {
        return stack.method_7948().method_10550("ex");
    }

    public void setPlayerZ(class_1799 stack, int amount) {
        stack.method_7948().method_10569("zed", amount);
    }

    public int getPlayerZ(class_1799 stack) {
        return stack.method_7948().method_10550("zed");
    }

    @PlatformOnly(value={"fabric"})
    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 originalStack, class_1799 updatedStack) {
        return false;
    }

    public class_1271<class_1799> method_7836(@NotNull class_1937 level, @NotNull class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_2487 compoundTag = stack.method_7948();
        if (compoundTag.method_10545("magnetitePos")) {
            class_2338 blockPos = class_2512.method_10691((class_2487)compoundTag.method_10562("magnetitePos"));
            player.method_7353((class_2561)class_2561.method_43469((String)"tooltip.spelunkery.magnetite_pos", (Object[])new Object[]{blockPos.method_10263(), blockPos.method_10260()}).method_10862(class_2583.field_24360.method_27706(class_124.field_1077)), true);
        } else {
            player.method_7353((class_2561)class_2561.method_43469((String)"tooltip.spelunkery.player_pos", (Object[])new Object[]{this.getPlayerX(stack), this.getPlayerZ(stack)}).method_10862(class_2583.field_24360.method_27706(class_124.field_1077)), true);
        }
        if (player.method_21823()) {
            compoundTag.method_10551("magnetitePos");
            level.method_33596((class_1297)player, ModGameEvents.COMPASS_PING_EVENT.get(), player.method_24515());
        }
        return new class_1271(class_1269.field_5812, (Object)stack);
    }

    private static Optional<class_5321<class_1937>> getDimension(class_2487 compoundTag) {
        return class_1937.field_25178.parse((DynamicOps)class_2509.field_11560, (Object)compoundTag.method_10580("magnetiteDimension")).result();
    }

    public int setTickCounter(int tick) {
        this.tickCounter = tick;
        return this.tickCounter;
    }

    public void method_7888(@NotNull class_1799 stack, class_1937 level, @NotNull class_1297 entity, int slotId, boolean isSelected) {
        if (!level.method_8608()) {
            class_2338 blockPos;
            Optional<class_5321<class_1937>> optional;
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                this.setPlayerX(stack, player.method_31477());
                this.setPlayerZ(stack, player.method_31479());
            }
            class_2487 compoundTag = stack.method_7948();
            ++this.tickCounter;
            if (this.tickCounter == 100) {
                if (!compoundTag.method_10545("magnetitePos")) {
                    level.method_33596(entity, ModGameEvents.COMPASS_PING_EVENT.get(), entity.method_24515());
                }
                this.setTickCounter(0);
            }
            if ((optional = MagneticCompassItem.getDimension(compoundTag)).isPresent() && optional.get() == level.method_27983() && compoundTag.method_10545("magnetitePos") && (!level.method_24794(blockPos = class_2512.method_10691((class_2487)compoundTag.method_10562("magnetitePos"))) || !level.method_8320(blockPos).method_27852(ModBlocks.RAW_MAGNETITE_BLOCK.get()))) {
                compoundTag.method_10551("magnetitePos");
                level.method_33596(entity, ModGameEvents.COMPASS_PING_EVENT.get(), entity.method_24515());
            }
        }
    }

    public boolean method_7886(@NotNull class_1799 stack) {
        return MagneticCompassItem.isMagnetiteNearby(stack) || super.method_7886(stack);
    }

    public static void addMagnetiteTags(class_5321<class_1937> lodestoneDimension, class_2338 pos, class_2487 compoundTag) {
        if (!compoundTag.method_10545("magnetitePos")) {
            compoundTag.method_10566("magnetitePos", (class_2520)class_2512.method_10692((class_2338)pos));
        }
        DataResult var10000 = class_1937.field_25178.encodeStart((DynamicOps)class_2509.field_11560, lodestoneDimension);
        Logger var10001 = LOGGER;
        Objects.requireNonNull(var10001);
        var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(tag -> compoundTag.method_10566("magnetiteDimension", tag));
    }

    public static boolean isMagnetiteNearby(class_1799 stack) {
        class_2487 compoundTag = stack.method_7969();
        return compoundTag != null && compoundTag.method_10545("magnetitePos");
    }

    @Nullable
    public static class_4208 getNorthPosition(class_1937 level) {
        return level.method_8597().comp_645() ? class_4208.method_19443((class_5321)level.method_27983(), (class_2338)new class_2338(0, 0, -10000000)) : null;
    }

    @Nullable
    public static class_4208 getMagnetitePos(class_2487 compoundTag) {
        Optional<class_5321<class_1937>> optional;
        boolean bl = compoundTag.method_10545("magnetitePos");
        boolean bl2 = compoundTag.method_10545("magnetiteDimension");
        if (bl && bl2 && (optional = MagneticCompassItem.getDimension(compoundTag)).isPresent()) {
            class_2338 blockPos = class_2512.method_10691((class_2487)compoundTag.method_10562("magnetitePos"));
            return class_4208.method_19443(optional.get(), (class_2338)blockPos);
        }
        return null;
    }
}

