/*
 * Decompiled with CFR 0.152.
 */
package atonkish.reinfshulker.recipe;

import atonkish.reinfshulker.recipe.ModRecipeSerializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

public class ReinforcedShulkerBoxCraftingRecipe
extends class_1869 {
    public ReinforcedShulkerBoxCraftingRecipe(class_2960 id, String group, class_7710 category, int width, int height, class_2371<class_1856> input, class_1799 output, boolean showNotification) {
        super(id, group, category, width, height, input, output, showNotification);
    }

    public ReinforcedShulkerBoxCraftingRecipe(class_2960 id, String group, class_7710 category, int width, int height, class_2371<class_1856> input, class_1799 output) {
        this(id, group, category, width, height, input, output, true);
    }

    public class_1865<?> method_8119() {
        return ModRecipeSerializer.REINFORCED_SHULKER_BOX;
    }

    public class_1799 method_17727(class_8566 recipeInputInventory, class_5455 dynamicRegistryManager) {
        class_1799 itemStack = this.method_8110(dynamicRegistryManager).method_7972();
        class_2487 nbtCompound = recipeInputInventory.method_5438(4).method_7969();
        if (nbtCompound != null) {
            itemStack.method_7980(nbtCompound.method_10553());
        }
        return itemStack;
    }

    static class_2371<class_1856> createPatternMatrix(String[] pattern, Map<String, class_1856> symbols, int width, int height) {
        class_2371 defaultedList = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
        HashSet set = Sets.newHashSet(symbols.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String string = pattern[i].substring(j, j + 1);
                class_1856 ingredient = symbols.get(string);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                set.remove(string);
                defaultedList.set(j + width * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return defaultedList;
    }

    @VisibleForTesting
    static String[] removePadding(String ... pattern) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int m = 0; m < pattern.length; ++m) {
            String string = pattern[m];
            i = Math.min(i, ReinforcedShulkerBoxCraftingRecipe.findFirstSymbol(string));
            int n = ReinforcedShulkerBoxCraftingRecipe.findLastSymbol(string);
            j = Math.max(j, n);
            if (n < 0) {
                if (k == m) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (pattern.length == l) {
            return new String[0];
        }
        String[] strings = new String[pattern.length - l - k];
        for (int o = 0; o < strings.length; ++o) {
            strings[o] = pattern[o + k].substring(i, j + 1);
        }
        return strings;
    }

    private static int findFirstSymbol(String line) {
        int i;
        for (i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int findLastSymbol(String pattern) {
        int i;
        for (i = pattern.length() - 1; i >= 0 && pattern.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static String[] getPattern(JsonArray json) {
        String[] strings = new String[json.size()];
        if (strings.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (strings.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = class_3518.method_15287((JsonElement)json.get(i), (String)("pattern[" + i + "]"));
            if (string.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && strings[0].length() != string.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            strings[i] = string;
        }
        return strings;
    }

    static Map<String, class_1856> readSymbols(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), class_1856.method_52177((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", class_1856.field_9017);
        return map;
    }

    public static class Serializer
    implements class_1865<ReinforcedShulkerBoxCraftingRecipe> {
        public ReinforcedShulkerBoxCraftingRecipe read(class_2960 identifier, JsonObject jsonObject) {
            String string = class_3518.method_15253((JsonObject)jsonObject, (String)"group", (String)"");
            class_7710 craftingRecipeCategory = (class_7710)class_7710.field_40252.method_47920(class_3518.method_15253((JsonObject)jsonObject, (String)"category", null), (Enum)class_7710.field_40251);
            Map<String, class_1856> map = ReinforcedShulkerBoxCraftingRecipe.readSymbols(class_3518.method_15296((JsonObject)jsonObject, (String)"key"));
            String[] strings = ReinforcedShulkerBoxCraftingRecipe.removePadding(ReinforcedShulkerBoxCraftingRecipe.getPattern(class_3518.method_15261((JsonObject)jsonObject, (String)"pattern")));
            int i = strings[0].length();
            int j = strings.length;
            class_2371<class_1856> defaultedList = ReinforcedShulkerBoxCraftingRecipe.createPatternMatrix(strings, map, i, j);
            class_1799 itemStack = ReinforcedShulkerBoxCraftingRecipe.method_35228((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
            boolean bl = class_3518.method_15258((JsonObject)jsonObject, (String)"show_notification", (boolean)true);
            return new ReinforcedShulkerBoxCraftingRecipe(identifier, string, craftingRecipeCategory, i, j, defaultedList, itemStack, bl);
        }

        public ReinforcedShulkerBoxCraftingRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
            int i = packetByteBuf.method_10816();
            int j = packetByteBuf.method_10816();
            String string = packetByteBuf.method_19772();
            class_7710 craftingRecipeCategory = (class_7710)packetByteBuf.method_10818(class_7710.class);
            class_2371 defaultedList = class_2371.method_10213((int)(i * j), (Object)class_1856.field_9017);
            for (int k = 0; k < defaultedList.size(); ++k) {
                defaultedList.set(k, (Object)class_1856.method_8086((class_2540)packetByteBuf));
            }
            class_1799 itemStack = packetByteBuf.method_10819();
            boolean bl = packetByteBuf.readBoolean();
            return new ReinforcedShulkerBoxCraftingRecipe(identifier, string, craftingRecipeCategory, i, j, (class_2371<class_1856>)defaultedList, itemStack, bl);
        }

        public void write(class_2540 packetByteBuf, ReinforcedShulkerBoxCraftingRecipe recipe) {
            packetByteBuf.method_10804(recipe.method_8150());
            packetByteBuf.method_10804(recipe.method_8158());
            packetByteBuf.method_10814(recipe.method_8112());
            packetByteBuf.method_10817((Enum)recipe.method_45441());
            for (class_1856 ingredient : recipe.method_8117()) {
                ingredient.method_8088(packetByteBuf);
            }
            packetByteBuf.method_10793(recipe.method_8110(null));
            packetByteBuf.writeBoolean(recipe.method_49188());
        }
    }
}

