/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.copper.block_entity;

import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.lunade.copper.block_entity.AbstractSimpleCopperBlockEntity;
import net.lunade.copper.block_entity.CopperPipeEntity;
import net.lunade.copper.blocks.CopperFitting;
import net.lunade.copper.config.SimpleCopperPipesConfig;
import net.lunade.copper.registry.RegisterCopperBlockEntities;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class CopperFittingEntity
extends AbstractSimpleCopperBlockEntity {
    private static final int MAX_TRANSFER_AMOUNT = 1;
    public int transferCooldown;

    public CopperFittingEntity(class_2338 blockPos, class_2680 blockState) {
        super(RegisterCopperBlockEntities.COPPER_FITTING_ENTITY, blockPos, blockState, AbstractSimpleCopperBlockEntity.MOVE_TYPE.FROM_FITTING);
    }

    public void method_5447(int i, class_1799 itemStack) {
        this.method_11289(null);
        if (itemStack != null) {
            this.method_11282().set(i, (Object)itemStack);
            if (itemStack.method_7947() > this.method_5444()) {
                itemStack.method_7939(this.method_5444());
            }
        }
    }

    @Override
    public void serverTick(@NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull class_2680 blockState) {
        super.serverTick(level, blockPos, blockState);
        if (!level.field_9236) {
            if (this.transferCooldown > 0) {
                --this.transferCooldown;
            } else {
                this.fittingMove(level, blockPos, blockState);
            }
        }
    }

    public void fittingMove(@NotNull class_1937 level, class_2338 blockPos, @NotNull class_2680 blockState) {
        boolean bl1 = blockState.method_28498((class_2769)class_2741.field_12484) && (Boolean)blockState.method_11654((class_2769)class_2741.field_12484) == false && this.moveOut(level, blockPos, level.field_9229);
        boolean bl2 = this.moveIn(level, blockPos, level.field_9229);
        if (bl1 || bl2) {
            this.setCooldown(blockState);
            CopperFittingEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)blockState);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canTransfer(@NotNull class_1937 level, class_2338 pos, class_2350 direction, boolean to) {
        class_2680 blockState = level.method_8320(pos);
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof CopperPipeEntity)) return false;
        CopperPipeEntity pipe = (CopperPipeEntity)class_25862;
        if (to) {
            if (pipe.transferCooldown > 0) return false;
        }
        if (!blockState.method_28498((class_2769)class_2741.field_12525)) return false;
        if (blockState.method_11654((class_2769)class_2741.field_12525) != direction) return false;
        return true;
    }

    private boolean moveIn(class_1937 level, @NotNull class_2338 blockPos, class_5819 randomSource) {
        boolean result = false;
        for (class_2350 direction : class_156.method_43253((Object[])class_2350.values(), (class_5819)randomSource)) {
            class_2350 opposite = direction.method_10153();
            class_2338 offsetOppPos = blockPos.method_10093(opposite);
            Storage<ItemVariant> inventory = CopperPipeEntity.getStorageAt(level, offsetOppPos, direction);
            Storage<ItemVariant> fittingInventory = CopperPipeEntity.getStorageAt(level, blockPos, opposite);
            if (inventory == null || fittingInventory == null || !CopperFittingEntity.canTransfer(level, offsetOppPos, direction, false)) continue;
            for (StorageView storageView : inventory) {
                long inserted;
                if (storageView.isResourceBlank() || storageView.getAmount() <= 0L) continue;
                Transaction transaction = Transaction.openOuter();
                ItemVariant resource = (ItemVariant)storageView.getResource();
                long extracted = inventory.extract((Object)resource, 1L, (TransactionContext)transaction);
                if (extracted > 0L && (inserted = CopperPipeEntity.addItem(resource, fittingInventory, transaction)) > 0L) {
                    transaction.commit();
                    result = true;
                }
                transaction.close();
            }
        }
        return result;
    }

    private boolean moveOut(class_1937 level, @NotNull class_2338 blockPos, class_5819 random) {
        boolean result = false;
        for (class_2350 direction : class_156.method_43253((Object[])class_2350.values(), (class_5819)random)) {
            class_2338 offsetPos = blockPos.method_10093(direction);
            class_2350 opposite = direction.method_10153();
            Storage inventory = (Storage)ItemStorage.SIDED.find(level, offsetPos, level.method_8320(offsetPos), level.method_8321(offsetPos), (Object)opposite);
            Storage fittingInventory = (Storage)ItemStorage.SIDED.find(level, blockPos, level.method_8320(blockPos), level.method_8321(blockPos), (Object)direction);
            if (inventory == null || fittingInventory == null || !CopperFittingEntity.canTransfer(level, offsetPos, direction, true)) continue;
            for (StorageView storageView : fittingInventory) {
                long extracted;
                if (storageView.isResourceBlank() || storageView.getAmount() <= 0L) continue;
                Transaction transaction = Transaction.openOuter();
                ItemVariant resource = (ItemVariant)storageView.getResource();
                long inserted = inventory.insert((Object)resource, 1L, (TransactionContext)transaction);
                if (inserted > 0L && (extracted = fittingInventory.extract((Object)resource, 1L, (TransactionContext)transaction)) > 0L) {
                    transaction.commit();
                    result = true;
                }
                transaction.close();
            }
        }
        return result;
    }

    public void setCooldown(@NotNull class_2680 state) {
        int i = 2;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof CopperFitting) {
            CopperFitting fitting = (CopperFitting)class_22482;
            i = fitting.cooldown;
        }
        this.transferCooldown = i;
    }

    @Override
    public boolean canAcceptMoveableNbt(AbstractSimpleCopperBlockEntity.MOVE_TYPE moveType, class_2350 moveDirection, class_2680 fromState) {
        if (moveType == AbstractSimpleCopperBlockEntity.MOVE_TYPE.FROM_FITTING) {
            return false;
        }
        if (moveType == AbstractSimpleCopperBlockEntity.MOVE_TYPE.FROM_PIPE) {
            return moveDirection == fromState.method_11654((class_2769)class_2741.field_12525);
        }
        return false;
    }

    @Override
    public void updateBlockEntityValues(class_1937 level, class_2338 pos, @NotNull class_2680 state) {
        if (state.method_26204() instanceof CopperFitting) {
            this.canWater = (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false && SimpleCopperPipesConfig.get().carryWater;
        }
    }

    @Override
    public void method_11014(class_2487 nbtCompound) {
        super.method_11014(nbtCompound);
        this.transferCooldown = nbtCompound.method_10550("transferCooldown");
    }

    @Override
    protected void method_11007(class_2487 nbtCompound) {
        super.method_11007(nbtCompound);
        nbtCompound.method_10569("transferCooldown", this.transferCooldown);
    }
}

