/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.copper.block_entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.lunade.copper.CopperPipeMain;
import net.lunade.copper.blocks.properties.CopperPipeProperties;
import net.lunade.copper.blocks.properties.PipeFluid;
import net.lunade.copper.config.SimpleCopperPipesConfig;
import net.lunade.copper.pipe_nbt.MoveablePipeDataHandler;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1722;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_5955;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractSimpleCopperBlockEntity
extends class_2621
implements class_1263 {
    public class_2371<class_1799> inventory = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    public int waterCooldown = -1;
    public int electricityCooldown = -1;
    public boolean canWater;
    public boolean canLava;
    public boolean canSmoke;
    public int lastFixVersion;
    public MoveablePipeDataHandler moveablePipeDataHandler = new MoveablePipeDataHandler();
    public final MOVE_TYPE moveType;

    public AbstractSimpleCopperBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState, MOVE_TYPE moveType) {
        super(blockEntityType, blockPos, blockState);
        this.moveType = moveType;
    }

    public void serverTick(@NotNull class_1937 level, class_2338 blockPos, class_2680 blockState) {
        class_2680 state = blockState;
        if (!level.field_9236) {
            boolean validSmoke;
            if (this.lastFixVersion < 3 || CopperPipeMain.refreshValues) {
                this.updateBlockEntityValues(level, blockPos, blockState);
                this.lastFixVersion = 3;
            }
            if (this.canWater && !this.canLava && SimpleCopperPipesConfig.get().carryWater) {
                this.moveablePipeDataHandler.setMoveablePipeNbt(CopperPipeMain.WATER, new MoveablePipeDataHandler.SaveableMovablePipeNbt().withVec3d(new class_243(11.0, 0.0, 0.0)).withShouldCopy(true).withNBTID(CopperPipeMain.WATER));
            }
            if (this.canLava && !this.canWater && SimpleCopperPipesConfig.get().carryLava) {
                this.moveablePipeDataHandler.setMoveablePipeNbt(CopperPipeMain.LAVA, new MoveablePipeDataHandler.SaveableMovablePipeNbt().withVec3d(new class_243(11.0, 0.0, 0.0)).withShouldCopy(true).withNBTID(CopperPipeMain.LAVA));
            }
            if (this.canSmoke && !this.canWater && !this.canLava || this.canWater && this.canLava && SimpleCopperPipesConfig.get().carrySmoke) {
                this.moveablePipeDataHandler.setMoveablePipeNbt(CopperPipeMain.SMOKE, new MoveablePipeDataHandler.SaveableMovablePipeNbt().withVec3d(new class_243(11.0, 0.0, 0.0)).withShouldCopy(true).withNBTID(CopperPipeMain.SMOKE));
            }
            MoveablePipeDataHandler.SaveableMovablePipeNbt waterNbt = this.moveablePipeDataHandler.getMoveablePipeNbt(CopperPipeMain.WATER);
            MoveablePipeDataHandler.SaveableMovablePipeNbt lavaNbt = this.moveablePipeDataHandler.getMoveablePipeNbt(CopperPipeMain.LAVA);
            MoveablePipeDataHandler.SaveableMovablePipeNbt smokeNbt = this.moveablePipeDataHandler.getMoveablePipeNbt(CopperPipeMain.SMOKE);
            boolean validWater = this.isValidFluidNBT(waterNbt) && SimpleCopperPipesConfig.get().carryWater;
            boolean validLava = this.isValidFluidNBT(lavaNbt) && SimpleCopperPipesConfig.get().carryLava;
            boolean bl = validSmoke = this.isValidFluidNBT(smokeNbt) && SimpleCopperPipesConfig.get().carrySmoke;
            if (this.canSmoke && (this.canLava && !this.canWater || this.canWater && !this.canLava)) {
                validSmoke = false;
            }
            if (this.canWater && this.canLava) {
                validSmoke = SimpleCopperPipesConfig.get().carrySmoke;
                validWater = false;
                validLava = false;
            }
            if (state.method_28498(CopperPipeProperties.FLUID)) {
                state = (class_2680)state.method_11657(CopperPipeProperties.FLUID, (Comparable)((Object)(validWater ? PipeFluid.WATER : (validLava ? PipeFluid.LAVA : (validSmoke ? PipeFluid.SMOKE : PipeFluid.NONE)))));
            }
            this.tickMoveableNbt((class_3218)level, blockPos, blockState);
            this.dispenseMoveableNbt((class_3218)level, blockPos, blockState);
            this.moveMoveableNbt((class_3218)level, blockPos, blockState);
            if (this.method_5442() == ((Boolean)state.method_11654((class_2769)CopperPipeProperties.HAS_ITEM)).booleanValue()) {
                state = (class_2680)state.method_11657((class_2769)CopperPipeProperties.HAS_ITEM, (Comparable)Boolean.valueOf(!this.method_5442()));
            }
            if (this.electricityCooldown >= 0) {
                --this.electricityCooldown;
            }
            if (this.electricityCooldown == -1 && ((Boolean)state.method_11654((class_2769)CopperPipeProperties.HAS_ELECTRICITY)).booleanValue()) {
                this.electricityCooldown = 80;
                class_2248 stateGetBlock = state.method_26204();
                Optional previous = class_5955.method_34732((class_2248)stateGetBlock);
                if (previous.isPresent() && !state.method_26164(CopperPipeMain.WAXED)) {
                    state = ((class_2248)previous.get()).method_34725(state);
                }
            }
            if (this.electricityCooldown == 79) {
                AbstractSimpleCopperBlockEntity.sendElectricity(level, blockPos);
            }
            if (this.electricityCooldown == 0 && state.method_28498((class_2769)CopperPipeProperties.HAS_ELECTRICITY)) {
                state = (class_2680)state.method_11657((class_2769)CopperPipeProperties.HAS_ELECTRICITY, (Comparable)Boolean.valueOf(false));
            }
            if (state != blockState) {
                level.method_8501(blockPos, state);
            }
        }
    }

    public boolean isValidFluidNBT(@Nullable MoveablePipeDataHandler.SaveableMovablePipeNbt fluidNBT) {
        if (fluidNBT != null) {
            return fluidNBT.vec3d.method_10216() > 0.0;
        }
        return false;
    }

    public static void sendElectricity(class_1937 level, class_2338 blockPos) {
        for (class_2350 direction : class_2350.values()) {
            int axis;
            class_2586 entity;
            class_2680 state;
            class_2338 pos = blockPos.method_10093(direction);
            if (!level.method_22340(pos) || !(state = level.method_8320(pos)).method_28498((class_2769)CopperPipeProperties.HAS_ELECTRICITY) || !((entity = level.method_8321(pos)) instanceof AbstractSimpleCopperBlockEntity)) continue;
            AbstractSimpleCopperBlockEntity copperBlockEntity = (AbstractSimpleCopperBlockEntity)entity;
            int n = axis = state.method_28498((class_2769)class_2741.field_12525) ? ((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_10166().ordinal() : direction.method_10166().ordinal();
            if (copperBlockEntity.electricityCooldown != -1) continue;
            level.method_20290(3002, pos, axis);
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)CopperPipeProperties.HAS_ELECTRICITY, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void updateBlockEntityValues(class_1937 level, class_2338 pos, class_2680 state) {
    }

    public boolean canAcceptMoveableNbt(MOVE_TYPE moveType, class_2350 moveDirection, class_2680 fromState) {
        return true;
    }

    public boolean canMoveNbtInDirection(class_2350 direction, class_2680 blockState) {
        return true;
    }

    public void tickMoveableNbt(class_3218 serverLevel, class_2338 blockPos, class_2680 blockState) {
        for (MoveablePipeDataHandler.SaveableMovablePipeNbt nbt : (List)this.moveablePipeDataHandler.getSavedNbtList().clone()) {
            nbt.tick(serverLevel, blockPos, blockState, this);
        }
    }

    public void dispenseMoveableNbt(class_3218 serverLevel, class_2338 blockPos, class_2680 blockState) {
    }

    public void moveMoveableNbt(class_3218 serverLevel, class_2338 blockPos, class_2680 blockState) {
        ArrayList<MoveablePipeDataHandler.SaveableMovablePipeNbt> nbtList = this.moveablePipeDataHandler.getSavedNbtList();
        ArrayList<MoveablePipeDataHandler.SaveableMovablePipeNbt> usedNbts = new ArrayList<MoveablePipeDataHandler.SaveableMovablePipeNbt>();
        if (!nbtList.isEmpty()) {
            List dirs = class_156.method_43253((Object[])class_2350.values(), (class_5819)serverLevel.method_8409());
            for (class_2350 direction : dirs) {
                AbstractSimpleCopperBlockEntity copperEntity;
                class_2338 newPos;
                if (!this.canMoveNbtInDirection(direction, blockState) || !serverLevel.method_22340(newPos = blockPos.method_10093(direction))) continue;
                class_2680 state = serverLevel.method_8320(newPos);
                class_2586 entity = serverLevel.method_8321(newPos);
                if (!(entity instanceof AbstractSimpleCopperBlockEntity) || !(copperEntity = (AbstractSimpleCopperBlockEntity)entity).canAcceptMoveableNbt(this.moveType, direction, blockState)) continue;
                for (MoveablePipeDataHandler.SaveableMovablePipeNbt nbt : nbtList) {
                    if (!nbt.getShouldMove() || nbt.getCanOnlyGoThroughOnePipe() && usedNbts.contains(nbt) || !nbt.canMove(serverLevel, newPos, state, copperEntity)) continue;
                    MoveablePipeDataHandler.SaveableMovablePipeNbt onMove = nbt.getShouldCopy() ? nbt.copyOf() : nbt;
                    copperEntity.moveablePipeDataHandler.setMoveablePipeNbt(nbt.getNbtID(), onMove);
                    onMove.onMove(serverLevel, newPos, state, copperEntity);
                    if (usedNbts.contains(nbt)) continue;
                    usedNbts.add(nbt);
                }
            }
            this.moveablePipeDataHandler.clearAllButNonMoveable();
            usedNbts.clear();
            this.method_5431();
        }
    }

    public void method_11014(class_2487 nbtCompound) {
        super.method_11014(nbtCompound);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_11283(nbtCompound)) {
            class_1262.method_5429((class_2487)nbtCompound, this.inventory);
        }
        this.waterCooldown = nbtCompound.method_10550("WaterCooldown");
        this.electricityCooldown = nbtCompound.method_10550("electricityCooldown");
        this.canWater = nbtCompound.method_10577("canWater");
        this.canLava = nbtCompound.method_10577("canLava");
        this.canSmoke = nbtCompound.method_10577("canSmoke");
        this.lastFixVersion = nbtCompound.method_10550("lastFixVersion");
        this.moveablePipeDataHandler.readNbt(nbtCompound);
    }

    protected void method_11007(class_2487 nbtCompound) {
        super.method_11007(nbtCompound);
        if (!this.method_11286(nbtCompound)) {
            class_1262.method_5426((class_2487)nbtCompound, this.inventory);
        }
        nbtCompound.method_10569("WaterCooldown", this.waterCooldown);
        nbtCompound.method_10569("electricityCooldown", this.electricityCooldown);
        nbtCompound.method_10556("canWater", this.canWater);
        nbtCompound.method_10556("canLava", this.canLava);
        nbtCompound.method_10556("canSmoke", this.canSmoke);
        nbtCompound.method_10569("lastFixVersion", this.lastFixVersion);
        this.moveablePipeDataHandler.writeNbt(nbtCompound);
    }

    @NotNull
    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> defaultedList) {
        this.inventory = defaultedList;
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    @NotNull
    protected class_1703 method_5465(int i, class_1661 playerInventory) {
        return new class_1722(i, playerInventory, (class_1263)this);
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public static enum MOVE_TYPE {
        FROM_PIPE,
        FROM_FITTING;

    }
}

