/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.network;

import fi.dy.masa.servux.network.util.PacketUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import org.apache.commons.lang3.tuple.Pair;

public class PacketSplitter {
    public static final int MAX_TOTAL_PER_PACKET_S2C = 0x100000;
    public static final int MAX_PAYLOAD_PER_PACKET_S2C = 1048571;
    public static final int DEFAULT_MAX_RECEIVE_SIZE_C2S = 0x100000;
    private static final Map<Pair<class_2547, class_2960>, ReadingSession> READING_SESSIONS = new HashMap<Pair<class_2547, class_2960>, ReadingSession>();

    public static void send(class_2540 packet, class_2960 channel, class_3244 networkHandler) {
        PacketSplitter.send(packet, 1048571, (class_2540 buf) -> networkHandler.method_14364((class_2596)new class_2658(channel, buf)));
    }

    private static void send(class_2540 packet, int payloadLimit, Consumer<class_2540> sender) {
        int len = packet.writerIndex();
        packet.readerIndex(0);
        for (int offset = 0; offset < len; offset += payloadLimit) {
            int thisLen = Math.min(len - offset, payloadLimit);
            class_2540 buf = new class_2540(Unpooled.buffer((int)thisLen));
            if (offset == 0) {
                buf.method_10804(len);
            }
            buf.writeBytes((ByteBuf)packet, thisLen);
            sender.accept(buf);
        }
        packet.release();
    }

    @Nullable
    public static class_2540 receive(class_2960 channel, class_2540 data, class_3244 networkHandler) {
        return PacketSplitter.receive(channel, data, 0x100000, networkHandler);
    }

    @Nullable
    private static class_2540 receive(class_2960 channel, class_2540 data, int maxLength, class_3244 networkHandler) {
        Pair key = Pair.of((Object)networkHandler, (Object)channel);
        return READING_SESSIONS.computeIfAbsent((Pair<class_2547, class_2960>)key, ReadingSession::new).receive(data, maxLength);
    }

    public static void sendPacketTypeAndCompound(class_2960 channel, int packetType, class_2487 data, class_3222 player) {
        PacketSplitter.sendPacketTypeAndCompound(channel, packetType, data, player.field_13987);
    }

    public static void sendPacketTypeAndCompound(class_2960 channel, int packetType, class_2487 data, class_3244 networkHandler) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10804(packetType);
        buf.method_10794(data);
        PacketSplitter.send(buf, channel, networkHandler);
    }

    private static class ReadingSession {
        private final Pair<class_2547, class_2960> key;
        private int expectedSize = -1;
        private class_2540 received;

        private ReadingSession(Pair<class_2547, class_2960> key) {
            this.key = key;
        }

        @Nullable
        private class_2540 receive(class_2540 data, int maxLength) {
            data.readerIndex(0);
            data = PacketUtils.slice((ByteBuf)data);
            if (this.expectedSize < 0) {
                this.expectedSize = data.method_10816();
                if (this.expectedSize > maxLength) {
                    throw new IllegalArgumentException("Payload too large");
                }
                this.received = new class_2540(Unpooled.buffer((int)this.expectedSize));
            }
            this.received.writeBytes(data.readBytes(data.readableBytes()));
            if (this.received.writerIndex() >= this.expectedSize) {
                READING_SESSIONS.remove(this.key);
                return this.received;
            }
            return null;
        }
    }
}

