/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration.handlers;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import shetiphian.endertanks.Roster;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.IEnderTankInfo;
import shetiphian.endertanks.api.ITankHandler;
import shetiphian.endertanks.api.StorageAccessMode;
import shetiphian.endertanks.common.misc.CauldronHelper;
import shetiphian.endertanks.common.misc.FluidTransferUtil;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.modintegration.handlers.WrapperFluidHandler;

public class TypeFluid {
    public static void init() {
        HandlerRegistry.register(FluidVariant.class, new FluidTankHandler.Provider());
        FluidStorage.SIDED.registerForBlockEntity((tile, direction) -> tile.getTankStorage(FluidVariant.class, (class_2350)direction), Roster.Tiles.ENDERTANK);
        FluidStorage.ITEM.registerForItems((stack, context) -> TankHelper.getTank(null, StackHelper.getOwnerID(stack), StackHelper.getCode(stack)).getTankFor(FluidVariant.class).orElse(null), new class_1935[]{Roster.Items.ENDERBUCKET, Roster.Items.ENDERTANK});
    }

    public static class FluidTankHandler
    implements ITankHandler<FluidVariant> {
        private final FluidTank fluidTank;
        private final Storage<FluidVariant> fluidTankInsertOnly;
        private final Storage<FluidVariant> fluidTankExtractOnly;

        public FluidTankHandler(IEnderTankInfo tank) {
            this.fluidTank = new FluidTank(tank);
            this.fluidTankInsertOnly = new WrapperFluidHandler((Storage<FluidVariant>)this.fluidTank, true, false);
            this.fluidTankExtractOnly = new WrapperFluidHandler((Storage<FluidVariant>)this.fluidTank, false, true);
        }

        @Override
        public Storage<FluidVariant> getTank(StorageAccessMode access) {
            return switch (access) {
                case StorageAccessMode.INSERT_ONLY -> this.fluidTankInsertOnly;
                case StorageAccessMode.EXTRACT_ONLY -> this.fluidTankExtractOnly;
                default -> this.fluidTank;
            };
        }

        @Override
        public void setCapacity(int capacity) {
            this.fluidTank.setCapacity((long)capacity * 81000L);
        }

        @Override
        public void load(class_2487 nbt) {
            FluidVariant variant = FluidVariant.fromNbt((class_2487)nbt.method_10562("variant"));
            if (!variant.isBlank()) {
                this.fluidTank.setFluid(variant);
                this.fluidTank.amount = nbt.method_10537("amount");
            }
        }

        @Override
        public class_2487 save() {
            if (this.fluidTank.getAmount() > 0L && !((FluidVariant)this.fluidTank.getResource()).isBlank()) {
                class_2487 nbt = new class_2487();
                nbt.method_10566("variant", (class_2520)((FluidVariant)this.fluidTank.getResource()).toNbt());
                nbt.method_10544("amount", this.fluidTank.getAmount());
                return nbt;
            }
            return null;
        }

        @Override
        public class_5250 getContentsInfo() {
            double amount = (double)this.fluidTank.getAmount() / 81.0;
            if (amount > 0.0) {
                boolean k = amount >= 1000.0;
                return class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)"info.endertanks.tank.type.fluid")).method_27693(" ").method_10852(FluidVariantAttributes.getName((FluidVariant)((FluidVariant)this.fluidTank.getResource()))).method_27693(String.format(" [%.1f%s/%dK mB]", k ? amount / 1000.0 : amount, k ? "K" : "", this.fluidTank.getCapacity() / 81000L));
            }
            return null;
        }

        @Override
        public void preformPumpAction(class_1937 world, class_2338 pos, class_2350 facing, class_2338 pullFromPos, class_2338 pushToPos, long pumpCapacity, class_5819 random) {
            boolean handled;
            if (world.method_8608()) {
                return;
            }
            if (this.fluidTank.getAmount() < this.fluidTank.getCapacity()) {
                class_2680 fromState;
                handled = false;
                Storage fromHandler = (Storage)FluidStorage.SIDED.find(world, pullFromPos, (Object)facing);
                if (fromHandler != null) {
                    handled = FluidTransferUtil.move((Storage<FluidVariant>)fromHandler, (Storage<FluidVariant>)this.fluidTank, pumpCapacity);
                }
                if (!handled && (fromState = world.method_8320(pullFromPos)).method_26204() instanceof class_2275) {
                    CauldronHelper.drainCauldron(fromState, world, pullFromPos, this.fluidTank);
                }
            }
            if (this.fluidTank.getAmount() > 0L) {
                class_2680 toState;
                handled = false;
                Storage toHandler = (Storage)FluidStorage.SIDED.find(world, pushToPos, (Object)facing.method_10153());
                if (toHandler != null) {
                    handled = FluidTransferUtil.move((Storage<FluidVariant>)this.fluidTank, (Storage<FluidVariant>)toHandler, pumpCapacity);
                }
                if (!handled && (toState = world.method_8320(pushToPos)).method_26204() instanceof class_2275) {
                    CauldronHelper.fillCauldron(toState, world, pushToPos, this.fluidTank);
                }
            }
        }

        @Override
        public int getComparatorOutput() {
            long amount = this.fluidTank.getAmount();
            float fill = (float)amount / (float)this.fluidTank.getCapacity();
            return class_3532.method_15375((float)(fill * 14.0f)) + (amount > 0L ? 1 : 0);
        }

        @Override
        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)"info.endertanks.tank.type.fluid");
        }

        private static class FluidTank
        extends SingleVariantStorage<FluidVariant> {
            private final Runnable onContentsChanged = tank::notifyContentsChange;
            protected long capacity;

            public FluidTank(IEnderTankInfo tank) {
                this.capacity = (long)tank.getCapacity() * 81000L;
            }

            protected FluidVariant getBlankVariant() {
                return FluidVariant.blank();
            }

            protected long getCapacity(FluidVariant variant) {
                return this.capacity;
            }

            public void setFluid(FluidVariant fluid) {
                if (!((FluidVariant)this.getResource()).isOf((Object)fluid.getFluid())) {
                    this.variant = fluid;
                    this.onFinalCommit();
                }
            }

            public FluidTank setCapacity(long capacity) {
                if (this.getCapacity() != capacity) {
                    this.capacity = capacity;
                    this.onFinalCommit();
                }
                return this;
            }

            protected void onFinalCommit() {
                this.onContentsChanged.run();
            }
        }

        public static class Provider
        implements HandlerRegistry.ITankHandlerProvider<FluidVariant> {
            @Override
            public ITankHandler<FluidVariant> create(IEnderTankInfo tank) {
                return new FluidTankHandler(tank);
            }
        }
    }
}

