/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3611;

public class FluidTransferUtil {
    public static boolean move(Storage<FluidVariant> from, Storage<FluidVariant> to, long amount) {
        return FluidTransferUtil.moveWithSound(from, to, amount, false, null, false);
    }

    public static boolean moveWithSound(Storage<FluidVariant> from, Storage<FluidVariant> to, long amount, class_1657 player, boolean fillingSound) {
        return FluidTransferUtil.moveWithSound(from, to, amount, true, player, fillingSound);
    }

    private static boolean moveWithSound(Storage<FluidVariant> from, Storage<FluidVariant> to, long amount, boolean playSound, class_1657 player, boolean fillingSound) {
        for (StorageView view : from) {
            long maxExtracted;
            if (view.isResourceBlank()) continue;
            FluidVariant resource = (FluidVariant)view.getResource();
            try (Transaction extractionTestTransaction = Transaction.openOuter();){
                maxExtracted = view.extract((Object)resource, amount, (TransactionContext)extractionTestTransaction);
                extractionTestTransaction.abort();
            }
            Transaction transferTransaction = Transaction.openOuter();
            try {
                long accepted = to.insert((Object)resource, maxExtracted, (TransactionContext)transferTransaction);
                if (accepted <= 0L || view.extract((Object)resource, accepted, (TransactionContext)transferTransaction) != accepted) continue;
                transferTransaction.commit();
                if (playSound && player != null) {
                    class_3414 sound = fillingSound ? FluidVariantAttributes.getFillSound((FluidVariant)resource) : FluidVariantAttributes.getEmptySound((FluidVariant)resource);
                    player.method_17356(sound, class_3419.field_15245, 1.0f, 1.0f);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (transferTransaction == null) continue;
                transferTransaction.close();
            }
        }
        return false;
    }

    public static boolean fill(Storage<FluidVariant> storage, class_3611 fluid, long amount) {
        return FluidTransferUtil.fill(storage, FluidVariant.of((class_3611)fluid), amount);
    }

    public static boolean fill(Storage<FluidVariant> storage, FluidVariant resource, long amount) {
        Transaction transferTransaction = Transaction.openOuter();
        if (storage.insert((Object)resource, amount, (TransactionContext)transferTransaction) == amount) {
            transferTransaction.commit();
            return true;
        }
        return false;
    }

    public static boolean drain(Storage<FluidVariant> storage, class_3611 fluid, long amount) {
        return FluidTransferUtil.drain(storage, FluidVariant.of((class_3611)fluid), amount);
    }

    public static boolean drain(Storage<FluidVariant> storage, FluidVariant resource, long amount) {
        Transaction transferTransaction = Transaction.openOuter();
        if (storage.extract((Object)resource, amount, (TransactionContext)transferTransaction) == amount) {
            transferTransaction.commit();
            return true;
        }
        return false;
    }
}

