/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks;

import com.mojang.logging.LogUtils;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import shetiphian.core.common.events.ServerWorldSaveCallback;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.Roster;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.common.misc.CauldronHelper;
import shetiphian.endertanks.common.misc.EventHandler;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.network.NetworkHandler;
import shetiphian.endertanks.modintegration.ModIntegration;

public class EnderTanks
implements ModInitializer {
    public static final String MOD_ID = "endertanks";
    public static EnderTanks INSTANCE;
    public static Logger LOGGER;
    public static Configuration CONFIG;

    public EnderTanks() {
        INSTANCE = this;
        LOGGER = LogUtils.getLogger();
    }

    public void onInitialize() {
        Roster.process();
        AutoConfig.register(Configuration.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        CONFIG = (Configuration)AutoConfig.getConfigHolder(Configuration.class).getConfig();
        Values.minecraftDir = FabricLoader.getInstance().getGameDir().toString();
        ServerLifecycleEvents.SERVER_STARTING.register(EnderTanks::serverStarted);
        ServerLifecycleEvents.SERVER_STOPPED.register(EnderTanks::serverStopped);
        CommonLifecycleEvents.TAGS_LOADED.register(EventHandler::tagsUpdated);
        ServerWorldSaveCallback.EVENT.register(EventHandler::worldSave);
        UseBlockCallback.EVENT.register(EventHandler::playerRightClickBlock);
        CauldronHelper.register();
        NetworkHandler.initialise();
        new ModIntegration();
    }

    private static void serverStarted(MinecraftServer server) {
        TankHelper.INSTANCE.loadTankData(server);
    }

    private static void serverStopped(MinecraftServer server) {
        TankHelper.INSTANCE.unloadTankData();
        Values.canProcessTags = false;
    }

    static {
        CONFIG = new Configuration();
    }
}

