/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import shetiphian.core.common.TagHelper;
import shetiphian.endertanks.Values;

@Config(name="endertanks")
public class Configuration
extends PartitioningSerializer.GlobalData {
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.TransitiveObject
    public ClientFile CLIENT = new ClientFile();
    @ConfigEntry.Category(value="common")
    @ConfigEntry.Gui.TransitiveObject
    public CommonFile COMMON = new CommonFile();

    private static void process_client(ClientFile clientFile) {
        Values.colorValues[0] = clientFile.COLOR_VALUES.white;
        Values.colorValues[1] = clientFile.COLOR_VALUES.orange;
        Values.colorValues[2] = clientFile.COLOR_VALUES.magenta;
        Values.colorValues[3] = clientFile.COLOR_VALUES.light_blue;
        Values.colorValues[4] = clientFile.COLOR_VALUES.yellow;
        Values.colorValues[5] = clientFile.COLOR_VALUES.lime;
        Values.colorValues[6] = clientFile.COLOR_VALUES.pink;
        Values.colorValues[7] = clientFile.COLOR_VALUES.gray;
        Values.colorValues[8] = clientFile.COLOR_VALUES.light_gray;
        Values.colorValues[9] = clientFile.COLOR_VALUES.cyan;
        Values.colorValues[10] = clientFile.COLOR_VALUES.purple;
        Values.colorValues[11] = clientFile.COLOR_VALUES.blue;
        Values.colorValues[12] = clientFile.COLOR_VALUES.brown;
        Values.colorValues[13] = clientFile.COLOR_VALUES.green;
        Values.colorValues[14] = clientFile.COLOR_VALUES.red;
        Values.colorValues[15] = clientFile.COLOR_VALUES.black;
    }

    private static void process_common(CommonFile commonFile) {
        int tankMin = commonFile.UPGRADE_SETTINGS.tank_size_min;
        int tankMax = commonFile.UPGRADE_SETTINGS.tank_size_max;
        if (tankMin > tankMax) {
            commonFile.UPGRADE_SETTINGS.tank_size_min = tankMax;
            commonFile.UPGRADE_SETTINGS.tank_size_max = tankMin;
        }
        if (Values.canProcessTags) {
            Configuration.processTagLists(commonFile);
        }
    }

    public static void processTagLists(CommonFile commonFile) {
        Configuration.process(commonFile.UPGRADE_ITEMS.personal, Values.listPersonal, class_1802.field_8477);
        Configuration.process(commonFile.UPGRADE_ITEMS.team, Values.listTeam, class_1802.field_8687);
        Configuration.process(commonFile.UPGRADE_ITEMS.small_capacity, Values.listSmallCap_Multi, class_1802.field_8634);
        Configuration.process(commonFile.UPGRADE_ITEMS.large_capacity, Values.listLargeCap_Multi, class_1802.field_8449);
        Configuration.process(commonFile.UPGRADE_ITEMS.pump, Values.listPump_Multi, class_1802.field_8249);
        Configuration.process(commonFile.UPGRADE_ITEMS.small_capacity_singleuse, Values.listSmallCap_Single, null);
        Configuration.process(commonFile.UPGRADE_ITEMS.large_capacity_singleuse, Values.listLargeCap_Single, null);
        Configuration.process(commonFile.UPGRADE_ITEMS.pump_singleuse, Values.listPump_Single, null);
    }

    /*
     * WARNING - void declaration
     */
    private static void process(Set<? extends String> names, ArrayList<class_1792> list, class_1792 basic) {
        list.clear();
        for (String string : names) {
            void var4_4;
            if (Strings.isNullOrEmpty((String)string)) continue;
            boolean isTag = false;
            if (string.toLowerCase().startsWith("tag|")) {
                isTag = true;
                String string2 = string.substring(4);
            }
            if (isTag) {
                TagHelper.getItems((String)var4_4).forEach(item -> Configuration.addToList(item, list));
                continue;
            }
            Configuration.addToList((class_1792)class_7923.field_41178.method_10223(new class_2960((String)var4_4)), list);
        }
        if (list.isEmpty() && basic != null) {
            list.add(basic);
        }
    }

    private static void addToList(class_1792 item, ArrayList<class_1792> list) {
        if (list != null && item != null && !list.contains(item)) {
            list.add(item);
        }
    }

    @Config(name="client")
    public static class ClientFile
    implements ConfigData {
        @Comment(value="Delay, in milliseconds, before a multi-line tank info request will display the next line")
        @ConfigEntry.BoundedDiscrete(min=250L, max=10000L)
        public int info_line_change_delay = 1500;
        @Comment(value="Color Values for Bands, \r\nFormat: Decimal Values (0 to 16,777,215) \r\nYou can use this website to get the decimal value of any color: \r\nhttp://www.colorhexa.com \r\nOr by using the Color Mixer from this website: \r\nhttp://www.mathsisfun.com/hexadecimal-decimal-colors.html")
        @ConfigEntry.Gui.CollapsibleObject
        public Menu_Color COLOR_VALUES = new Menu_Color();

        public void validatePostLoad() throws ConfigData.ValidationException {
            super.validatePostLoad();
            try {
                Configuration.process_client(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static class Menu_Color {
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int white = 0xFFFFFF;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int orange = 14517579;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int magenta = 12411333;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int light_blue = 8296912;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int yellow = 12892206;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int lime = 4832573;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int pink = 14195370;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int gray = 0x464646;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int light_gray = 0xA9AFAF;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int cyan = 3373205;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int purple = 8996546;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int blue = 3292826;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int brown = 5650466;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int green = 3821086;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int red = 0xA53A35;
            @ConfigEntry.BoundedDiscrete(min=0L, max=0xFFFFFFL)
            public int black = 0x262626;
        }
    }

    @Config(name="common")
    public static class CommonFile
    implements ConfigData {
        @Comment(value="With this disabled tanks are essentially locked to the crafted color as dyes will no longer work")
        public boolean enable_in_world_coloring = true;
        @Comment(value="Item used to upgrade the EnderTanks")
        @ConfigEntry.Gui.CollapsibleObject
        public Menu_Upgrade UPGRADE_ITEMS = new Menu_Upgrade();
        @Comment(value="Set the number of buckets a tank holds, how many pump upgrades can be applied, and the value of a storage upgrade")
        @ConfigEntry.Gui.CollapsibleObject
        public Menu_Settings UPGRADE_SETTINGS = new Menu_Settings();
        @Comment(value="")
        @ConfigEntry.Gui.CollapsibleObject
        public Menu_Access ACCESS_SETTINGS = new Menu_Access();

        public void validatePostLoad() throws ConfigData.ValidationException {
            super.validatePostLoad();
            try {
                Configuration.process_common(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static class Menu_Upgrade {
            @Comment(value="Items used to make the tanks personal")
            Set<String> personal = this.getListOf("tag|c:diamonds");
            @Comment(value="Items used to make the tanks team tanks")
            Set<String> team = this.getListOf("tag|c:emeralds");
            @Comment(value="Items that apply a small storage capacity upgrade")
            Set<String> small_capacity = this.getListOf("tag|c:ender_pearls");
            @Comment(value="Items that apply a large storage capacity upgrade")
            Set<String> large_capacity = this.getListOf("minecraft:ender_eye");
            @Comment(value="Items that are used to increase the tanks internal transfer pump")
            Set<String> pump = this.getListOf("minecraft:piston");
            @Comment(value="Items that apply a small storage capacity upgrade \r\nEach item can only be use once per tank")
            Set<String> small_capacity_singleuse = new HashSet<String>();
            @Comment(value="Items that apply a large storage capacity upgrade \r\nEach item can only be use once per tank")
            Set<String> large_capacity_singleuse = new HashSet<String>();
            @Comment(value="Items that are used to increase the tanks internal transfer pump \r\nEach item can only be use once per tank")
            Set<String> pump_singleuse = new HashSet<String>();
            Predicate<Object> validator = object -> {
                if (object instanceof String) {
                    String string = (String)object;
                    return Strings.isNullOrEmpty((String)string) || string.split(":").length == 2;
                }
                return false;
            };

            private Set<String> getListOf(String ... values) {
                return new HashSet<String>(Arrays.asList(values));
            }
        }

        public static class Menu_Settings {
            @Comment(value="How many internal transfer pump upgrades can a tank have? \r\n default is only 1/4 bucket, upgrades make it a bucket per upgrade")
            @ConfigEntry.BoundedDiscrete(min=0L, max=8L)
            public int tank_pump_max = 4;
            @Comment(value="Minimum capacity an EnderTank holds")
            @ConfigEntry.BoundedDiscrete(min=4L, max=128L)
            public int tank_size_min = 32;
            @Comment(value="Maximum capacity an EnderTank holds")
            @ConfigEntry.BoundedDiscrete(min=4L, max=512L)
            public int tank_size_max = 256;
            @Comment(value="Capacity increased by small capacity upgrade items")
            @ConfigEntry.BoundedDiscrete(min=2L, max=16L)
            public int small_capacity_upgrade = 8;
            @Comment(value="Capacity increased by large capacity upgrade items")
            @ConfigEntry.BoundedDiscrete(min=4L, max=32L)
            public int large_capacity_upgrade = 16;
        }

        public static class Menu_Access {
            @Comment(value="Enables the usage of public tanks, if disabled tanks must be upgraded before use")
            public boolean public_tanks = true;
            @Comment(value="Enables the creation of personal tanks, if disabled tanks can not set personal. \r\nDoes not effect tanks that are already set as personal")
            public boolean personal_tanks = true;
            @Comment(value="Enables the creation of team tanks, if disabled tanks can not be set team. \r\nDoes not effect tanks that are already set as team")
            public boolean team_tanks = true;
            @Comment(value="Enables the usage of public buckets, if disabled buckets must be linked to an upgraded tank before use")
            public boolean public_buckets = true;
            @Comment(value="Enables the linking of buckets to personal tanks. \r\nDoes not effect buckets that are already linked to personal tanks")
            public boolean personal_buckets = true;
            @Comment(value="Enables the linking of buckets to team tanks. \r\nDoes not effect buckets that are already linked to team tanks")
            public boolean team_buckets = true;
            @Comment(value="Public tanks can be used with automation.")
            public boolean public_automation = true;
            @Comment(value="Personal tanks can be used with automation.")
            public boolean personal_automation = true;
            @Comment(value="Team tanks can be used with automation.")
            public boolean team_automation = true;
            @Comment(value="While true a Personal tank can only be edited (upgrade, move, etc) by the owner")
            public boolean personal_edit_lock = true;
            @Comment(value="While true a Team tank can only be edited (upgrade, move, etc) by a team member")
            public boolean team_edit_lock = true;
            @Comment(value="While true only the owner can link a bucket to their tanks")
            public boolean personal_link_lock = true;
            @Comment(value="While true only a team member can link a bucket to team tanks")
            public boolean team_link_lock = true;
            @Comment(value="While true only the owner can use the tank")
            public boolean personal_use_lock = false;
            @Comment(value="While true only a team member can use the tank")
            public boolean team_use_lock = false;
        }
    }
}

