/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.CarpetSettings;
import carpet.helpers.HopperCounter;
import carpet.utils.BlockInfo;
import carpet.utils.DistanceCalculator;
import carpet.utils.Messenger;
import carpet.utils.SpawnReporter;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class WoolTool {
    private static final Map<class_2248, class_1767> WOOL_BLOCK_TO_DYE = Map.ofEntries(Map.entry(class_2246.field_10446, class_1767.field_7952), Map.entry(class_2246.field_10095, class_1767.field_7946), Map.entry(class_2246.field_10215, class_1767.field_7958), Map.entry(class_2246.field_10294, class_1767.field_7951), Map.entry(class_2246.field_10490, class_1767.field_7947), Map.entry(class_2246.field_10028, class_1767.field_7961), Map.entry(class_2246.field_10459, class_1767.field_7954), Map.entry(class_2246.field_10423, class_1767.field_7944), Map.entry(class_2246.field_10222, class_1767.field_7967), Map.entry(class_2246.field_10619, class_1767.field_7955), Map.entry(class_2246.field_10259, class_1767.field_7945), Map.entry(class_2246.field_10514, class_1767.field_7966), Map.entry(class_2246.field_10113, class_1767.field_7957), Map.entry(class_2246.field_10170, class_1767.field_7942), Map.entry(class_2246.field_10314, class_1767.field_7964), Map.entry(class_2246.field_10146, class_1767.field_7963));

    public static void carpetPlacedAction(class_1767 color, class_1657 placer, class_2338 pos, class_3218 worldIn) {
        if (!CarpetSettings.carpets) {
            return;
        }
        switch (color) {
            case field_7954: {
                if ("false".equals(CarpetSettings.commandSpawn)) break;
                Messenger.send(placer, SpawnReporter.report(pos, worldIn));
                break;
            }
            case field_7963: {
                if ("false".equals(CarpetSettings.commandSpawn)) break;
                Messenger.send(placer, SpawnReporter.show_mobcaps(pos, worldIn));
                break;
            }
            case field_7957: {
                if ("false".equals(CarpetSettings.commandDistance)) break;
                class_2168 source = placer.method_5671();
                if (!DistanceCalculator.hasStartingPoint(source) || placer.method_5715()) {
                    DistanceCalculator.setStart(source, class_243.method_24954((class_2382)pos));
                    break;
                }
                DistanceCalculator.setEnd(source, class_243.method_24954((class_2382)pos));
                break;
            }
            case field_7944: {
                if ("false".equals(CarpetSettings.commandInfo)) break;
                Messenger.send(placer, BlockInfo.blockInfo(pos.method_10074(), worldIn));
                break;
            }
            case field_7942: {
                if (!CarpetSettings.hopperCounters) break;
                class_1767 under = WoolTool.getWoolColorAtPosition((class_1937)worldIn, pos.method_10074());
                if (under == null) {
                    return;
                }
                HopperCounter counter = HopperCounter.getCounter(under);
                Messenger.send(placer, counter.format(worldIn.method_8503(), false, false));
                break;
            }
            case field_7964: {
                if (!CarpetSettings.hopperCounters) break;
                class_1767 under = WoolTool.getWoolColorAtPosition((class_1937)worldIn, pos.method_10074());
                if (under == null) {
                    return;
                }
                HopperCounter counter = HopperCounter.getCounter(under);
                counter.reset(placer.method_5682());
                ArrayList<class_2561> res = new ArrayList<class_2561>();
                res.add(Messenger.s(String.format("%s counter reset", under.toString())));
                Messenger.send(placer, res);
            }
        }
    }

    @Nullable
    public static class_1767 getWoolColorAtPosition(class_1937 worldIn, class_2338 pos) {
        class_2680 state = worldIn.method_8320(pos);
        return WOOL_BLOCK_TO_DYE.get(state.method_26204());
    }
}

