/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.CarpetContext;
import carpet.script.CarpetScriptServer;
import carpet.script.EntityEventsGroup;
import carpet.script.argument.Vector3Argument;
import carpet.script.exception.InternalExpressionException;
import carpet.script.external.Carpet;
import carpet.script.external.Vanilla;
import carpet.script.utils.EntityTools;
import carpet.script.utils.InputValidator;
import carpet.script.utils.Tracer;
import carpet.script.value.BlockValue;
import carpet.script.value.BooleanValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.FunctionValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1311;
import net.minecraft.class_1314;
import net.minecraft.class_1320;
import net.minecraft.class_1352;
import net.minecraft.class_1370;
import net.minecraft.class_1439;
import net.minecraft.class_1533;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1687;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_2300;
import net.minecraft.class_2303;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2709;
import net.minecraft.class_2735;
import net.minecraft.class_2748;
import net.minecraft.class_2752;
import net.minecraft.class_2777;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4831;
import net.minecraft.class_5131;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5575;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class EntityValue
extends Value {
    private class_1297 entity;
    private static final Map<String, class_2300> selectorCache = new HashMap<String, class_2300>();
    public static final class_5575<class_1297, ?> ANY = class_5575.method_31795(class_1297.class);
    private static final Map<String, class_1304> inventorySlots = Map.of("mainhand", class_1304.field_6173, "offhand", class_1304.field_6171, "head", class_1304.field_6169, "chest", class_1304.field_6174, "legs", class_1304.field_6172, "feet", class_1304.field_6166);
    private static final Map<String, BiFunction<class_1297, Value, Value>> featureAccessors = new HashMap<String, BiFunction<class_1297, Value, Value>>(){
        {
            this.put("removed", (entity, arg) -> BooleanValue.of(entity.method_31481()));
            this.put("uuid", (e, a) -> new StringValue(e.method_5845()));
            this.put("id", (e, a) -> new NumericValue(e.method_5628()));
            this.put("pos", (e, a) -> ListValue.of(new NumericValue(e.method_23317()), new NumericValue(e.method_23318()), new NumericValue(e.method_23321())));
            this.put("location", (e, a) -> ListValue.of(new NumericValue(e.method_23317()), new NumericValue(e.method_23318()), new NumericValue(e.method_23321()), new NumericValue(e.method_36454()), new NumericValue(e.method_36455())));
            this.put("x", (e, a) -> new NumericValue(e.method_23317()));
            this.put("y", (e, a) -> new NumericValue(e.method_23318()));
            this.put("z", (e, a) -> new NumericValue(e.method_23321()));
            this.put("motion", (e, a) -> {
                class_243 velocity = e.method_18798();
                return ListValue.of(new NumericValue(velocity.field_1352), new NumericValue(velocity.field_1351), new NumericValue(velocity.field_1350));
            });
            this.put("motion_x", (e, a) -> new NumericValue(e.method_18798().field_1352));
            this.put("motion_y", (e, a) -> new NumericValue(e.method_18798().field_1351));
            this.put("motion_z", (e, a) -> new NumericValue(e.method_18798().field_1350));
            this.put("on_ground", (e, a) -> BooleanValue.of(e.method_24828()));
            this.put("name", (e, a) -> new StringValue(e.method_5477().getString()));
            this.put("display_name", (e, a) -> new FormattedTextValue(e.method_5476()));
            this.put("command_name", (e, a) -> new StringValue(e.method_5820()));
            this.put("custom_name", (e, a) -> e.method_16914() ? new StringValue(e.method_5797().getString()) : Value.NULL);
            this.put("type", (e, a) -> NBTSerializableValue.nameFromRegistryId(e.method_37908().method_30349().method_30530(class_7924.field_41266).method_10221((Object)e.method_5864())));
            this.put("is_riding", (e, a) -> BooleanValue.of(e.method_5765()));
            this.put("is_ridden", (e, a) -> BooleanValue.of(e.method_5782()));
            this.put("passengers", (e, a) -> ListValue.wrap(e.method_5685().stream().map(EntityValue::new)));
            this.put("mount", (e, a) -> e.method_5854() != null ? new EntityValue(e.method_5854()) : Value.NULL);
            this.put("unmountable", (e, a) -> BooleanValue.of(Vanilla.Entity_isPermanentVehicle(e)));
            this.put("tags", (e, a) -> ListValue.wrap(e.method_5752().stream().map(StringValue::new)));
            this.put("scoreboard_tags", (e, a) -> ListValue.wrap(e.method_5752().stream().map(StringValue::new)));
            this.put("entity_tags", (e, a) -> {
                class_1299 type = e.method_5864();
                return ListValue.wrap(e.method_5682().method_30611().method_30530(class_7924.field_41266).method_40272().filter(entry -> ((class_6885.class_6888)entry.getSecond()).method_40239().anyMatch(h -> h.comp_349() == type)).map(entry -> ValueConversions.of((class_6862)entry.getFirst())));
            });
            this.put("has_tag", (e, a) -> BooleanValue.of(e.method_5752().contains(a.getString())));
            this.put("has_scoreboard_tag", (e, a) -> BooleanValue.of(e.method_5752().contains(a.getString())));
            this.put("has_entity_tag", (e, a) -> {
                Optional tag = e.method_5682().method_30611().method_30530(class_7924.field_41266).method_40266(class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)InputValidator.identifierOf(a.getString())));
                if (tag.isEmpty()) {
                    return Value.NULL;
                }
                class_1299 type = e.method_5864();
                return BooleanValue.of(((class_6885.class_6888)tag.get()).method_40239().anyMatch(h -> h.comp_349() == type));
            });
            this.put("yaw", (e, a) -> new NumericValue(e.method_36454()));
            this.put("head_yaw", (e, a) -> e instanceof class_1309 ? new NumericValue(e.method_5791()) : Value.NULL);
            this.put("body_yaw", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_1309) {
                    class_1309 le = (class_1309)e;
                    numericValue = new NumericValue(le.field_6283);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("pitch", (e, a) -> new NumericValue(e.method_36455()));
            this.put("look", (e, a) -> {
                class_243 look = e.method_5720();
                return ListValue.of(new NumericValue(look.field_1352), new NumericValue(look.field_1351), new NumericValue(look.field_1350));
            });
            this.put("is_burning", (e, a) -> BooleanValue.of(e.method_5809()));
            this.put("fire", (e, a) -> new NumericValue(e.method_20802()));
            this.put("is_freezing", (e, a) -> BooleanValue.of(e.method_32314()));
            this.put("frost", (e, a) -> new NumericValue(e.method_32312()));
            this.put("silent", (e, a) -> BooleanValue.of(e.method_5701()));
            this.put("gravity", (e, a) -> BooleanValue.of(!e.method_5740()));
            this.put("immune_to_fire", (e, a) -> BooleanValue.of(e.method_5753()));
            this.put("immune_to_frost", (e, a) -> BooleanValue.of(!e.method_32316()));
            this.put("invulnerable", (e, a) -> BooleanValue.of(e.method_5655()));
            this.put("dimension", (e, a) -> NBTSerializableValue.nameFromRegistryId(e.method_37908().method_27983().method_29177()));
            this.put("height", (e, a) -> new NumericValue(e.method_18377((class_4050)class_4050.field_18076).field_18068));
            this.put("width", (e, a) -> new NumericValue(e.method_18377((class_4050)class_4050.field_18076).field_18067));
            this.put("eye_height", (e, a) -> new NumericValue(e.method_5751()));
            this.put("age", (e, a) -> new NumericValue(e.field_6012));
            this.put("breeding_age", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_1296) {
                    class_1296 am = (class_1296)e;
                    numericValue = new NumericValue(am.method_5618());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("despawn_timer", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_1309) {
                    class_1309 le = (class_1309)e;
                    numericValue = new NumericValue(le.method_6131());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("blue_skull", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_1687) {
                    class_1687 w = (class_1687)e;
                    numericValue = BooleanValue.of(w.method_7503());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("offering_flower", (e, a) -> {
                class_1439 ig;
                return e instanceof class_1439 ? BooleanValue.of((ig = (class_1439)e).method_6502() > 0) : Value.NULL;
            });
            this.put("item", (e, a) -> {
                Value value;
                if (e instanceof class_1542) {
                    class_1542 ie = (class_1542)e;
                    value = ValueConversions.of(ie.method_6983(), (class_5455)e.method_5682().method_30611());
                } else if (e instanceof class_1533) {
                    class_1533 frame = (class_1533)e;
                    value = ValueConversions.of(frame.method_6940(), (class_5455)e.method_5682().method_30611());
                } else {
                    value = Value.NULL;
                }
                return value;
            });
            this.put("count", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_1542) {
                    class_1542 ie = (class_1542)e;
                    numericValue = new NumericValue(ie.method_6983().method_7947());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("pickup_delay", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_1542) {
                    class_1542 ie = (class_1542)e;
                    numericValue = new NumericValue(Vanilla.ItemEntity_getPickupDelay(ie));
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("portal_cooldown", (e, a) -> new NumericValue(Vanilla.Entity_getPublicNetherPortalCooldown(e)));
            this.put("portal_timer", (e, a) -> new NumericValue(Vanilla.Entity_getPortalTimer(e)));
            this.put("is_baby", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_1309) {
                    class_1309 le = (class_1309)e;
                    numericValue = BooleanValue.of(le.method_6109());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("target", (e, a) -> {
                class_1308 mob;
                class_1309 target;
                if (e instanceof class_1308 && (target = (mob = (class_1308)e).method_5968()) != null) {
                    return new EntityValue((class_1297)target);
                }
                return Value.NULL;
            });
            this.put("home", (e, a) -> {
                class_1308 mob;
                return e instanceof class_1308 ? ((mob = (class_1308)e).method_18413() > 0.0f ? new BlockValue(null, (class_3218)e.method_37908(), mob.method_18412()) : Value.FALSE) : Value.NULL;
            });
            this.put("spawn_point", (e, a) -> {
                if (e instanceof class_3222) {
                    class_3222 spe = (class_3222)e;
                    if (spe.method_26280() == null) {
                        return Value.FALSE;
                    }
                    return ListValue.of(ValueConversions.of(spe.method_26280()), ValueConversions.of(spe.method_26281()), new NumericValue(spe.method_30631()), BooleanValue.of(spe.method_26282()));
                }
                return Value.NULL;
            });
            this.put("pose", (e, a) -> new StringValue(e.method_18376().name().toLowerCase(Locale.ROOT)));
            this.put("sneaking", (e, a) -> e.method_5715() ? Value.TRUE : Value.FALSE);
            this.put("sprinting", (e, a) -> e.method_5624() ? Value.TRUE : Value.FALSE);
            this.put("swimming", (e, a) -> e.method_5681() ? Value.TRUE : Value.FALSE);
            this.put("swinging", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_1309) {
                    class_1309 le = (class_1309)e;
                    numericValue = BooleanValue.of(le.field_6252);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("air", (e, a) -> new NumericValue(e.method_5669()));
            this.put("language", (e, a) -> {
                Value value;
                if (!(e instanceof class_3222)) {
                    value = Value.NULL;
                } else {
                    class_3222 p = (class_3222)e;
                    value = StringValue.of(Vanilla.ServerPlayer_getLanguage(p));
                }
                return value;
            });
            this.put("persistence", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_1308) {
                    class_1308 mob = (class_1308)e;
                    numericValue = BooleanValue.of(mob.method_5947());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("hunger", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_1657) {
                    class_1657 player = (class_1657)e;
                    numericValue = new NumericValue(player.method_7344().method_7586());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("saturation", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_1657) {
                    class_1657 player = (class_1657)e;
                    numericValue = new NumericValue(player.method_7344().method_7589());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("exhaustion", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_1657) {
                    class_1657 player = (class_1657)e;
                    numericValue = new NumericValue(player.method_7344().method_35219());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("absorption", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_1657) {
                    class_1657 player = (class_1657)e;
                    numericValue = new NumericValue(player.method_6067());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("xp", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_1657) {
                    class_1657 player = (class_1657)e;
                    numericValue = new NumericValue(player.field_7495);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("xp_level", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_1657) {
                    class_1657 player = (class_1657)e;
                    numericValue = new NumericValue(player.field_7520);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("xp_progress", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_1657) {
                    class_1657 player = (class_1657)e;
                    numericValue = new NumericValue(player.field_7510);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("score", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_1657) {
                    class_1657 player = (class_1657)e;
                    numericValue = new NumericValue(player.method_7272());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("jumping", (e, a) -> {
                class_1309 le;
                return e instanceof class_1309 ? (Vanilla.LivingEntity_isJumping(le = (class_1309)e) ? Value.TRUE : Value.FALSE) : Value.NULL;
            });
            this.put("gamemode", (e, a) -> {
                Value value;
                if (e instanceof class_3222) {
                    class_3222 sp = (class_3222)e;
                    value = new StringValue(sp.field_13974.method_14257().method_8381());
                } else {
                    value = Value.NULL;
                }
                return value;
            });
            this.put("path", (e, a) -> {
                if (e instanceof class_1308) {
                    class_1308 mob = (class_1308)e;
                    class_11 path = mob.method_5942().method_6345();
                    if (path == null) {
                        return Value.NULL;
                    }
                    return ValueConversions.fromPath((class_3218)e.method_5770(), path);
                }
                return Value.NULL;
            });
            this.put("brain", (e, a) -> {
                String module = a.getString();
                class_4140 moduleType = (class_4140)e.method_37908().method_30349().method_30530(class_7924.field_41206).method_10223(InputValidator.identifierOf(module));
                if (moduleType == class_4140.field_18437) {
                    return Value.NULL;
                }
                if (e instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)e;
                    class_4095 brain = livingEntity.method_18868();
                    Map memories = brain.method_35058();
                    Optional optmemory = (Optional)memories.get(moduleType);
                    if (optmemory == null || !optmemory.isPresent()) {
                        return Value.NULL;
                    }
                    class_4831 memory = (class_4831)optmemory.get();
                    return ValueConversions.fromTimedMemory(e, memory.method_35127(), memory.method_24637());
                }
                return Value.NULL;
            });
            this.put("gamemode_id", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_3222) {
                    class_3222 sp = (class_3222)e;
                    numericValue = new NumericValue(sp.field_13974.method_14257().method_8379());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("permission_level", (e, a) -> {
                if (e instanceof class_3222) {
                    class_3222 spe = (class_3222)e;
                    for (int i = 4; i >= 0; --i) {
                        if (!spe.method_5687(i)) continue;
                        return new NumericValue(i);
                    }
                    return new NumericValue(0L);
                }
                return Value.NULL;
            });
            this.put("player_type", (e, a) -> {
                if (e instanceof class_1657) {
                    class_1657 p = (class_1657)e;
                    String moddedType = Carpet.isModdedPlayer(p);
                    if (moddedType != null) {
                        return StringValue.of(moddedType);
                    }
                    MinecraftServer server = p.method_5770().method_8503();
                    if (server.method_3816()) {
                        return new StringValue("multiplayer");
                    }
                    boolean runningLan = server.method_3860();
                    if (!runningLan) {
                        return new StringValue("singleplayer");
                    }
                    boolean isowner = server.method_19466(p.method_7334());
                    if (isowner) {
                        return new StringValue("lan_host");
                    }
                    return new StringValue("lan player");
                }
                return Value.NULL;
            });
            this.put("client_brand", (e, a) -> {
                Value value;
                if (e instanceof class_3222) {
                    class_3222 sp = (class_3222)e;
                    value = StringValue.of(Carpet.getPlayerStatus(sp));
                } else {
                    value = Value.NULL;
                }
                return value;
            });
            this.put("team", (e, a) -> e.method_5781() == null ? Value.NULL : new StringValue(e.method_5781().method_1197()));
            this.put("ping", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_3222) {
                    class_3222 sp = (class_3222)e;
                    numericValue = new NumericValue(sp.field_13967);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("effect", (e, a) -> {
                if (!(e instanceof class_1309)) {
                    return Value.NULL;
                }
                class_1309 le = (class_1309)e;
                if (a == null) {
                    ArrayList<Value> effects = new ArrayList<Value>();
                    for (class_1293 p : le.method_6026()) {
                        effects.add(ListValue.of(new StringValue(p.method_5586().replaceFirst("^effect\\.minecraft\\.", "")), new NumericValue(p.method_5578()), new NumericValue(p.method_5584())));
                    }
                    return ListValue.wrap(effects);
                }
                String effectName = a.getString();
                class_1291 potion = (class_1291)class_7923.field_41174.method_10223(InputValidator.identifierOf(effectName));
                if (potion == null) {
                    throw new InternalExpressionException("No such an effect: " + effectName);
                }
                if (!le.method_6059(potion)) {
                    return Value.NULL;
                }
                class_1293 pe = le.method_6112(potion);
                return ListValue.of(new NumericValue(pe.method_5578()), new NumericValue(pe.method_5584()));
            });
            this.put("health", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_1309) {
                    class_1309 le = (class_1309)e;
                    numericValue = new NumericValue(le.method_6032());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("may_fly", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    numericValue = BooleanValue.of(player.method_31549().field_7478);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("flying", (e, v) -> {
                NumericValue numericValue;
                if (e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    numericValue = BooleanValue.of(player.method_31549().field_7479);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("may_build", (e, v) -> {
                NumericValue numericValue;
                if (e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    numericValue = BooleanValue.of(player.method_31549().field_7476);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("insta_build", (e, v) -> {
                NumericValue numericValue;
                if (e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    numericValue = BooleanValue.of(player.method_31549().field_7477);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("fly_speed", (e, v) -> {
                Value value;
                if (e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    value = NumericValue.of(Float.valueOf(player.method_31549().method_7252()));
                } else {
                    value = Value.NULL;
                }
                return value;
            });
            this.put("walk_speed", (e, v) -> {
                Value value;
                if (e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    value = NumericValue.of(Float.valueOf(player.method_31549().method_7253()));
                } else {
                    value = Value.NULL;
                }
                return value;
            });
            this.put("holds", (e, a) -> {
                class_1304 where = class_1304.field_6173;
                if (a != null) {
                    where = inventorySlots.get(a.getString());
                }
                if (where == null) {
                    throw new InternalExpressionException("Unknown inventory slot: " + a.getString());
                }
                if (e instanceof class_1309) {
                    class_1309 le = (class_1309)e;
                    return ValueConversions.of(le.method_6118(where), (class_5455)e.method_5682().method_30611());
                }
                return Value.NULL;
            });
            this.put("selected_slot", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof class_1657) {
                    class_1657 p = (class_1657)e;
                    numericValue = new NumericValue(p.method_31548().field_7545);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("active_block", (e, a) -> {
                if (e instanceof class_3222) {
                    class_3222 sp = (class_3222)e;
                    class_2338 pos = Vanilla.ServerPlayerGameMode_getCurrentBlockPosition(sp.field_13974);
                    if (pos == null) {
                        return Value.NULL;
                    }
                    return new BlockValue(null, sp.method_51469(), pos);
                }
                return Value.NULL;
            });
            this.put("breaking_progress", (e, a) -> {
                if (e instanceof class_3222) {
                    class_3222 sp = (class_3222)e;
                    int progress = Vanilla.ServerPlayerGameMode_getCurrentBlockBreakingProgress(sp.field_13974);
                    return progress < 0 ? Value.NULL : new NumericValue(progress);
                }
                return Value.NULL;
            });
            this.put("facing", (e, a) -> {
                int index = 0;
                if (a != null) {
                    index = (6 + (int)NumericValue.asNumber(a).getLong()) % 6;
                }
                if (index < 0 || index > 5) {
                    throw new InternalExpressionException("Facing order should be between -6 and 5");
                }
                return new StringValue(class_2350.method_10159((class_1297)e)[index].method_15434());
            });
            this.put("trace", (e, a) -> {
                Object hitres;
                float reach = 4.5f;
                boolean entities = true;
                boolean liquids = false;
                boolean blocks = true;
                boolean exact = false;
                if (a != null) {
                    if (!(a instanceof ListValue)) {
                        reach = (float)NumericValue.asNumber(a).getDouble();
                    } else {
                        ListValue lv = (ListValue)a;
                        List<Value> args = lv.getItems();
                        if (args.size() == 0) {
                            throw new InternalExpressionException("'trace' needs more arguments");
                        }
                        reach = (float)NumericValue.asNumber(args.get(0)).getDouble();
                        if (args.size() > 1) {
                            entities = false;
                            blocks = false;
                            for (int i = 1; i < args.size(); ++i) {
                                String what = args.get(i).getString();
                                if (what.equalsIgnoreCase("entities")) {
                                    entities = true;
                                    continue;
                                }
                                if (what.equalsIgnoreCase("blocks")) {
                                    blocks = true;
                                    continue;
                                }
                                if (what.equalsIgnoreCase("liquids")) {
                                    liquids = true;
                                    continue;
                                }
                                if (what.equalsIgnoreCase("exact")) {
                                    exact = true;
                                    continue;
                                }
                                throw new InternalExpressionException("Incorrect tracing: " + what);
                            }
                        }
                    }
                } else if (e instanceof class_3222) {
                    class_3222 sp = (class_3222)e;
                    if (sp.field_13974.method_14268()) {
                        reach = 5.0f;
                    }
                }
                if ((hitres = entities && !blocks ? Tracer.rayTraceEntities(e, 1.0f, reach, reach * reach) : (entities ? Tracer.rayTrace(e, 1.0f, reach, liquids) : Tracer.rayTraceBlocks(e, 1.0f, reach, liquids))) == null) {
                    return Value.NULL;
                }
                if (exact && hitres.method_17783() != class_239.class_240.field_1333) {
                    return ValueConversions.of(hitres.method_17784());
                }
                switch (hitres.method_17783()) {
                    case field_1333: {
                        return Value.NULL;
                    }
                    case field_1332: {
                        return new BlockValue((class_3218)e.method_5770(), ((class_3965)hitres).method_17777());
                    }
                    case field_1331: {
                        return new EntityValue(((class_3966)hitres).method_17782());
                    }
                }
                return Value.NULL;
            });
            this.put("attribute", (e, a) -> {
                if (!(e instanceof class_1309)) {
                    return Value.NULL;
                }
                class_1309 el = (class_1309)e;
                class_2378 attributes = e.method_37908().method_30349().method_30530(class_7924.field_41251);
                if (a == null) {
                    class_5131 container = el.method_6127();
                    return MapValue.wrap(attributes.method_10220().filter(arg_0 -> ((class_5131)container).method_27306(arg_0)).collect(Collectors.toMap(aa -> ValueConversions.of(attributes.method_10221(aa)), aa -> NumericValue.of(container.method_26852(aa)))));
                }
                class_2960 id = InputValidator.identifierOf(a.getString());
                class_1320 attrib = (class_1320)attributes.method_17966(id).orElseThrow(() -> new InternalExpressionException("Unknown attribute: " + a.getString()));
                if (!el.method_6127().method_27306(attrib)) {
                    return Value.NULL;
                }
                return NumericValue.of(el.method_26825(attrib));
            });
            this.put("nbt", (e, a) -> {
                class_2487 nbttagcompound = e.method_5647(new class_2487());
                if (a == null) {
                    return new NBTSerializableValue((class_2520)nbttagcompound);
                }
                return new NBTSerializableValue((class_2520)nbttagcompound).get((Value)a);
            });
            this.put("category", (e, a) -> new StringValue(e.method_5864().method_5891().toString().toLowerCase(Locale.ROOT)));
        }
    };
    private static final Map<String, BiConsumer<class_1297, Value>> featureModifiers = new HashMap<String, BiConsumer<class_1297, Value>>(){
        {
            this.put("remove", (entity, value) -> entity.method_31472());
            this.put("age", (e, v) -> {
                e.field_6012 = Math.abs((int)NumericValue.asNumber(v).getLong());
            });
            this.put("health", (e, v) -> {
                float health = (float)NumericValue.asNumber(v).getDouble();
                if (health <= 0.0f && e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    if (player.field_7512 != null) {
                        player.method_7346();
                    }
                    ((class_1309)e).method_6033(health);
                }
                if (e instanceof class_1309) {
                    class_1309 le = (class_1309)e;
                    le.method_6033(health);
                }
            });
            this.put("may_fly", (e, v) -> {
                boolean mayFly = v.getBoolean();
                if (e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    player.method_31549().field_7478 = mayFly;
                    if (!mayFly && player.method_31549().field_7479) {
                        player.method_31549().field_7479 = false;
                    }
                    player.method_7355();
                }
            });
            this.put("flying", (e, v) -> {
                boolean flying = v.getBoolean();
                if (e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    player.method_31549().field_7479 = flying;
                    player.method_7355();
                }
            });
            this.put("may_build", (e, v) -> {
                boolean mayBuild = v.getBoolean();
                if (e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    player.method_31549().field_7476 = mayBuild;
                    player.method_7355();
                }
            });
            this.put("insta_build", (e, v) -> {
                boolean instaBuild = v.getBoolean();
                if (e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    player.method_31549().field_7477 = instaBuild;
                    player.method_7355();
                }
            });
            this.put("fly_speed", (e, v) -> {
                float flySpeed = NumericValue.asNumber(v).getFloat();
                if (e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    player.method_31549().method_7248(flySpeed);
                    player.method_7355();
                }
            });
            this.put("walk_speed", (e, v) -> {
                float walkSpeed = NumericValue.asNumber(v).getFloat();
                if (e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    player.method_31549().method_7250(walkSpeed);
                    player.method_7355();
                }
            });
            this.put("selected_slot", (e, v) -> {
                if (e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    int slot = NumericValue.asNumber(v).getInt();
                    player.field_13987.method_14364((class_2596)new class_2735(slot));
                }
            });
            this.put("kill", (e, v) -> e.method_5768());
            this.put("location", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 5 parameters as a second argument");
                }
                ListValue lv = (ListValue)v;
                List<Value> coords = lv.getItems();
                EntityValue.updatePosition(e, NumericValue.asNumber(coords.get(0)).getDouble(), NumericValue.asNumber(coords.get(1)).getDouble(), NumericValue.asNumber(coords.get(2)).getDouble(), (float)NumericValue.asNumber(coords.get(3)).getDouble(), (float)NumericValue.asNumber(coords.get(4)).getDouble());
            });
            this.put("pos", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 3 parameters as a second argument");
                }
                ListValue lv = (ListValue)v;
                List<Value> coords = lv.getItems();
                EntityValue.updatePosition(e, NumericValue.asNumber(coords.get(0)).getDouble(), NumericValue.asNumber(coords.get(1)).getDouble(), NumericValue.asNumber(coords.get(2)).getDouble(), e.method_36454(), e.method_36455());
            });
            this.put("x", (e, v) -> EntityValue.updatePosition(e, NumericValue.asNumber(v).getDouble(), e.method_23318(), e.method_23321(), e.method_36454(), e.method_36455()));
            this.put("y", (e, v) -> EntityValue.updatePosition(e, e.method_23317(), NumericValue.asNumber(v).getDouble(), e.method_23321(), e.method_36454(), e.method_36455()));
            this.put("z", (e, v) -> EntityValue.updatePosition(e, e.method_23317(), e.method_23318(), NumericValue.asNumber(v).getDouble(), e.method_36454(), e.method_36455()));
            this.put("yaw", (e, v) -> EntityValue.updatePosition(e, e.method_23317(), e.method_23318(), e.method_23321(), (float)NumericValue.asNumber(v).getDouble() % 360.0f, e.method_36455()));
            this.put("head_yaw", (e, v) -> {
                if (e instanceof class_1309) {
                    e.method_5847((float)NumericValue.asNumber(v).getDouble() % 360.0f);
                }
            });
            this.put("body_yaw", (e, v) -> {
                if (e instanceof class_1309) {
                    e.method_36456((float)NumericValue.asNumber(v).getDouble() % 360.0f);
                }
            });
            this.put("pitch", (e, v) -> EntityValue.updatePosition(e, e.method_23317(), e.method_23318(), e.method_23321(), e.method_36454(), class_3532.method_15363((float)((float)NumericValue.asNumber(v).getDouble()), (float)-90.0f, (float)90.0f)));
            this.put("look", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 3 parameters as a second argument");
                }
                ListValue lv = (ListValue)v;
                List<Value> vec = lv.getItems();
                float x = NumericValue.asNumber(vec.get(0)).getFloat();
                float y = NumericValue.asNumber(vec.get(1)).getFloat();
                float z = NumericValue.asNumber(vec.get(2)).getFloat();
                float l = class_3532.method_15355((float)(x * x + y * y + z * z));
                if (l == 0.0f) {
                    return;
                }
                float pitch = (float)(-Math.asin(y /= l)) / ((float)Math.PI / 180);
                float yaw = (float)((x /= l) == 0.0f && z == 0.0f ? (double)e.method_36454() : class_3532.method_15349((double)(-x), (double)(z /= l)) / 0.01745329238474369);
                EntityValue.updatePosition(e, e.method_23317(), e.method_23318(), e.method_23321(), yaw, pitch);
            });
            this.put("move", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 3 parameters as a second argument");
                }
                ListValue lv = (ListValue)v;
                List<Value> coords = lv.getItems();
                EntityValue.updatePosition(e, e.method_23317() + NumericValue.asNumber(coords.get(0)).getDouble(), e.method_23318() + NumericValue.asNumber(coords.get(1)).getDouble(), e.method_23321() + NumericValue.asNumber(coords.get(2)).getDouble(), e.method_36454(), e.method_36455());
            });
            this.put("motion", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 3 parameters as a second argument");
                }
                ListValue lv = (ListValue)v;
                List<Value> coords = lv.getItems();
                double dx = NumericValue.asNumber(coords.get(0)).getDouble();
                double dy = NumericValue.asNumber(coords.get(1)).getDouble();
                double dz = NumericValue.asNumber(coords.get(2)).getDouble();
                e.method_18800(dx, dy, dz);
                EntityValue.updateVelocity(e, class_3532.method_15391((double)class_3532.method_15391((double)dx, (double)dy), (double)dz));
            });
            this.put("motion_x", (e, v) -> {
                class_243 velocity = e.method_18798();
                double dv = NumericValue.asNumber(v).getDouble();
                e.method_18800(dv, velocity.field_1351, velocity.field_1350);
                EntityValue.updateVelocity(e, dv);
            });
            this.put("motion_y", (e, v) -> {
                class_243 velocity = e.method_18798();
                double dv = NumericValue.asNumber(v).getDouble();
                e.method_18800(velocity.field_1352, dv, velocity.field_1350);
                EntityValue.updateVelocity(e, dv);
            });
            this.put("motion_z", (e, v) -> {
                class_243 velocity = e.method_18798();
                double dv = NumericValue.asNumber(v).getDouble();
                e.method_18800(velocity.field_1352, velocity.field_1351, dv);
                EntityValue.updateVelocity(e, dv);
            });
            this.put("accelerate", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 3 parameters as a second argument");
                }
                ListValue lv = (ListValue)v;
                List<Value> coords = lv.getItems();
                e.method_5762(NumericValue.asNumber(coords.get(0)).getDouble(), NumericValue.asNumber(coords.get(1)).getDouble(), NumericValue.asNumber(coords.get(2)).getDouble());
                EntityValue.updateVelocity(e, e.method_18798().method_1033());
            });
            this.put("custom_name", (e, v) -> {
                if (v.isNull()) {
                    e.method_5880(false);
                    e.method_5665(null);
                    return;
                }
                boolean showName = false;
                if (v instanceof ListValue) {
                    ListValue lv = (ListValue)v;
                    showName = lv.getItems().get(1).getBoolean();
                    v = lv.getItems().get(0);
                }
                e.method_5880(showName);
                e.method_5665(FormattedTextValue.getTextByValue(v));
            });
            this.put("persistence", (e, v) -> {
                if (!(e instanceof class_1308)) {
                    return;
                }
                class_1308 mob = (class_1308)e;
                if (v == null) {
                    v = Value.TRUE;
                }
                Vanilla.Mob_setPersistence(mob, v.getBoolean());
            });
            this.put("dismount", (e, v) -> e.method_5848());
            this.put("mount", (e, v) -> {
                if (v instanceof EntityValue) {
                    EntityValue ev = (EntityValue)v;
                    e.method_5873(ev.getEntity(), true);
                }
                if (e instanceof class_3222) {
                    class_3222 sp = (class_3222)e;
                    sp.field_13987.method_14364((class_2596)new class_2752(e));
                }
            });
            this.put("unmountable", (e, v) -> Vanilla.Entity_setPermanentVehicle(e, v == null || v.getBoolean()));
            this.put("drop_passengers", (e, v) -> e.method_5772());
            this.put("mount_passengers", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'mount_passengers' needs entities to ride");
                }
                if (v instanceof EntityValue) {
                    EntityValue ev = (EntityValue)v;
                    ev.getEntity().method_5804(e);
                } else if (v instanceof ListValue) {
                    ListValue lv = (ListValue)v;
                    for (Value element : lv.getItems()) {
                        if (!(element instanceof EntityValue)) continue;
                        EntityValue ev = (EntityValue)element;
                        ev.getEntity().method_5804(e);
                    }
                }
            });
            this.put("tag", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'tag' requires parameters");
                }
                if (v instanceof ListValue) {
                    ListValue lv = (ListValue)v;
                    for (Value element : lv.getItems()) {
                        e.method_5780(element.getString());
                    }
                } else {
                    e.method_5780(v.getString());
                }
            });
            this.put("clear_tag", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'clear_tag' requires parameters");
                }
                if (v instanceof ListValue) {
                    ListValue lv = (ListValue)v;
                    for (Value element : lv.getItems()) {
                        e.method_5738(element.getString());
                    }
                } else {
                    e.method_5738(v.getString());
                }
            });
            this.put("breeding_age", (e, v) -> {
                if (e instanceof class_1296) {
                    class_1296 am = (class_1296)e;
                    am.method_5614((int)NumericValue.asNumber(v).getLong());
                }
            });
            this.put("talk", (e, v) -> {
                if (e instanceof class_1308) {
                    class_1308 mob = (class_1308)e;
                    mob.method_5966();
                }
            });
            this.put("home", (e, v) -> {
                class_2338 pos;
                if (!(e instanceof class_1314)) {
                    return;
                }
                class_1314 ec = (class_1314)e;
                if (v == null) {
                    throw new InternalExpressionException("'home' requires at least one position argument, and optional distance, or null to cancel");
                }
                if (v.isNull()) {
                    ec.method_18408(class_2338.field_10980, -1);
                    Map<String, class_1352> tasks = Vanilla.Mob_getTemporaryTasks((class_1308)ec);
                    Vanilla.Mob_getAI((class_1308)ec, false).method_6280(tasks.get("home"));
                    tasks.remove("home");
                    return;
                }
                int distance = 16;
                if (v instanceof BlockValue) {
                    BlockValue bv = (BlockValue)v;
                    pos = bv.getPos();
                    if (pos == null) {
                        throw new InternalExpressionException("Block is not positioned in the world");
                    }
                } else if (v instanceof ListValue) {
                    ListValue lv = (ListValue)v;
                    List<Value> list = lv.getItems();
                    Vector3Argument locator = Vector3Argument.findIn(list, 0, false, false);
                    pos = class_2338.method_49637((double)locator.vec.field_1352, (double)locator.vec.field_1351, (double)locator.vec.field_1350);
                    if (list.size() > locator.offset) {
                        distance = (int)NumericValue.asNumber(list.get(locator.offset)).getLong();
                    }
                } else {
                    throw new InternalExpressionException("'home' requires at least one position argument, and optional distance");
                }
                ec.method_18408(pos, distance);
                Map<String, class_1352> tasks = Vanilla.Mob_getTemporaryTasks((class_1308)ec);
                if (!tasks.containsKey("home")) {
                    class_1370 task = new class_1370(ec, 1.0);
                    tasks.put("home", (class_1352)task);
                    Vanilla.Mob_getAI((class_1308)ec, false).method_6277(10, (class_1352)task);
                }
            });
            this.put("spawn_point", (e, a) -> {
                if (!(e instanceof class_3222)) {
                    return;
                }
                class_3222 spe = (class_3222)e;
                if (a == null) {
                    spe.method_26284(null, null, 0.0f, false, false);
                } else if (a instanceof ListValue) {
                    ListValue lv = (ListValue)a;
                    List<Value> params = lv.getItems();
                    Vector3Argument blockLocator = Vector3Argument.findIn(params, 0, false, false);
                    class_2338 pos = class_2338.method_49638((class_2374)blockLocator.vec);
                    class_5321 world = spe.method_5770().method_27983();
                    float angle = spe.method_5791();
                    boolean forced = false;
                    if (params.size() > blockLocator.offset) {
                        Value worldValue = params.get(blockLocator.offset + 0);
                        world = ValueConversions.dimFromValue(worldValue, spe.method_5682()).method_27983();
                        if (params.size() > blockLocator.offset + 1) {
                            angle = NumericValue.asNumber(params.get(blockLocator.offset + 1), "angle").getFloat();
                            if (params.size() > blockLocator.offset + 2) {
                                forced = params.get(blockLocator.offset + 2).getBoolean();
                            }
                        }
                    }
                    spe.method_26284(world, pos, angle, forced, false);
                } else if (a instanceof BlockValue) {
                    BlockValue bv = (BlockValue)a;
                    if (bv.getPos() == null || bv.getWorld() == null) {
                        throw new InternalExpressionException("block for spawn modification should be localised in the world");
                    }
                    spe.method_26284(bv.getWorld().method_27983(), bv.getPos(), e.method_36454(), true, false);
                } else if (a.isNull()) {
                    spe.method_26284(null, null, 0.0f, false, false);
                } else {
                    throw new InternalExpressionException("modifying player respawn point requires a block position, optional world, optional angle, and optional force");
                }
            });
            this.put("pickup_delay", (e, v) -> {
                if (e instanceof class_1542) {
                    class_1542 ie = (class_1542)e;
                    ie.method_6982((int)NumericValue.asNumber(v).getLong());
                }
            });
            this.put("despawn_timer", (e, v) -> {
                if (e instanceof class_1309) {
                    class_1309 le = (class_1309)e;
                    le.method_16826((int)NumericValue.asNumber(v).getLong());
                }
            });
            this.put("portal_cooldown", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'portal_cooldown' requires a value to set");
                }
                Vanilla.Entity_setPublicNetherPortalCooldown(e, NumericValue.asNumber(v).getInt());
            });
            this.put("portal_timer", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'portal_timer' requires a value to set");
                }
                Vanilla.Entity_setPortalTimer(e, NumericValue.asNumber(v).getInt());
            });
            this.put("ai", (e, v) -> {
                if (e instanceof class_1308) {
                    class_1308 mob = (class_1308)e;
                    mob.method_5977(!v.getBoolean());
                }
            });
            this.put("no_clip", (e, v) -> {
                e.field_5960 = v == null ? true : v.getBoolean();
            });
            this.put("effect", (e, v) -> {
                if (!(e instanceof class_1309)) {
                    return;
                }
                class_1309 le = (class_1309)e;
                if (v == null) {
                    le.method_6012();
                    return;
                }
                if (v instanceof ListValue) {
                    ListValue lv = (ListValue)v;
                    List<Value> list = lv.getItems();
                    if (list.size() >= 1 && list.size() <= 6) {
                        String effectName = list.get(0).getString();
                        class_1291 effect = (class_1291)class_7923.field_41174.method_10223(InputValidator.identifierOf(effectName));
                        if (effect == null) {
                            throw new InternalExpressionException("Wrong effect name: " + effectName);
                        }
                        if (list.size() == 1) {
                            le.method_6016(effect);
                            return;
                        }
                        int duration = (int)NumericValue.asNumber(list.get(1)).getLong();
                        if (duration <= 0) {
                            le.method_6016(effect);
                            return;
                        }
                        int amplifier = 0;
                        if (list.size() > 2) {
                            amplifier = (int)NumericValue.asNumber(list.get(2)).getLong();
                        }
                        boolean showParticles = true;
                        if (list.size() > 3) {
                            showParticles = list.get(3).getBoolean();
                        }
                        boolean showIcon = true;
                        if (list.size() > 4) {
                            showIcon = list.get(4).getBoolean();
                        }
                        boolean ambient = false;
                        if (list.size() > 5) {
                            ambient = list.get(5).getBoolean();
                        }
                        le.method_6092(new class_1293(effect, duration, amplifier, ambient, showParticles, showIcon));
                        return;
                    }
                } else {
                    String effectName = v.getString();
                    class_1291 effect = (class_1291)class_7923.field_41174.method_10223(InputValidator.identifierOf(effectName));
                    if (effect == null) {
                        throw new InternalExpressionException("Wrong effect name: " + effectName);
                    }
                    le.method_6016(effect);
                    return;
                }
                throw new InternalExpressionException("'effect' needs either no arguments (clear) or effect name, duration, and optional amplifier, show particles, show icon and ambient");
            });
            this.put("gamemode", (e, v) -> {
                class_1934 toSet;
                if (!(e instanceof class_3222)) {
                    return;
                }
                class_3222 sp = (class_3222)e;
                class_1934 class_19342 = toSet = v instanceof NumericValue ? class_1934.method_8384((int)((NumericValue)v).getInt()) : class_1934.method_8378((String)v.getString().toLowerCase(Locale.ROOT), null);
                if (toSet != null) {
                    sp.method_7336(toSet);
                }
            });
            this.put("jumping", (e, v) -> {
                if (!(e instanceof class_1309)) {
                    return;
                }
                class_1309 le = (class_1309)e;
                le.method_6100(v.getBoolean());
            });
            this.put("jump", (e, v) -> {
                if (e instanceof class_1309) {
                    class_1309 le = (class_1309)e;
                    Vanilla.LivingEntity_setJumping(le);
                } else {
                    EntityTools.genericJump(e);
                }
            });
            this.put("swing", (e, v) -> {
                if (e instanceof class_1309) {
                    String handString;
                    class_1309 le = (class_1309)e;
                    class_1268 hand = class_1268.field_5808;
                    if (v != null && ((handString = v.getString().toLowerCase(Locale.ROOT)).equals("offhand") || handString.equals("off_hand"))) {
                        hand = class_1268.field_5810;
                    }
                    le.method_23667(hand, true);
                }
            });
            this.put("silent", (e, v) -> e.method_5803(v.getBoolean()));
            this.put("gravity", (e, v) -> e.method_5875(!v.getBoolean()));
            this.put("invulnerable", (e, v) -> {
                boolean invulnerable = v.getBoolean();
                if (e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    player.method_31549().field_7480 = invulnerable;
                    player.method_7355();
                } else {
                    e.method_5684(invulnerable);
                }
            });
            this.put("fire", (e, v) -> e.method_20803((int)NumericValue.asNumber(v).getLong()));
            this.put("frost", (e, v) -> e.method_32317((int)NumericValue.asNumber(v).getLong()));
            this.put("hunger", (e, v) -> {
                if (e instanceof class_1657) {
                    class_1657 p = (class_1657)e;
                    p.method_7344().method_7580((int)NumericValue.asNumber(v).getLong());
                }
            });
            this.put("exhaustion", (e, v) -> {
                if (e instanceof class_1657) {
                    class_1657 p = (class_1657)e;
                    p.method_7344().method_35218(NumericValue.asNumber(v).getFloat());
                }
            });
            this.put("add_exhaustion", (e, v) -> {
                if (e instanceof class_1657) {
                    class_1657 p = (class_1657)e;
                    p.method_7344().method_7583(NumericValue.asNumber(v).getFloat());
                }
            });
            this.put("absorption", (e, v) -> {
                if (e instanceof class_1657) {
                    class_1657 p = (class_1657)e;
                    p.method_6073(NumericValue.asNumber(v, "absorbtion").getFloat());
                }
            });
            this.put("add_xp", (e, v) -> {
                if (e instanceof class_1657) {
                    class_1657 p = (class_1657)e;
                    p.method_7255(NumericValue.asNumber(v, "add_xp").getInt());
                }
            });
            this.put("xp_level", (e, v) -> {
                if (e instanceof class_1657) {
                    class_1657 p = (class_1657)e;
                    p.method_7316(NumericValue.asNumber(v, "xp_level").getInt() - p.field_7520);
                }
            });
            this.put("xp_progress", (e, v) -> {
                if (e instanceof class_3222) {
                    class_3222 p = (class_3222)e;
                    p.field_7510 = NumericValue.asNumber(v, "xp_progress").getFloat();
                    p.field_13987.method_14364((class_2596)new class_2748(p.field_7510, p.field_7495, p.field_7520));
                }
            });
            this.put("xp_score", (e, v) -> {
                if (e instanceof class_1657) {
                    class_1657 p = (class_1657)e;
                    p.method_7320(NumericValue.asNumber(v, "xp_score").getInt());
                }
            });
            this.put("saturation", (e, v) -> {
                if (e instanceof class_1657) {
                    class_1657 p = (class_1657)e;
                    p.method_7344().method_7581(NumericValue.asNumber(v, "saturation").getFloat());
                }
            });
            this.put("air", (e, v) -> e.method_5855(NumericValue.asNumber(v, "air").getInt()));
            this.put("breaking_progress", (e, a) -> {
                if (e instanceof class_3222) {
                    class_3222 sp = (class_3222)e;
                    int progress = a == null || a.isNull() ? -1 : NumericValue.asNumber(a).getInt();
                    Vanilla.ServerPlayerGameMode_setBlockBreakingProgress(sp.field_13974, progress);
                }
            });
            this.put("nbt", (e, v) -> {
                if (!(e instanceof class_1657)) {
                    UUID uUID = e.method_5667();
                    Value tagValue = NBTSerializableValue.fromValue(v);
                    if (tagValue instanceof NBTSerializableValue) {
                        NBTSerializableValue nbtsv = (NBTSerializableValue)tagValue;
                        e.method_5651(nbtsv.getCompoundTag());
                        e.method_5826(uUID);
                    }
                }
            });
            this.put("nbt_merge", (e, v) -> {
                if (!(e instanceof class_1657)) {
                    UUID uUID = e.method_5667();
                    Value tagValue = NBTSerializableValue.fromValue(v);
                    if (tagValue instanceof NBTSerializableValue) {
                        NBTSerializableValue nbtsv = (NBTSerializableValue)tagValue;
                        class_2487 nbttagcompound = e.method_5647(new class_2487());
                        nbttagcompound.method_10543(nbtsv.getCompoundTag());
                        e.method_5651(nbttagcompound);
                        e.method_5826(uUID);
                    }
                }
            });
            this.put("blue_skull", (e, v) -> {
                if (e instanceof class_1687) {
                    class_1687 w = (class_1687)e;
                    w.method_7502(v.getBoolean());
                }
            });
            this.put("offering_flower", (e, v) -> {
                if (e instanceof class_1439) {
                    class_1439 ig = (class_1439)e;
                    ig.method_6497(v.getBoolean());
                }
            });
            this.put("item", (e, v) -> {
                class_1799 item = ValueConversions.getItemStackFromValue(v, true, e.method_37908().method_30349());
                if (e instanceof class_1542) {
                    class_1542 itementity = (class_1542)e;
                    itementity.method_6979(item);
                }
                if (e instanceof class_1533) {
                    class_1533 itemframe = (class_1533)e;
                    itemframe.method_6935(item);
                }
            });
        }
    };

    public EntityValue(class_1297 e) {
        this.entity = e;
    }

    public static Value of(@Nullable class_1297 e) {
        return e == null ? Value.NULL : new EntityValue(e);
    }

    public static Collection<? extends class_1297> getEntitiesFromSelector(class_2168 source, String selector) {
        try {
            class_2300 entitySelector = selectorCache.get(selector);
            if (entitySelector != null) {
                return entitySelector.method_9816(source.method_9230(4));
            }
            entitySelector = new class_2303(new StringReader(selector), true).method_9882();
            selectorCache.put(selector, entitySelector);
            return entitySelector.method_9816(source.method_9230(4));
        }
        catch (CommandSyntaxException e) {
            throw new InternalExpressionException("Cannot select entities from " + selector);
        }
    }

    public class_1297 getEntity() {
        class_3222 newPlayer;
        class_3222 serverPlayer;
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_3222 && Vanilla.ServerPlayer_isInvalidEntityObject(serverPlayer = (class_3222)class_12972) && (newPlayer = this.entity.method_5682().method_3760().method_14602(this.entity.method_5667())) != null) {
            this.entity = newPlayer;
        }
        return this.entity;
    }

    public static class_3222 getPlayerByValue(MinecraftServer server, Value value) {
        EntityValue ev;
        class_1297 class_12972;
        if (value instanceof EntityValue && (class_12972 = (ev = (EntityValue)value).getEntity()) instanceof class_3222) {
            class_3222 sp = (class_3222)class_12972;
            return sp;
        }
        if (value.isNull()) {
            return null;
        }
        String playerName = value.getString();
        return server.method_3760().method_14566(playerName);
    }

    public static String getPlayerNameByValue(Value value) {
        EntityValue ev;
        class_1297 class_12972;
        if (value instanceof EntityValue && (class_12972 = (ev = (EntityValue)value).getEntity()) instanceof class_3222) {
            class_3222 sp = (class_3222)class_12972;
            return sp.method_5820();
        }
        if (value.isNull()) {
            return null;
        }
        return value.getString();
    }

    @Override
    public String getString() {
        return this.getEntity().method_5477().getString();
    }

    @Override
    public boolean getBoolean() {
        return true;
    }

    @Override
    public boolean equals(Object v) {
        if (v instanceof EntityValue) {
            EntityValue ev = (EntityValue)v;
            return this.getEntity().method_5628() == ev.getEntity().method_5628();
        }
        return super.equals(v);
    }

    @Override
    public Value in(Value v) {
        if (v instanceof ListValue) {
            ListValue lv = (ListValue)v;
            List<Value> values = lv.getItems();
            String what = values.get(0).getString();
            Value arg = null;
            if (values.size() == 2) {
                arg = values.get(1);
            } else if (values.size() > 2) {
                arg = ListValue.wrap(values.subList(1, values.size()));
            }
            return this.get(what, arg);
        }
        String what = v.getString();
        return this.get(what, null);
    }

    @Override
    public String getTypeString() {
        return "entity";
    }

    @Override
    public int hashCode() {
        return this.getEntity().hashCode();
    }

    public static EntityClassDescriptor getEntityDescriptor(String who, MinecraftServer server) {
        EntityClassDescriptor eDesc = EntityClassDescriptor.byName.get(who);
        if (eDesc == null) {
            boolean positive = true;
            if (who.startsWith("!")) {
                positive = false;
                who = who.substring(1);
            }
            String booWho = who;
            class_6885.class_6888 eTagValue = (class_6885.class_6888)server.method_30611().method_30530(class_7924.field_41266).method_40266(class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)InputValidator.identifierOf(who))).orElseThrow(() -> new InternalExpressionException(booWho + " is not a valid entity descriptor"));
            Set eTag = eTagValue.method_40239().map(class_6880::comp_349).collect(Collectors.toUnmodifiableSet());
            if (positive) {
                if (eTag.size() == 1) {
                    class_1299 type = (class_1299)eTag.iterator().next();
                    return new EntityClassDescriptor((class_5575<class_1297, ?>)type, (Predicate<? super class_1297>)((Predicate<class_1297>)class_1297::method_5805), eTag.stream());
                }
                return new EntityClassDescriptor(ANY, e -> eTag.contains(e.method_5864()) && e.method_5805(), eTag.stream());
            }
            return new EntityClassDescriptor(ANY, e -> !eTag.contains(e.method_5864()) && e.method_5805(), server.method_30611().method_30530(class_7924.field_41266).method_10220().filter(et -> !eTag.contains(et)));
        }
        return eDesc;
    }

    public Value get(String what, @Nullable Value arg) {
        if (!featureAccessors.containsKey(what)) {
            throw new InternalExpressionException("Unknown entity feature: " + what);
        }
        try {
            return featureAccessors.get(what).apply(this.getEntity(), arg);
        }
        catch (NullPointerException npe) {
            throw new InternalExpressionException("Cannot fetch '" + what + "' with these arguments");
        }
    }

    public void set(String what, @Nullable Value toWhat) {
        if (!featureModifiers.containsKey(what)) {
            throw new InternalExpressionException("Unknown entity action: " + what);
        }
        try {
            featureModifiers.get(what).accept(this.getEntity(), toWhat);
        }
        catch (NullPointerException npe) {
            throw new InternalExpressionException("'modify' for '" + what + "' expects a value");
        }
        catch (IndexOutOfBoundsException ind) {
            throw new InternalExpressionException("Wrong number of arguments for `modify` option: " + what);
        }
    }

    private static void updatePosition(class_1297 e, double x, double y, double z, float yaw, float pitch) {
        if (!Double.isFinite(x) || Double.isNaN(x) || !Double.isFinite(y) || Double.isNaN(y) || !Double.isFinite(z) || Double.isNaN(z) || !Float.isFinite(yaw) || Float.isNaN(yaw) || !Float.isFinite(pitch) || Float.isNaN(pitch)) {
            return;
        }
        if (e instanceof class_3222) {
            class_3222 sp = (class_3222)e;
            EnumSet<class_2709> set = EnumSet.noneOf(class_2709.class);
            set.add(class_2709.field_12397);
            set.add(class_2709.field_12401);
            sp.field_13987.method_14360(x, y, z, yaw, pitch, set);
        } else {
            e.method_5808(x, y, z, yaw, pitch);
            if (e instanceof class_1309) {
                class_1309 le = (class_1309)e;
                le.field_6220 = le.field_5982 = yaw;
                le.field_6259 = le.field_6241 = yaw;
            } else {
                ((class_3218)e.method_5770()).method_14178().method_18751(e, (class_2596)new class_2777(e));
            }
        }
    }

    private static void updateVelocity(class_1297 e, double scale) {
        e.field_6037 = true;
        if (Math.abs(scale) > 10000.0) {
            CarpetScriptServer.LOG.warn("Moved entity " + e.method_5820() + " " + e.method_5477() + " at " + e.method_19538() + " extremely fast: " + e.method_18798());
        }
    }

    public void setEvent(CarpetContext cc, String eventName, FunctionValue fun, List<Value> args) {
        EntityEventsGroup.Event event = EntityEventsGroup.Event.byName.get(eventName);
        if (event == null) {
            throw new InternalExpressionException("Unknown entity event: " + eventName);
        }
        Vanilla.Entity_getEventContainer(this.getEntity()).addEvent(event, cc.host, fun, args);
    }

    @Override
    public class_2520 toTag(boolean force) {
        if (!force) {
            throw new NBTSerializableValue.IncompatibleTypeException(this);
        }
        class_2487 tag = new class_2487();
        tag.method_10566("Data", (class_2520)this.getEntity().method_5647(new class_2487()));
        class_2378 reg = this.getEntity().method_37908().method_30349().method_30530(class_7924.field_41266);
        tag.method_10566("Name", (class_2520)class_2519.method_23256((String)reg.method_10221((Object)this.getEntity().method_5864()).toString()));
        return tag;
    }

    public static class EntityClassDescriptor {
        public final class_5575<class_1297, ? extends class_1297> directType;
        public final Predicate<? super class_1297> filteringPredicate;
        public final List<class_1299<? extends class_1297>> types;
        public static final Map<String, EntityClassDescriptor> byName = new HashMap<String, EntityClassDescriptor>(){
            {
                List<class_1299<?>> allTypes = class_7923.field_41177.method_10220().toList();
                Set<class_1299> projectiles = Set.of(class_1299.field_6122, class_1299.field_6129, class_1299.field_6133, class_1299.field_6066, class_1299.field_6124, class_1299.field_6049, class_1299.field_6068, class_1299.field_6135, class_1299.field_6144, class_1299.field_6082, class_1299.field_6064, class_1299.field_6045, class_1299.field_6127, class_1299.field_6130, class_1299.field_6103, class_1299.field_6100);
                Set<class_1299> deads = Set.of(class_1299.field_6083, class_1299.field_33456, class_1299.field_6121, class_1299.field_6110, class_1299.field_6060, class_1299.field_6044, class_1299.field_6061, class_1299.field_6089, class_1299.field_6052, class_1299.field_6043, class_1299.field_28401, class_1299.field_6138, class_1299.field_6112, class_1299.field_6120, class_1299.field_6063, class_1299.field_6131, class_1299.field_38096);
                Set<class_1299> minecarts = Set.of(class_1299.field_6096, class_1299.field_6126, class_1299.field_6136, class_1299.field_6080, class_1299.field_6058, class_1299.field_6142, class_1299.field_6053);
                Set<class_1299> undeads = Set.of(class_1299.field_6098, class_1299.field_6137, class_1299.field_6076, class_1299.field_6051, class_1299.field_6123, class_1299.field_6054, class_1299.field_6048, class_1299.field_6075, class_1299.field_6078, class_1299.field_6119, class_1299.field_23696, class_1299.field_6071, class_1299.field_6050);
                Set<class_1299> arthropods = Set.of(class_1299.field_20346, class_1299.field_6128, class_1299.field_6125, class_1299.field_6079, class_1299.field_6084);
                Set<class_1299> aquatique = Set.of(class_1299.field_6118, class_1299.field_6113, class_1299.field_6070, class_1299.field_6087, class_1299.field_6062, class_1299.field_6073, class_1299.field_6114, class_1299.field_6111);
                Set<class_1299> illagers = Set.of(class_1299.field_6105, class_1299.field_6065, class_1299.field_6117, class_1299.field_6090, class_1299.field_6134, class_1299.field_6145);
                Set living = allTypes.stream().filter(et -> !deads.contains(et) && !projectiles.contains(et) && !minecarts.contains(et)).collect(Collectors.toSet());
                Set regular = allTypes.stream().filter(et -> living.contains(et) && !undeads.contains(et) && !arthropods.contains(et) && !aquatique.contains(et) && !illagers.contains(et)).collect(Collectors.toSet());
                this.put("*", new EntityClassDescriptor(ANY, e -> true, allTypes));
                this.put("valid", new EntityClassDescriptor(ANY, (Predicate<? super class_1297>)class_1301.field_6154, allTypes));
                this.put("!valid", new EntityClassDescriptor(ANY, e -> !e.method_5805(), allTypes));
                this.put("living", new EntityClassDescriptor(class_5575.method_31795(class_1309.class), (Predicate<? super class_1297>)class_1301.field_6154, allTypes.stream().filter(living::contains)));
                this.put("!living", new EntityClassDescriptor(ANY, e -> !(e instanceof class_1309) && e.method_5805(), allTypes.stream().filter(et -> !living.contains(et))));
                this.put("projectile", new EntityClassDescriptor(class_5575.method_31795(class_1676.class), (Predicate<? super class_1297>)class_1301.field_6154, allTypes.stream().filter(projectiles::contains)));
                this.put("!projectile", new EntityClassDescriptor(ANY, e -> !(e instanceof class_1676) && e.method_5805(), allTypes.stream().filter(et -> !projectiles.contains(et) && !living.contains(et))));
                this.put("minecarts", new EntityClassDescriptor(class_5575.method_31795(class_1688.class), (Predicate<? super class_1297>)class_1301.field_6154, allTypes.stream().filter(minecarts::contains)));
                this.put("!minecarts", new EntityClassDescriptor(ANY, e -> !(e instanceof class_1688) && e.method_5805(), allTypes.stream().filter(et -> !minecarts.contains(et) && !living.contains(et))));
                this.put("arthropod", new EntityClassDescriptor(class_5575.method_31795(class_1309.class), e -> ((class_1309)e).method_6046() == class_1310.field_6293 && e.method_5805(), allTypes.stream().filter(arthropods::contains)));
                this.put("!arthropod", new EntityClassDescriptor(class_5575.method_31795(class_1309.class), e -> ((class_1309)e).method_6046() != class_1310.field_6293 && e.method_5805(), allTypes.stream().filter(et -> !arthropods.contains(et) && living.contains(et))));
                this.put("undead", new EntityClassDescriptor(class_5575.method_31795(class_1309.class), e -> ((class_1309)e).method_6046() == class_1310.field_6289 && e.method_5805(), allTypes.stream().filter(undeads::contains)));
                this.put("!undead", new EntityClassDescriptor(class_5575.method_31795(class_1309.class), e -> ((class_1309)e).method_6046() != class_1310.field_6289 && e.method_5805(), allTypes.stream().filter(et -> !undeads.contains(et) && living.contains(et))));
                this.put("aquatic", new EntityClassDescriptor(class_5575.method_31795(class_1309.class), e -> ((class_1309)e).method_6046() == class_1310.field_6292 && e.method_5805(), allTypes.stream().filter(aquatique::contains)));
                this.put("!aquatic", new EntityClassDescriptor(class_5575.method_31795(class_1309.class), e -> ((class_1309)e).method_6046() != class_1310.field_6292 && e.method_5805(), allTypes.stream().filter(et -> !aquatique.contains(et) && living.contains(et))));
                this.put("illager", new EntityClassDescriptor(class_5575.method_31795(class_1309.class), e -> ((class_1309)e).method_6046() == class_1310.field_6291 && e.method_5805(), allTypes.stream().filter(illagers::contains)));
                this.put("!illager", new EntityClassDescriptor(class_5575.method_31795(class_1309.class), e -> ((class_1309)e).method_6046() != class_1310.field_6291 && e.method_5805(), allTypes.stream().filter(et -> !illagers.contains(et) && living.contains(et))));
                this.put("regular", new EntityClassDescriptor(class_5575.method_31795(class_1309.class), e -> ((class_1309)e).method_6046() == class_1310.field_6290 && e.method_5805(), allTypes.stream().filter(regular::contains)));
                this.put("!regular", new EntityClassDescriptor(class_5575.method_31795(class_1309.class), e -> ((class_1309)e).method_6046() != class_1310.field_6290 && e.method_5805(), allTypes.stream().filter(et -> !regular.contains(et) && living.contains(et))));
                for (class_2960 typeId : class_7923.field_41177.method_10235()) {
                    class_1299 type = (class_1299)class_7923.field_41177.method_10223(typeId);
                    String mobType = ValueConversions.simplify(typeId);
                    this.put(mobType, new EntityClassDescriptor((class_5575<class_1297, ?>)type, (Predicate<? super class_1297>)class_1301.field_6154, Stream.of(type)));
                    this.put("!" + mobType, new EntityClassDescriptor(ANY, e -> e.method_5864() != type && e.method_5805(), allTypes.stream().filter(et -> et != type)));
                }
                for (class_1311 catId : class_1311.values()) {
                    String catStr = catId.method_6133();
                    this.put(catStr, new EntityClassDescriptor(ANY, e -> e.method_5864().method_5891() == catId && e.method_5805(), allTypes.stream().filter(et -> et.method_5891() == catId)));
                    this.put("!" + catStr, new EntityClassDescriptor(ANY, e -> e.method_5864().method_5891() != catId && e.method_5805(), allTypes.stream().filter(et -> et.method_5891() != catId)));
                }
            }
        };

        EntityClassDescriptor(class_5575<class_1297, ?> type, Predicate<? super class_1297> predicate, List<class_1299<?>> types) {
            this.directType = type;
            this.filteringPredicate = predicate;
            this.types = types;
        }

        EntityClassDescriptor(class_5575<class_1297, ?> type, Predicate<? super class_1297> predicate, Stream<class_1299<?>> types) {
            this(type, predicate, types.toList());
        }

        public Value listValue(class_5455 regs) {
            class_2378 entityRegs = regs.method_30530(class_7924.field_41266);
            return ListValue.wrap(this.types.stream().map(et -> NBTSerializableValue.nameFromRegistryId(entityRegs.method_10221(et))));
        }
    }
}

