/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.dataproviders;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.network.IPluginChannelHandler;
import fi.dy.masa.servux.network.ServerPacketChannelHandler;
import fi.dy.masa.servux.util.JsonUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.server.MinecraftServer;

public class DataProviderManager {
    public static final DataProviderManager INSTANCE = new DataProviderManager();
    protected final HashMap<String, IDataProvider> providers = new HashMap();
    protected ImmutableList<IDataProvider> providersImmutable = ImmutableList.of();
    protected ArrayList<IDataProvider> providersTicking = new ArrayList();

    public ImmutableList<IDataProvider> getAllProviders() {
        return this.providersImmutable;
    }

    public boolean registerDataProvider(IDataProvider provider) {
        String name = provider.getName();
        if (!this.providers.containsKey(name)) {
            this.providers.put(name, provider);
            this.providersImmutable = ImmutableList.copyOf(this.providers.values());
            return true;
        }
        return false;
    }

    public boolean setProviderEnabled(String providerName, boolean enabled) {
        IDataProvider provider = this.providers.get(providerName);
        return provider != null && this.setProviderEnabled(provider, enabled);
    }

    public boolean setProviderEnabled(IDataProvider provider, boolean enabled) {
        boolean wasEnabled = provider.isEnabled();
        enabled = true;
        if (enabled || wasEnabled != enabled) {
            provider.setEnabled(enabled);
            this.updatePacketHandlerRegistration(provider);
            if (enabled && provider.shouldTick() && !this.providersTicking.contains(provider)) {
                this.providersTicking.add(provider);
            } else {
                this.providersTicking.remove(provider);
            }
            return true;
        }
        return false;
    }

    public void tickProviders(MinecraftServer server, int tickCounter) {
        if (!this.providersTicking.isEmpty()) {
            for (IDataProvider provider : this.providersTicking) {
                if (tickCounter % provider.getTickRate() != 0) continue;
                provider.tick(server, tickCounter);
            }
        }
    }

    protected void registerEnabledPacketHandlers() {
        for (IDataProvider provider : this.providersImmutable) {
            this.updatePacketHandlerRegistration(provider);
        }
    }

    protected void updatePacketHandlerRegistration(IDataProvider provider) {
        IPluginChannelHandler handler = provider.getPacketHandler();
        if (provider.isEnabled()) {
            ServerPacketChannelHandler.INSTANCE.registerServerChannelHandler(handler);
        } else {
            ServerPacketChannelHandler.INSTANCE.unregisterServerChannelHandler(handler);
        }
    }

    public void readFromConfig() {
        JsonObject root;
        JsonElement el = JsonUtils.parseJsonFile(this.getConfigFile());
        JsonObject obj = null;
        if (el != null && el.isJsonObject() && JsonUtils.hasObject(root = el.getAsJsonObject(), "DataProviderToggles")) {
            obj = JsonUtils.getNestedObject(root, "DataProviderToggles", false);
        }
        for (IDataProvider provider : this.providersImmutable) {
            String name = provider.getName();
            boolean enabled = obj != null && JsonUtils.getBooleanOrDefault(obj, name, false);
            this.setProviderEnabled(provider, enabled);
        }
    }

    public void writeToConfig() {
        JsonObject root = new JsonObject();
        JsonObject objToggles = new JsonObject();
        for (IDataProvider provider : this.providersImmutable) {
            String name = provider.getName();
            objToggles.add(name, (JsonElement)new JsonPrimitive(Boolean.valueOf(provider.isEnabled())));
        }
        root.add("DataProviderToggles", (JsonElement)objToggles);
        JsonUtils.writeJsonToFile((JsonElement)root, this.getConfigFile());
    }

    protected File getConfigFile() {
        return new File("servux.json");
    }
}

