/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.script.CarpetScriptServer;
import carpet.script.external.Vanilla;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3179;
import net.minecraft.class_3195;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3449;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_4643;
import net.minecraft.class_4646;
import net.minecraft.class_4647;
import net.minecraft.class_4651;
import net.minecraft.class_4659;
import net.minecraft.class_5140;
import net.minecraft.class_5141;
import net.minecraft.class_5201;
import net.minecraft.class_5204;
import net.minecraft.class_5207;
import net.minecraft.class_5212;
import net.minecraft.class_5281;
import net.minecraft.class_5434;
import net.minecraft.class_5455;
import net.minecraft.class_5468;
import net.minecraft.class_5469;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5843;
import net.minecraft.class_5847;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6121;
import net.minecraft.class_6122;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6817;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6908;
import net.minecraft.class_7138;
import net.minecraft.class_7151;
import net.minecraft.class_7225;
import net.minecraft.class_7869;
import net.minecraft.class_7924;

public class FeatureGenerator {
    public static final Map<String, Function<class_3218, Thing>> featureMap = new HashMap<String, Function<class_3218, Thing>>(){
        {
            this.put("oak_bees", l -> FeatureGenerator.simpleTree(FeatureGenerator.createTree(class_2246.field_10431, class_2246.field_10503, 4, 2, 0, 2).method_27374().method_27376(List.of(new class_4659(1.0f))).method_23445()));
            this.put("fancy_oak_bees", l -> FeatureGenerator.simpleTree(new class_4643.class_4644((class_4651)class_4651.method_38432((class_2248)class_2246.field_10431), (class_5141)new class_5212(3, 11, 0), (class_4651)class_4651.method_38432((class_2248)class_2246.field_10503), (class_4647)new class_5207((class_6017)class_6016.method_34998((int)2), (class_6017)class_6016.method_34998((int)4), 4), (class_5201)new class_5204(0, 0, 0, OptionalInt.of(4))).method_27374().method_27376(List.of(new class_4659(1.0f))).method_23445()));
            this.put("birch_bees", l -> FeatureGenerator.simpleTree(FeatureGenerator.createTree(class_2246.field_10511, class_2246.field_10539, 5, 2, 0, 2).method_27374().method_27376(List.of(new class_4659(1.0f))).method_23445()));
            this.put("coral_tree", l -> FeatureGenerator.simplePlop(class_3031.field_13525, class_3037.field_13603));
            this.put("coral_claw", l -> FeatureGenerator.simplePlop(class_3031.field_13546, class_3037.field_13603));
            this.put("coral_mushroom", l -> FeatureGenerator.simplePlop(class_3031.field_13585, class_3037.field_13603));
            this.put("coral", l -> FeatureGenerator.simplePlop(class_3031.field_13555, new class_3179((class_6885)class_6885.method_40246((class_6880[])new class_6880[]{class_6817.method_40368((class_3031)class_3031.field_13525, (class_3037)class_3037.field_13603, (class_6797[])new class_6797[0]), class_6817.method_40368((class_3031)class_3031.field_13546, (class_3037)class_3037.field_13603, (class_6797[])new class_6797[0]), class_6817.method_40368((class_3031)class_3031.field_13585, (class_3037)class_3037.field_13603, (class_6797[])new class_6797[0])}))));
            this.put("bastion_remnant_units", l -> {
                class_5455 regs = l.method_30349();
                class_7225.class_7226 processorLists = regs.method_46762(class_7924.field_41247);
                class_6880.class_6883 bastionGenericDegradation = processorLists.method_46747(class_5469.field_26280);
                class_7225.class_7226 pools = regs.method_46762(class_7924.field_41249);
                class_6880.class_6883 empty = pools.method_46747(class_5468.field_26254);
                return FeatureGenerator.spawnCustomStructure((class_3195)new class_5434(new class_3195.class_7302((class_6885)l.method_30349().method_30530(class_7924.field_41236).method_40260(class_6908.field_36505), Map.of(), class_2893.class_2895.field_13173, class_5847.field_28922), class_6880.method_40223((Object)new class_3785((class_6880)empty, (List)ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"bastion/units/air_base", (class_6880)bastionGenericDegradation), (Object)1)), class_3785.class_3786.field_16687)), 6, (class_6122)class_6121.method_35383((class_5843)class_5843.method_33841((int)33)), false));
            });
            this.put("bastion_remnant_hoglin_stable", l -> {
                class_5455 regs = l.method_30349();
                class_7225.class_7226 processorLists = regs.method_46762(class_7924.field_41247);
                class_6880.class_6883 bastionGenericDegradation = processorLists.method_46747(class_5469.field_26280);
                class_7225.class_7226 pools = regs.method_46762(class_7924.field_41249);
                class_6880.class_6883 empty = pools.method_46747(class_5468.field_26254);
                return FeatureGenerator.spawnCustomStructure((class_3195)new class_5434(new class_3195.class_7302((class_6885)l.method_30349().method_30530(class_7924.field_41236).method_40260(class_6908.field_36505), Map.of(), class_2893.class_2895.field_13173, class_5847.field_28922), class_6880.method_40223((Object)new class_3785((class_6880)empty, (List)ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"bastion/hoglin_stable/air_base", (class_6880)bastionGenericDegradation), (Object)1)), class_3785.class_3786.field_16687)), 6, (class_6122)class_6121.method_35383((class_5843)class_5843.method_33841((int)33)), false));
            });
            this.put("bastion_remnant_treasure", l -> {
                class_5455 regs = l.method_30349();
                class_7225.class_7226 processorLists = regs.method_46762(class_7924.field_41247);
                class_6880.class_6883 bastionGenericDegradation = processorLists.method_46747(class_5469.field_26280);
                class_7225.class_7226 pools = regs.method_46762(class_7924.field_41249);
                class_6880.class_6883 empty = pools.method_46747(class_5468.field_26254);
                return FeatureGenerator.spawnCustomStructure((class_3195)new class_5434(new class_3195.class_7302((class_6885)l.method_30349().method_30530(class_7924.field_41236).method_40260(class_6908.field_36505), Map.of(), class_2893.class_2895.field_13173, class_5847.field_28922), class_6880.method_40223((Object)new class_3785((class_6880)empty, (List)ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"bastion/treasure/big_air_full", (class_6880)bastionGenericDegradation), (Object)1)), class_3785.class_3786.field_16687)), 6, (class_6122)class_6121.method_35383((class_5843)class_5843.method_33841((int)33)), false));
            });
            this.put("bastion_remnant_bridge", l -> {
                class_5455 regs = l.method_30349();
                class_7225.class_7226 processorLists = regs.method_46762(class_7924.field_41247);
                class_6880.class_6883 bastionGenericDegradation = processorLists.method_46747(class_5469.field_26280);
                class_7225.class_7226 pools = regs.method_46762(class_7924.field_41249);
                class_6880.class_6883 empty = pools.method_46747(class_5468.field_26254);
                return FeatureGenerator.spawnCustomStructure((class_3195)new class_5434(new class_3195.class_7302((class_6885)l.method_30349().method_30530(class_7924.field_41236).method_40260(class_6908.field_36505), Map.of(), class_2893.class_2895.field_13173, class_5847.field_28922), class_6880.method_40223((Object)new class_3785((class_6880)empty, (List)ImmutableList.of((Object)Pair.of((Object)class_3784.method_30435((String)"bastion/bridge/starting_pieces/entrance_base", (class_6880)bastionGenericDegradation), (Object)1)), class_3785.class_3786.field_16687)), 6, (class_6122)class_6121.method_35383((class_5843)class_5843.method_33841((int)33)), false));
            });
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static synchronized Boolean plop(String featureName, class_3218 world, class_2338 pos) {
        class_2975<?, ?> configuredStandard;
        class_3195 configuredStandard2;
        Function<class_3218, Thing> custom = featureMap.get(featureName);
        if (custom != null) {
            return custom.apply(world).plop(world, pos);
        }
        class_2960 id = new class_2960(featureName);
        class_3195 structure = (class_3195)world.method_30349().method_30530(class_7924.field_41246).method_10223(id);
        if (structure != null) {
            return FeatureGenerator.plopAnywhere(structure, world, pos, world.method_14178().method_12129(), false);
        }
        class_2975 configuredFeature = (class_2975)world.method_30349().method_30530(class_7924.field_41239).method_10223(id);
        if (configuredFeature != null) {
            ThreadLocal<Boolean> checks = Vanilla.skipGenerationChecks(world);
            checks.set(true);
            try {
                Boolean bl = configuredFeature.method_12862((class_5281)world, world.method_14178().method_12129(), world.field_9229, pos);
                return bl;
            }
            finally {
                checks.set(false);
            }
        }
        Optional structureType = world.method_30349().method_30530(class_7924.field_41231).method_17966(id);
        if (structureType.isPresent() && (configuredStandard2 = FeatureGenerator.getDefaultFeature((class_7151)structureType.get(), world, pos)) != null) {
            return FeatureGenerator.plopAnywhere(configuredStandard2, world, pos, world.method_14178().method_12129(), false);
        }
        class_3031 feature = (class_3031)world.method_30349().method_30530(class_7924.field_41267).method_10223(id);
        if (feature != null && (configuredStandard = FeatureGenerator.getDefaultFeature(feature, world, pos, true)) != null) {
            ThreadLocal<Boolean> checks = Vanilla.skipGenerationChecks(world);
            checks.set(true);
            try {
                Boolean bl = configuredStandard.method_12862((class_5281)world, world.method_14178().method_12129(), world.field_9229, pos);
                return bl;
            }
            finally {
                checks.set(false);
            }
        }
        return null;
    }

    @Nullable
    public static class_3195 resolveConfiguredStructure(String name, class_3218 world, class_2338 pos) {
        class_2960 id = new class_2960(name);
        class_3195 configuredStructureFeature = (class_3195)world.method_30349().method_30530(class_7924.field_41246).method_10223(id);
        if (configuredStructureFeature != null) {
            return configuredStructureFeature;
        }
        class_7151 structureFeature = (class_7151)world.method_30349().method_30530(class_7924.field_41231).method_10223(id);
        if (structureFeature == null) {
            return null;
        }
        return FeatureGenerator.getDefaultFeature(structureFeature, world, pos);
    }

    public static synchronized boolean plopGrid(class_3195 structureFeature, class_3218 world, class_2338 pos) {
        return FeatureGenerator.plopAnywhere(structureFeature, world, pos, world.method_14178().method_12129(), true);
    }

    private static Thing simplePlop(class_2975<?, ?> feature) {
        return (w, p) -> {
            ThreadLocal<Boolean> checks = Vanilla.skipGenerationChecks(w);
            checks.set(true);
            try {
                Boolean bl = feature.method_12862((class_5281)w, w.method_14178().method_12129(), w.field_9229, p);
                return bl;
            }
            finally {
                checks.set(false);
            }
        };
    }

    private static <FC extends class_3037, F extends class_3031<FC>> Thing simplePlop(F feature, FC config) {
        return FeatureGenerator.simplePlop(new class_2975(feature, config));
    }

    private static Thing simpleTree(class_4643 config) {
        return FeatureGenerator.simplePlop(new class_2975(class_3031.field_24134, (class_3037)config));
    }

    private static Thing spawnCustomStructure(class_3195 structure) {
        return FeatureGenerator.setupCustomStructure(structure, false);
    }

    private static Thing setupCustomStructure(class_3195 structure, boolean wireOnly) {
        return (w, p) -> FeatureGenerator.plopAnywhere(structure, w, p, w.method_14178().method_12129(), wireOnly);
    }

    private static class_3195 getDefaultFeature(class_7151<?> structure, class_3218 world, class_2338 pos) {
        class_6880 existingBiome = world.method_23753(pos);
        class_3195 result = null;
        Iterator<class_3195> iterator = world.method_30349().method_30530(class_7924.field_41246).method_29722().stream().filter(cS -> ((class_3195)cS.getValue()).method_41618() == structure).map(Map.Entry::getValue).toList().iterator();
        while (iterator.hasNext()) {
            class_3195 confstr;
            result = confstr = iterator.next();
            if (!confstr.method_41607().method_40241(existingBiome)) continue;
            return result;
        }
        return result;
    }

    private static class_2975<?, ?> getDefaultFeature(class_3031<?> feature, class_3218 world, class_2338 pos, boolean tryHard) {
        List configuredStepFeatures = ((class_1959)world.method_23753(pos).comp_349()).method_30970().method_30983();
        for (class_6885 step : configuredStepFeatures) {
            for (class_6880 provider : step) {
                if (((class_2975)((class_6796)provider.comp_349()).comp_334().comp_349()).comp_332() != feature) continue;
                return (class_2975)((class_6796)provider.comp_349()).comp_334().comp_349();
            }
        }
        if (!tryHard) {
            return null;
        }
        return world.method_30349().method_30530(class_7924.field_41239).method_29722().stream().filter(cS -> ((class_2975)cS.getValue()).comp_332() == feature).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public static <T extends class_3037> class_3449 shouldStructureStartAt(class_3218 world, class_2338 pos, class_3195 structure, boolean computeBox) {
        class_3215 chunkSource = world.method_14178();
        class_7138 seed = chunkSource.method_41248();
        class_2794 generator = chunkSource.method_12129();
        class_7869 structureState = chunkSource.method_46642();
        List structureConfig = structureState.method_46708(class_6880.method_40223((Object)structure));
        class_1923 chunkPos = new class_1923(pos);
        boolean couldPlace = structureConfig.stream().anyMatch(p -> p.method_41639(structureState, chunkPos.field_9181, chunkPos.field_9180));
        if (!couldPlace) {
            return null;
        }
        class_6885 structureBiomes = structure.method_41607();
        if (!computeBox) {
            if (structure.method_47932(new class_3195.class_7149(world.method_30349(), generator, generator.method_12098(), seed, world.method_14183(), world.method_8412(), chunkPos, (class_5539)world, arg_0 -> ((class_6885)structureBiomes).method_40241(arg_0))).isPresent()) {
                return class_3449.field_16713;
            }
        } else {
            class_3449 filledStructure = structure.method_41614(world.method_30349(), generator, generator.method_12098(), seed, world.method_14183(), world.method_8412(), chunkPos, 0, (class_5539)world, arg_0 -> ((class_6885)structureBiomes).method_40241(arg_0));
            if (filledStructure != null && filledStructure.method_16657()) {
                return filledStructure;
            }
        }
        return null;
    }

    private static class_4643.class_4644 createTree(class_2248 block, class_2248 block2, int i, int j, int k, int l) {
        return new class_4643.class_4644((class_4651)class_4651.method_38432((class_2248)block), (class_5141)new class_5140(i, j, k), (class_4651)class_4651.method_38432((class_2248)block2), (class_4647)new class_4646((class_6017)class_6016.method_34998((int)l), (class_6017)class_6016.method_34998((int)0), 3), (class_5201)new class_5204(1, 0, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean plopAnywhere(class_3195 structure, class_3218 world, class_2338 pos, class_2794 generator, boolean wireOnly) {
        ThreadLocal<Boolean> checks = Vanilla.skipGenerationChecks(world);
        checks.set(true);
        try {
            class_3449 start = structure.method_41614(world.method_30349(), generator, generator.method_12098(), world.method_14178().method_41248(), world.method_14183(), world.method_8412(), new class_1923(pos), 0, (class_5539)world, b -> true);
            if (start == class_3449.field_16713) {
                boolean bl = false;
                return bl;
            }
            class_5819 rand = class_5819.method_43049((long)world.method_8409().method_43054());
            int j = pos.method_10263() >> 4;
            int k = pos.method_10260() >> 4;
            long chId = class_1923.method_8331((int)j, (int)k);
            world.method_8497(j, k).method_12184(structure, start);
            world.method_8497(j, k).method_12182(structure, chId);
            class_3341 box = start.method_14969();
            if (!wireOnly) {
                class_2378 registry3 = world.method_30349().method_30530(class_7924.field_41246);
                world.method_36972(() -> {
                    Objects.requireNonNull(structure);
                    return registry3.method_29113((Object)structure).map(Object::toString).orElseGet(structure::toString);
                });
                start.method_14974((class_5281)world, world.method_27056(), generator, rand, box, new class_1923(j, k));
            }
            int i = Math.max(box.method_35414(), box.method_14663()) / 16 + 1;
            for (int k1 = j - i; k1 <= j + i; ++k1) {
                for (int l1 = k - i; l1 <= k + i; ++l1) {
                    if (k1 == j && l1 == k || !box.method_14669(k1 << 4, l1 << 4, (k1 << 4) + 15, (l1 << 4) + 15)) continue;
                    world.method_8497(k1, l1).method_12182(structure, chId);
                }
            }
        }
        catch (Exception booboo) {
            CarpetScriptServer.LOG.error("Unknown Exception while plopping structure: " + booboo, (Throwable)booboo);
            boolean bl = false;
            return bl;
        }
        finally {
            checks.set(false);
        }
        return true;
    }

    @FunctionalInterface
    private static interface Thing {
        public Boolean plop(class_3218 var1, class_2338 var2);
    }
}

