/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.api.MoobloomVariant;
import com.faboslav.friendsandfoes.api.MoobloomVariantManager;
import com.faboslav.friendsandfoes.init.FriendsAndFoesBlocks;
import com.faboslav.friendsandfoes.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.init.FriendsAndFoesSoundEvents;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1430;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5147;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public final class MoobloomEntity
extends class_1430
implements class_5147 {
    public static final String VARIANT_NBT_NAME = "Variant";
    public static final String FLOWER_NBT_NAME = "Flower";
    private static final class_2940<String> VARIANT = class_2945.method_12791(MoobloomEntity.class, (class_2941)class_2943.field_13326);

    public MoobloomEntity(class_1299<? extends class_1430> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static boolean canSpawn(class_1299<MoobloomEntity> moobloomEntityType, class_5425 serverWorldAccess, class_3730 spawnReason, class_2338 blockPos, class_5819 random) {
        return serverWorldAccess.method_8320(blockPos.method_10074()).method_27852(class_2246.field_10219) && MoobloomEntity.method_39448((class_1920)serverWorldAccess, (class_2338)blockPos);
    }

    public class_1315 method_5943(class_5425 serverWorldAccess, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        MoobloomVariant possibleMoobloomVariant = MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getRandomBiomeSpecificMoobloomVariant(serverWorldAccess, this.method_24515());
        if (possibleMoobloomVariant != null) {
            this.setVariant(possibleMoobloomVariant);
        } else {
            this.setVariant(MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getRandomMoobloomVariant(serverWorldAccess.method_8409()));
        }
        return super.method_5943(serverWorldAccess, difficulty, spawnReason, entityData, entityNbt);
    }

    public boolean method_27072() {
        return this.method_5805() && !this.method_6109();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getDefaultMoobloomVariant().getName());
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582(VARIANT_NBT_NAME, this.getVariant().getName());
        nbt.method_10582(FLOWER_NBT_NAME, this.getVariant().getFlowerName());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        MoobloomVariant moobloomVariant = MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getMoobloomVariantByName(nbt.method_10558(VARIANT_NBT_NAME));
        if (moobloomVariant == null) {
            moobloomVariant = MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getDefaultMoobloomVariant();
        }
        this.setVariant(moobloomVariant);
    }

    public void method_6636(class_3419 shearedSoundCategory) {
        class_1937 world = this.method_37908();
        world.method_43129(null, (class_1297)this, class_3417.field_14705, shearedSoundCategory, 1.0f, 1.0f);
        if (world.method_8608()) {
            return;
        }
        ((class_3218)world).method_14199((class_2394)class_2398.field_11236, this.method_23317(), this.method_23323(0.5), this.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
        this.method_31472();
        class_1430 cowEntity = (class_1430)class_1299.field_6085.method_5883(world);
        if (cowEntity == null) {
            return;
        }
        cowEntity.method_6033(this.method_6032());
        cowEntity.method_5719((class_1297)this);
        cowEntity.field_6220 = this.field_6220;
        cowEntity.field_6283 = this.field_6283;
        cowEntity.field_6259 = this.field_6259;
        cowEntity.field_6241 = this.field_6241;
        if (this.method_16914()) {
            cowEntity.method_5665(this.method_5797());
            cowEntity.method_5880(this.method_5807());
        }
        if (this.method_5947()) {
            cowEntity.method_5971();
        }
        cowEntity.method_5684(this.method_5655());
        world.method_8649((class_1297)cowEntity);
        for (int i = 0; i < 5; ++i) {
            world.method_8649((class_1297)new class_1542(world, this.method_23317(), this.method_23323(1.0), this.method_23321(), new class_1799((class_1935)this.getVariant().getFlower())));
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        MoobloomVariant moobloomVariant = MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getByFlowerItem(itemStack.method_7909());
        if (moobloomVariant != null && moobloomVariant != this.getVariant()) {
            this.setVariant(moobloomVariant);
            this.method_5783(FriendsAndFoesSoundEvents.ENTITY_MOOBLOOM_CONVERT.get(), 2.0f, 1.0f);
            boolean isClientWorld = this.method_37908().method_8608();
            if (!isClientWorld) {
                itemStack.method_7956(1, (class_1309)player, playerx -> playerx.method_20236(hand));
            }
            return class_1269.method_29236((boolean)isClientWorld);
        }
        if (itemStack.method_7909() == class_1802.field_8868 && this.method_27072()) {
            this.method_6636(class_3419.field_15248);
            this.method_32875(class_5712.field_28730, (class_1297)player);
            boolean isClientWorld = this.method_37908().method_8608();
            if (!isClientWorld) {
                itemStack.method_7956(1, (class_1309)player, playerx -> playerx.method_20236(hand));
            }
            return class_1269.method_29236((boolean)isClientWorld);
        }
        return super.method_5992(player, hand);
    }

    public MoobloomEntity createChild(class_3218 serverWorld, class_1296 entity) {
        MoobloomVariant moobloomVariant = this.getVariant();
        if (this.method_6051().method_39332(0, 1) == 0) {
            moobloomVariant = ((MoobloomEntity)entity).getVariant();
        }
        MoobloomEntity moobloom = (MoobloomEntity)FriendsAndFoesEntityTypes.MOOBLOOM.get().method_5883((class_1937)serverWorld);
        moobloom.setVariant(moobloomVariant);
        return moobloom;
    }

    public void method_6007() {
        class_2248 blockUnderneath;
        super.method_6007();
        if (this.method_37908().method_8608() || this.method_6109()) {
            return;
        }
        if ((double)this.method_6051().method_43057() <= 1.6666666E-4 && (blockUnderneath = this.method_37908().method_8320(new class_2338((int)this.method_23317(), (int)this.method_23318() - 1, (int)this.method_23321())).method_26204()) == class_2246.field_10219 && this.method_37908().method_22347(this.method_24515())) {
            class_2261 flower = this.getVariant().getFlower();
            if (MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getMoobloomVariants().size() == 1) {
                int flowerChance = this.method_6051().method_39332(1, 100);
                if (flowerChance >= 0 && flowerChance < 40) {
                    this.method_37908().method_8501(this.method_24515(), FriendsAndFoesBlocks.BUTTERCUP.get().method_9564());
                } else if (flowerChance >= 40 && flowerChance < 80) {
                    this.method_37908().method_8501(this.method_24515(), class_2246.field_10182.method_9564());
                } else {
                    class_2680 sunflowerBlockState = (class_2680)class_2246.field_10583.method_9564().method_11657((class_2769)class_2320.field_10929, (Comparable)class_2756.field_12609);
                    this.method_37908().method_8501(this.method_24515(), (class_2680)sunflowerBlockState.method_28493((class_2769)class_2741.field_12533));
                    this.method_37908().method_8501(this.method_24515().method_10084(), sunflowerBlockState);
                }
            } else if (flower instanceof class_2320) {
                class_2680 upperHalfBlockState = (class_2680)flower.method_9564().method_11657((class_2769)class_2320.field_10929, (Comparable)class_2756.field_12609);
                this.method_37908().method_8501(this.method_24515(), (class_2680)upperHalfBlockState.method_28493((class_2769)class_2741.field_12533));
                this.method_37908().method_8501(this.method_24515().method_10084(), upperHalfBlockState);
            } else {
                this.method_37908().method_8501(this.method_24515(), flower.method_9564());
            }
        }
    }

    public void method_5773() {
        if (!FriendsAndFoes.getConfig().enableMoobloom) {
            this.method_31472();
        }
        super.method_5773();
    }

    private void setVariant(MoobloomVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getName());
    }

    public MoobloomVariant getVariant() {
        MoobloomVariant moobloomVariant = MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getMoobloomVariantByName((String)this.field_6011.method_12789(VARIANT));
        if (moobloomVariant == null) {
            moobloomVariant = MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getDefaultMoobloomVariant();
        }
        return moobloomVariant;
    }
}

