/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.api;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.api.MoobloomVariant;
import com.faboslav.friendsandfoes.init.FriendsAndFoesBlocks;
import com.faboslav.friendsandfoes.tag.FriendsAndFoesTags;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class MoobloomVariantManager
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
    private static final MoobloomVariant DEFAULT_MOOBLOOM_VARIANT = new MoobloomVariant("buttercup", FriendsAndFoesBlocks.BUTTERCUP.get(), FriendsAndFoesTags.HAS_MOOBLOOMS);
    public static final MoobloomVariantManager MOOBLOOM_VARIANT_MANAGER = new MoobloomVariantManager();
    private List<MoobloomVariant> moobloomVariants = new ArrayList<MoobloomVariant>(){
        {
            this.add(DEFAULT_MOOBLOOM_VARIANT);
        }
    };

    private MoobloomVariantManager() {
        super(GSON, "moobloom_variants");
    }

    protected void apply(Map<class_2960, JsonElement> loader, class_3300 manager, class_3695 profiler) {
        ArrayList<MoobloomVariant> parsedMoobloomVariants = new ArrayList<MoobloomVariant>();
        parsedMoobloomVariants.add(DEFAULT_MOOBLOOM_VARIANT);
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                JsonObject jsonObject = (JsonObject)GSON.fromJson((JsonElement)jsonElement.getAsJsonObject(), JsonObject.class);
                if (jsonObject != null) {
                    String name = jsonObject.get("name").getAsString();
                    String flowerBlockRaw = jsonObject.get("flower_block").getAsString();
                    class_2261 flowerBlock = (class_2261)class_7923.field_41175.method_10223(new class_2960(flowerBlockRaw));
                    String biomes = jsonObject.get("biomes").getAsString();
                    class_6862 biomesValue = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960(biomes.replaceFirst("#", "")));
                    parsedMoobloomVariants.add(new MoobloomVariant(name, (class_2248)flowerBlock, (class_6862<class_1959>)biomesValue));
                }
            }
            catch (Exception e) {
                FriendsAndFoes.getLogger().error("Friends&Foes Error: Couldn't parse moobloom variant {}", fileIdentifier, (Object)e);
            }
        });
        this.setMoobloomVariants(parsedMoobloomVariants);
    }

    public void setMoobloomVariants(List<MoobloomVariant> moobloomVariants) {
        this.moobloomVariants = moobloomVariants;
    }

    public List<MoobloomVariant> getMoobloomVariants() {
        return this.moobloomVariants;
    }

    public MoobloomVariant getDefaultMoobloomVariant() {
        return this.getMoobloomVariantByName(DEFAULT_MOOBLOOM_VARIANT.getName());
    }

    public MoobloomVariant getRandomMoobloomVariant(class_5819 random) {
        Object[] values = this.getMoobloomVariants().toArray();
        int min = 0;
        int max = values.length - 1;
        return (MoobloomVariant)values[random.method_43048(max - min + 1) + min];
    }

    @Nullable
    public MoobloomVariant getMoobloomVariantByName(String name) {
        for (MoobloomVariant moobloomVariant : this.getMoobloomVariants()) {
            if (!Objects.equals(moobloomVariant.getName(), name)) continue;
            return moobloomVariant;
        }
        return null;
    }

    @Nullable
    public MoobloomVariant getRandomBiomeSpecificMoobloomVariant(class_5425 serverWorldAccess, class_2338 blockPos) {
        ArrayList<MoobloomVariant> possibleMoobloomVariants = new ArrayList<MoobloomVariant>();
        class_6880 biome = serverWorldAccess.method_23753(blockPos);
        for (MoobloomVariant moobloomVariant : this.getMoobloomVariants()) {
            if (!biome.method_40220(moobloomVariant.getBiomes())) continue;
            possibleMoobloomVariants.add(moobloomVariant);
        }
        if (possibleMoobloomVariants.isEmpty()) {
            return null;
        }
        return (MoobloomVariant)possibleMoobloomVariants.get(serverWorldAccess.method_8409().method_43048(possibleMoobloomVariants.size()));
    }

    @Nullable
    public MoobloomVariant getByFlowerItem(class_1792 flowerItem) {
        for (MoobloomVariant moobloomVariant : this.getMoobloomVariants()) {
            if (moobloomVariant.getFlowerAsItem() != flowerItem) continue;
            return moobloomVariant;
        }
        return null;
    }
}

